/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.renderer;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import hudson.model.Run;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;

public class ProjectNameRenderer
implements MeasurementRenderer<Run<?, ?>> {
    private String customPrefix;
    private String customProjectName;

    public ProjectNameRenderer(String customPrefix, String customProjectName) {
        this.customPrefix = Strings.emptyToNull((String)customPrefix);
        this.customProjectName = Strings.emptyToNull((String)customProjectName);
    }

    @Override
    public String render(Run<?, ?> input) {
        return this.measurementName(this.projectName(this.customPrefix, this.customProjectName, input));
    }

    protected String projectName(String prefix, String projectName, Run<?, ?> build) {
        if (this.customProjectName == null) {
            this.customProjectName = build.getParent().getName();
        }
        return Joiner.on((String)"_").skipNulls().join((Object)Strings.emptyToNull((String)prefix), (Object)Strings.emptyToNull((String)this.customProjectName), new Object[0]);
    }

    protected String measurementName(String measurement) {
        return measurement.replaceAll("-", "_");
    }
}

