/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.global;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkinsci.plugins.influxdb.InfluxDbPublicationService;
import jenkinsci.plugins.influxdb.InfluxDbPublisher;
import jenkinsci.plugins.influxdb.models.Target;
import org.apache.commons.lang3.StringUtils;

@Extension
public class GlobalRunListener
extends RunListener<Run<?, ?>> {
    public void onCompleted(Run<?, ?> build, @Nonnull TaskListener listener) {
        String path = build.getParent().getRelativeNameFrom((ItemGroup)Jenkins.getInstance());
        Target[] targets = InfluxDbPublisher.DESCRIPTOR.getTargets();
        if (targets != null) {
            ArrayList<Target> selectedTargets = new ArrayList<Target>();
            for (Target target : targets) {
                if (!this.isTargetMatchingPath(target, path) || this.isPublicationInBuild(target, build)) continue;
                selectedTargets.add(target);
            }
            if (!selectedTargets.isEmpty()) {
                InfluxDbPublicationService publicationService = new InfluxDbPublicationService(selectedTargets, null, null, null, null, null, null, System.currentTimeMillis() * 1000000L, null, null, "jenkins_data", true);
                publicationService.perform(build, listener);
            }
        }
    }

    private boolean isPublicationInBuild(Target target, Run<?, ?> build) {
        Job parent = build.getParent();
        if (parent instanceof AbstractProject) {
            InfluxDbPublisher publisher = (InfluxDbPublisher)((AbstractProject)parent).getPublishersList().get(InfluxDbPublisher.class);
            if (publisher != null) {
                String buildTarget = publisher.getSelectedTarget();
                return buildTarget != null && StringUtils.equals((CharSequence)buildTarget, (CharSequence)target.getDescription());
            }
            return false;
        }
        return false;
    }

    private boolean isTargetMatchingPath(@Nonnull Target target, @Nonnull String path) {
        if (target.isGlobalListener()) {
            String pattern = target.getGlobalListenerFilter();
            return StringUtils.isBlank((CharSequence)pattern) || Pattern.matches(pattern, path);
        }
        return false;
    }
}

