/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.influxdb.dto.Point;

public class SonarQubePointGenerator
extends AbstractPointGenerator {
    private static final String BUILD_DISPLAY_NAME = "display_name";
    private static final String SONARQUBE_LINES_OF_CODE = "lines_of_code";
    private static final String SONARQUBE_COMPLEXITY = "complexity";
    private static final String SONARQUBE_CRITICAL_ISSUES = "critical_issues";
    private static final String SONARQUBE_MAJOR_ISSUES = "major_issues";
    private static final String SONARQUBE_MINOR_ISSUES = "minor_issues";
    private static final String SONARQUBE_INFO_ISSUES = "info_issues";
    private static final String SONARQUBE_BLOCKER_ISSUES = "blocker_issues";
    private static final String URL_PATTERN_IN_LOGS = ".*" + Pattern.quote("ANALYSIS SUCCESSFUL, you can browse ") + "(.*)";
    private static final String SONAR_ISSUES_BASE_URL = "/api/issues/search?ps=500&projectKeys=";
    private static final String SONAR_METRICS_BASE_URL = "/api/measures/component?metricKeys=ncloc,complexity,violations&componentKey=";
    private String SONAR_ISSUES_URL;
    private String SONAR_METRICS_URL;
    private String sonarServer;
    private String sonarProjectName;
    private final Run<?, ?> build;
    private final String customPrefix;
    private final TaskListener listener;

    public SonarQubePointGenerator(MeasurementRenderer<Run<?, ?>> measurementRenderer, String customPrefix, Run<?, ?> build, long timestamp, TaskListener listener, boolean replaceDashWithUnderscore) {
        super(measurementRenderer, timestamp, replaceDashWithUnderscore);
        this.build = build;
        this.customPrefix = customPrefix;
        this.listener = listener;
    }

    @Override
    public boolean hasReport() {
        String sonarBuildLink = null;
        try {
            sonarBuildLink = this.getSonarProjectURLFromBuildLogs(this.build);
            if (!StringUtils.isEmpty((CharSequence)sonarBuildLink)) {
                this.setSonarDetails(sonarBuildLink);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void setSonarDetails(String sonarBuildLink) {
        try {
            this.sonarProjectName = this.getSonarProjectName(sonarBuildLink);
            String url = "";
            try {
                url = (String)this.build.getEnvironment(this.listener).get((Object)"SONAR_HOST_URL");
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            this.sonarServer = url != null && !url.isEmpty() ? url : (sonarBuildLink.indexOf("/dashboard?id=" + this.sonarProjectName) > 0 ? sonarBuildLink.substring(0, sonarBuildLink.indexOf("/dashboard?id=" + this.sonarProjectName)) : sonarBuildLink.substring(0, sonarBuildLink.indexOf("/dashboard/index/" + this.sonarProjectName)));
            this.SONAR_ISSUES_URL = this.sonarServer + SONAR_ISSUES_BASE_URL + this.sonarProjectName + "&resolved=false&severities=";
            this.SONAR_METRICS_URL = this.sonarServer + SONAR_METRICS_BASE_URL + this.sonarProjectName;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    @Override
    public Point[] generate() {
        Point point = null;
        try {
            point = this.buildPoint(this.measurementName("sonarqube_data"), this.customPrefix, this.build).addField(BUILD_DISPLAY_NAME, this.build.getDisplayName()).addField(SONARQUBE_CRITICAL_ISSUES, (long)this.getSonarIssues(this.SONAR_ISSUES_URL, "CRITICAL")).addField(SONARQUBE_BLOCKER_ISSUES, (long)this.getSonarIssues(this.SONAR_ISSUES_URL, "BLOCKER")).addField(SONARQUBE_MAJOR_ISSUES, (long)this.getSonarIssues(this.SONAR_ISSUES_URL, "MAJOR")).addField(SONARQUBE_MINOR_ISSUES, (long)this.getSonarIssues(this.SONAR_ISSUES_URL, "MINOR")).addField(SONARQUBE_INFO_ISSUES, (long)this.getSonarIssues(this.SONAR_ISSUES_URL, "INFO")).addField(SONARQUBE_LINES_OF_CODE, (long)this.getLinesOfCode(this.SONAR_METRICS_URL)).build();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Point[]{point};
    }

    public String getResult(String request) throws IOException {
        StringBuilder result = new StringBuilder();
        try {
            String auth = "";
            try {
                String token = (String)this.build.getEnvironment(this.listener).get((Object)"SONAR_AUTH_TOKEN");
                if (token != null) {
                    token = token + ":";
                    String encoding = Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
                    auth = "Basic " + encoding;
                }
            }
            catch (IOException | InterruptedException token) {
                // empty catch block
            }
            URL url = new URL(request);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (!auth.isEmpty()) {
                conn.setRequestProperty("Authorization", auth);
            }
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode() + " from URL : " + conn.getURL());
            }
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String line;
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
            }
            conn.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSonarProjectURLFromBuildLogs(Run<?, ?> build) throws IOException {
        BufferedReader br = null;
        String url = null;
        try {
            String strLine;
            br = new BufferedReader(build.getLogReader());
            Pattern p = Pattern.compile(URL_PATTERN_IN_LOGS);
            while ((strLine = br.readLine()) != null) {
                Matcher match = p.matcher(strLine);
                if (!match.matches()) continue;
                url = match.group(1);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(br);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)br);
        return url;
    }

    protected String getSonarProjectName(String url) throws URISyntaxException {
        String[] projectUrl;
        URI uri = new URI(url);
        try {
            projectUrl = uri.getRawQuery().split("id=");
        }
        catch (NullPointerException e) {
            projectUrl = uri.getRawPath().split("/");
        }
        return projectUrl.length > 1 ? projectUrl[projectUrl.length - 1] : "";
    }

    public int getLinesOfCode(String url) throws IOException {
        String output = this.getResult(url);
        JSONObject metricsObjects = JSONObject.fromObject((Object)output);
        int linesOfCodeCount = 0;
        JSONArray array = metricsObjects.getJSONObject("component").getJSONArray("measures");
        for (int i = 0; i < array.size(); ++i) {
            JSONObject metricsObject = array.getJSONObject(i);
            if (!metricsObject.get("metric").equals("ncloc")) continue;
            linesOfCodeCount = metricsObject.getInt("value");
        }
        return linesOfCodeCount;
    }

    public int getSonarIssues(String url, String severity) throws IOException {
        String output = this.getResult(url + severity);
        return JSONObject.fromObject((Object)output).getInt("total");
    }
}

