/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.Run;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.model.RobotCaseResult;
import hudson.plugins.robot.model.RobotResult;
import hudson.plugins.robot.model.RobotSuiteResult;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.generators.TimeGenerator;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import org.influxdb.dto.Point;

public class RobotFrameworkPointGenerator
extends AbstractPointGenerator {
    private static final String RF_NAME = "rf_name";
    private static final String RF_FAILED = "rf_failed";
    private static final String RF_PASSED = "rf_passed";
    private static final String RF_TOTAL = "rf_total";
    private static final String RF_CRITICAL_FAILED = "rf_critical_failed";
    private static final String RF_CRITICAL_PASSED = "rf_critical_passed";
    private static final String RF_CRITICAL_TOTAL = "rf_critical_total";
    private static final String RF_CRITICAL_PASS_PERCENTAGE = "rf_critical_pass_percentage";
    private static final String RF_PASS_PERCENTAGE = "rf_pass_percentage";
    private static final String RF_DURATION = "rf_duration";
    private static final String RF_SUITES = "rf_suites";
    private static final String RF_SUITE_NAME = "rf_suite_name";
    private static final String RF_TESTCASES = "rf_testcases";
    private static final String RF_TAG_NAME = "rf_tag_name";
    private final Run<?, ?> build;
    private final String customPrefix;
    private final Map<String, RobotTagResult> tagResults;

    public RobotFrameworkPointGenerator(MeasurementRenderer<Run<?, ?>> projectNameRenderer, String customPrefix, Run<?, ?> build, long timestamp, boolean replaceDashWithUnderscore) {
        super(projectNameRenderer, timestamp, replaceDashWithUnderscore);
        this.build = build;
        this.customPrefix = customPrefix;
        this.tagResults = new Hashtable<String, RobotTagResult>();
    }

    @Override
    public boolean hasReport() {
        RobotBuildAction robotBuildAction = (RobotBuildAction)this.build.getAction(RobotBuildAction.class);
        return robotBuildAction != null && robotBuildAction.getResult() != null;
    }

    @Override
    public Point[] generate() {
        RobotBuildAction robotBuildAction = (RobotBuildAction)this.build.getAction(RobotBuildAction.class);
        ArrayList<Point> pointsList = new ArrayList<Point>();
        pointsList.add(this.generateOverviewPoint(robotBuildAction));
        pointsList.addAll(this.generateSubPoints(robotBuildAction.getResult()));
        return pointsList.toArray(new Point[0]);
    }

    private Point generateOverviewPoint(RobotBuildAction robotBuildAction) {
        return this.buildPoint(this.measurementName("rf_results"), this.customPrefix, this.build).addField(RF_FAILED, robotBuildAction.getResult().getOverallFailed()).addField(RF_PASSED, robotBuildAction.getResult().getOverallPassed()).addField(RF_TOTAL, robotBuildAction.getResult().getOverallTotal()).addField(RF_CRITICAL_FAILED, robotBuildAction.getResult().getCriticalFailed()).addField(RF_CRITICAL_PASSED, robotBuildAction.getResult().getCriticalPassed()).addField(RF_CRITICAL_TOTAL, robotBuildAction.getResult().getCriticalTotal()).addField(RF_CRITICAL_PASS_PERCENTAGE, robotBuildAction.getCriticalPassPercentage()).addField(RF_PASS_PERCENTAGE, robotBuildAction.getOverallPassPercentage()).addField(RF_DURATION, robotBuildAction.getResult().getDuration()).addField(RF_SUITES, (long)robotBuildAction.getResult().getAllSuites().size()).build();
    }

    private List<Point> generateSubPoints(RobotResult robotResult) {
        ArrayList<Point> subPoints = new ArrayList<Point>();
        TimeGenerator suiteResultTime = new TimeGenerator(this.timestamp);
        for (RobotSuiteResult suiteResult : robotResult.getAllSuites()) {
            long caseTimeStamp = suiteResultTime.next();
            subPoints.add(this.generateSuitePoint(suiteResult, caseTimeStamp));
            TimeGenerator caseResultTime = new TimeGenerator(caseTimeStamp);
            for (RobotCaseResult caseResult : suiteResult.getAllCases()) {
                Point casePoint = this.generateCasePoint(caseResult, caseResultTime.next());
                if (this.casePointExists(subPoints, casePoint)) continue;
                subPoints.add(casePoint);
            }
        }
        TimeGenerator tagTime = new TimeGenerator(this.timestamp);
        for (Map.Entry<String, RobotTagResult> entry : this.tagResults.entrySet()) {
            subPoints.add(this.generateTagPoint(entry.getValue(), tagTime.next()));
        }
        return subPoints;
    }

    private boolean casePointExists(List<Point> subPoints, Point point) {
        for (Point p : subPoints) {
            try {
                String pointFields;
                String pFields = p.toString().substring(p.toString().indexOf("fields="));
                if (!pFields.equals(pointFields = point.toString().substring(point.toString().indexOf("fields=")))) continue;
                return true;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            }
        }
        return false;
    }

    private Point generateCasePoint(RobotCaseResult caseResult, long timestamp) {
        Point point = this.buildPoint(this.measurementName("testcase_point"), this.customPrefix, this.build, timestamp).tag(RF_NAME, caseResult.getName()).addField(RF_NAME, caseResult.getName()).addField(RF_SUITE_NAME, caseResult.getParent().getName()).addField(RF_CRITICAL_FAILED, caseResult.getCriticalFailed()).addField(RF_CRITICAL_PASSED, caseResult.getCriticalPassed()).addField(RF_FAILED, (long)caseResult.getFailed()).addField(RF_PASSED, (long)caseResult.getPassed()).addField(RF_DURATION, caseResult.getDuration()).build();
        for (String tag : caseResult.getTags()) {
            this.markTagResult(tag, caseResult);
        }
        return point;
    }

    private void markTagResult(String tag, RobotCaseResult caseResult) {
        if (this.tagResults.get(tag) == null) {
            this.tagResults.put(tag, new RobotTagResult(tag));
        }
        RobotTagResult tagResult = this.tagResults.get(tag);
        if (!tagResult.testCases.contains(caseResult.getDuplicateSafeName())) {
            tagResult.failed += caseResult.getFailed();
            tagResult.passed += caseResult.getPassed();
            tagResult.criticalFailed = (int)((long)tagResult.criticalFailed + caseResult.getCriticalFailed());
            tagResult.criticalPassed = (int)((long)tagResult.criticalPassed + caseResult.getCriticalPassed());
            tagResult.duration += caseResult.getDuration();
            tagResult.testCases.add(caseResult.getDuplicateSafeName());
        }
    }

    private Point generateTagPoint(RobotTagResult tagResult, long timestamp) {
        return this.buildPoint(this.measurementName("tag_point"), this.customPrefix, this.build, timestamp).tag(RF_TAG_NAME, tagResult.name).addField(RF_TAG_NAME, tagResult.name).addField(RF_CRITICAL_FAILED, (long)tagResult.criticalFailed).addField(RF_CRITICAL_PASSED, (long)tagResult.criticalPassed).addField(RF_CRITICAL_TOTAL, (long)(tagResult.criticalPassed + tagResult.criticalFailed)).addField(RF_FAILED, (long)tagResult.failed).addField(RF_PASSED, (long)tagResult.passed).addField(RF_TOTAL, (long)(tagResult.passed + tagResult.failed)).addField(RF_DURATION, tagResult.duration).build();
    }

    private Point generateSuitePoint(RobotSuiteResult suiteResult, long timestamp) {
        return this.buildPoint(this.measurementName("suite_result"), this.customPrefix, this.build, timestamp).tag(RF_SUITE_NAME, suiteResult.getName()).addField(RF_SUITE_NAME, suiteResult.getName()).addField(RF_TESTCASES, (long)suiteResult.getAllCases().size()).addField(RF_CRITICAL_FAILED, suiteResult.getCriticalFailed()).addField(RF_CRITICAL_PASSED, suiteResult.getCriticalPassed()).addField(RF_CRITICAL_TOTAL, (long)suiteResult.getCriticalTotal()).addField(RF_FAILED, (long)suiteResult.getFailed()).addField(RF_PASSED, (long)suiteResult.getPassed()).addField(RF_TOTAL, (long)suiteResult.getTotal()).addField(RF_DURATION, suiteResult.getDuration()).build();
    }

    private static final class RobotTagResult {
        protected final String name;
        protected final List<String> testCases = new ArrayList<String>();
        protected int failed = 0;
        protected int passed = 0;
        protected int criticalFailed = 0;
        protected int criticalPassed = 0;
        protected long duration = 0L;

        protected RobotTagResult(String name) {
            this.name = name;
        }
    }
}

