/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.Run;
import hudson.plugins.PerfPublisher.PerfPublisherBuildAction;
import hudson.plugins.PerfPublisher.Report.Metric;
import hudson.plugins.PerfPublisher.Report.ReportContainer;
import hudson.plugins.PerfPublisher.Report.Test;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.generators.TimeGenerator;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import org.influxdb.dto.Point;

public class PerfPublisherPointGenerator
extends AbstractPointGenerator {
    private final Run<?, ?> build;
    private final String customPrefix;
    private final PerfPublisherBuildAction performanceBuildAction;
    private final TimeGenerator timeGenerator;

    public PerfPublisherPointGenerator(MeasurementRenderer<Run<?, ?>> measurementRenderer, String customPrefix, Run<?, ?> build, long timestamp, boolean replaceDashWithUnderscore) {
        super(measurementRenderer, timestamp, replaceDashWithUnderscore);
        this.build = build;
        this.customPrefix = customPrefix;
        this.performanceBuildAction = (PerfPublisherBuildAction)build.getAction(PerfPublisherBuildAction.class);
        this.timeGenerator = new TimeGenerator(timestamp);
    }

    @Override
    public boolean hasReport() {
        return this.performanceBuildAction != null && this.performanceBuildAction.getReport() != null;
    }

    @Override
    public Point.Builder buildPoint(String name, String customPrefix, Run<?, ?> build) {
        return super.buildPoint(name, customPrefix, build).time(this.timeGenerator.next(), TimeUnit.NANOSECONDS);
    }

    @Override
    public Point[] generate() {
        ReportContainer reports = this.performanceBuildAction.getReports();
        ArrayList<Point> pointsList = new ArrayList<Point>();
        pointsList.add(this.generateSummaryPoint(reports));
        pointsList.addAll(this.generateMetricsPoints(reports));
        for (Test test : reports.getTests()) {
            pointsList.add(this.generateTestPoint(test));
            pointsList.addAll(this.generateTestMetricsPoints(test));
        }
        return pointsList.toArray(new Point[0]);
    }

    private Point generateSummaryPoint(ReportContainer reports) {
        Point.Builder builder = this.buildPoint(this.measurementName("perfpublisher_summary"), this.customPrefix, this.build).addField("number_of_tests", (long)reports.getNumberOfTest()).addField("number_of_executed_tests", (long)reports.getNumberOfExecutedTest()).addField("number_of_not_executed_tests", (long)reports.getNumberOfNotExecutedTest()).addField("number_of_passed_tests", (long)reports.getNumberOfPassedTest()).addField("number_of_failed_tests", (long)reports.getNumberOfFailedTest()).addField("number_of_success_tests", (long)reports.getNumberOfSuccessTests()).addField("number_of_true_false_tests", reports.getNumberOfTrueFalseTest());
        if (reports.getBestCompileTimeTest().isCompileTime()) {
            builder.addField("best_compile_time_test_value", reports.getBestCompileTimeTestValue()).addField("best_compile_time_test_name", reports.getBestCompileTimeTestName()).addField("worst_compile_time_test_value", reports.getWorstCompileTimeTestValue()).addField("worst_compile_time_test_name", reports.getWorstCompileTimeTestName()).addField("avg_compile_time", reports.getAverageOfCompileTime());
        }
        if (reports.getBestPerformanceTest().isPerformance()) {
            builder.addField("best_performance_test_value", reports.getBestPerformanceTestValue()).addField("best_performance_test_name", reports.getBestPerformanceTestName()).addField("worst_performance_test_value", reports.getWorstPerformanceTestValue()).addField("worst_performance_test_name", reports.getWorstPerformanceTestName()).addField("average_performance", reports.getAverageOfPerformance());
        }
        if (reports.getBestExecutionTimeTest().isExecutionTime()) {
            builder.addField("best_execution_time_test_value", reports.getBestExecutionTimeTestValue()).addField("best_execution_time_test_name", reports.getBestExecutionTimeTestName()).addField("worst_execution_time_test_value", reports.getWorstExecutionTimeTestValue()).addField("worst_execution_time_test_name", reports.getWorstExecutionTimeTestName()).addField("avg_execution_time", reports.getAverageOfExecutionTime());
        }
        return builder.build();
    }

    private List<Point> generateMetricsPoints(ReportContainer reports) {
        ArrayList<Point> pointsList = new ArrayList<Point>();
        for (Map.Entry entry : reports.getAverageValuePerMetrics().entrySet()) {
            String metricName = (String)entry.getKey();
            Point point = this.buildPoint(this.measurementName("perfpublisher_metric"), this.customPrefix, this.build).addField("metric_name", metricName).addField("average", (Number)entry.getValue()).addField("worst", (Number)reports.getWorstValuePerMetrics().get(metricName)).addField("best", (Number)reports.getBestValuePerMetrics().get(metricName)).build();
            pointsList.add(point);
        }
        return pointsList;
    }

    private Point generateTestPoint(Test test) {
        Point.Builder builder = this.buildPoint(this.measurementName("perfpublisher_test"), this.customPrefix, this.build).addField("test_name", test.getName()).tag("test_name", test.getName()).addField("successful", test.isSuccessfull()).addField("executed", test.isExecuted());
        if (test.getMessage() != null) {
            builder.addField("message", test.getMessage());
        }
        if (test.isCompileTime()) {
            builder.addField("compile_time", test.getCompileTime().getMeasure());
        }
        if (test.isExecutionTime()) {
            builder.addField("execution_time", test.getExecutionTime().getMeasure());
        }
        if (test.isPerformance()) {
            builder.addField("performance", test.getPerformance().getMeasure());
        }
        return builder.build();
    }

    private List<Point> generateTestMetricsPoints(Test test) {
        ArrayList<Point> pointsList = new ArrayList<Point>();
        for (Map.Entry entry : test.getMetrics().entrySet()) {
            String metricName = (String)entry.getKey();
            Metric metric = (Metric)entry.getValue();
            Point point = this.buildPoint(this.measurementName("perfpublisher_test_metric"), this.customPrefix, this.build).addField("test_name", test.getName()).tag("test_name", test.getName()).addField("metric_name", metricName).addField("value", metric.getMeasure()).addField("unit", metric.getUnit()).addField("relevant", metric.isRelevant()).build();
            pointsList.add(point);
        }
        return pointsList;
    }
}

