/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import hudson.EnvVars;
import hudson.model.Executor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import jenkins.metrics.impl.TimeInQueueAction;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.influxdb.dto.Point;

public class JenkinsBasePointGenerator
extends AbstractPointGenerator {
    public static final String BUILD_TIME = "build_time";
    public static final String BUILD_STATUS_MESSAGE = "build_status_message";
    public static final String TIME_IN_QUEUE = "time_in_queue";
    public static final String BUILD_SCHEDULED_TIME = "build_scheduled_time";
    public static final String BUILD_EXEC_TIME = "build_exec_time";
    public static final String BUILD_MEASURED_TIME = "build_measured_time";
    public static final String BUILD_RESULT = "build_result";
    public static final String BUILD_RESULT_ORDINAL = "build_result_ordinal";
    public static final String BUILD_IS_SUCCESSFUL = "build_successful";
    public static final String BUILD_AGENT_NAME = "build_agent_name";
    public static final String PROJECT_BUILD_HEALTH = "project_build_health";
    public static final String PROJECT_LAST_SUCCESSFUL = "last_successful_build";
    public static final String PROJECT_LAST_STABLE = "last_stable_build";
    public static final String TESTS_FAILED = "tests_failed";
    public static final String TESTS_SKIPPED = "tests_skipped";
    public static final String TESTS_TOTAL = "tests_total";
    private final Run<?, ?> build;
    private final String customPrefix;
    private final TaskListener listener;
    private final String jenkinsEnvParameterField;
    private final String jenkinsEnvParameterTag;
    private final String measurementName;

    public JenkinsBasePointGenerator(MeasurementRenderer<Run<?, ?>> projectNameRenderer, String customPrefix, Run<?, ?> build, long timestamp, TaskListener listener, String jenkinsEnvParameterField, String jenkinsEnvParameterTag, String measurementName, boolean replaceDashWithUnderscore) {
        super(projectNameRenderer, timestamp, replaceDashWithUnderscore);
        this.build = build;
        this.customPrefix = customPrefix;
        this.listener = listener;
        this.jenkinsEnvParameterField = jenkinsEnvParameterField;
        this.jenkinsEnvParameterTag = jenkinsEnvParameterTag;
        this.measurementName = measurementName;
    }

    @Override
    public boolean hasReport() {
        return true;
    }

    @Override
    public Point[] generate() {
        int ordinal;
        String result;
        long startTime = this.build.getTimeInMillis();
        long currTime = System.currentTimeMillis();
        long dt = currTime - startTime;
        Result buildResult = this.build.getResult();
        if (buildResult == null) {
            result = "?";
            ordinal = 5;
        } else {
            result = buildResult.toString();
            ordinal = buildResult.ordinal;
        }
        Point.Builder point = this.buildPoint(this.measurementName(this.measurementName), this.customPrefix, this.build);
        point.addField(BUILD_TIME, this.build.getDuration() == 0L ? dt : this.build.getDuration()).addField(BUILD_SCHEDULED_TIME, this.build.getTimeInMillis()).addField(BUILD_EXEC_TIME, this.build.getStartTimeInMillis()).addField(BUILD_MEASURED_TIME, currTime).addField(BUILD_STATUS_MESSAGE, this.build.getBuildStatusSummary().message).addField(BUILD_RESULT, result).addField(BUILD_RESULT_ORDINAL, (long)ordinal).addField(BUILD_IS_SUCCESSFUL, ordinal < 2).addField(BUILD_AGENT_NAME, this.getBuildAgentName()).addField(PROJECT_BUILD_HEALTH, (long)this.build.getParent().getBuildHealth().getScore()).addField(PROJECT_LAST_SUCCESSFUL, (long)this.getLastSuccessfulBuild()).addField(PROJECT_LAST_STABLE, (long)this.getLastStableBuild()).tag(BUILD_RESULT, result);
        if (this.hasTestResults(this.build)) {
            point.addField(TESTS_FAILED, (long)((AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class)).getFailCount());
            point.addField(TESTS_SKIPPED, (long)((AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class)).getSkipCount());
            point.addField(TESTS_TOTAL, (long)((AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class)).getTotalCount());
        }
        if (this.hasMetricsPlugin(this.build)) {
            point.addField(TIME_IN_QUEUE, ((TimeInQueueAction)this.build.getAction(TimeInQueueAction.class)).getQueuingDurationMillis());
        }
        if (StringUtils.isNotBlank((String)this.jenkinsEnvParameterField)) {
            Properties fieldProperties = this.parsePropertiesString(this.jenkinsEnvParameterField);
            Map<String, Object> fieldMap = this.resolveEnvParameterAndTransformToMap(fieldProperties);
            point.fields(fieldMap);
        }
        if (StringUtils.isNotBlank((String)this.jenkinsEnvParameterTag)) {
            Properties tagProperties = this.parsePropertiesString(this.jenkinsEnvParameterTag);
            Map<String, Object> tagMap = this.resolveEnvParameterAndTransformToMap(tagProperties);
            point.tag(tagMap);
        }
        return new Point[]{point.build()};
    }

    private String getBuildAgentName() {
        Executor executor = this.build.getExecutor();
        if (executor != null) {
            return executor.getOwner().getName();
        }
        return "";
    }

    private boolean hasTestResults(Run<?, ?> build) {
        return build.getAction(AbstractTestResultAction.class) != null;
    }

    private boolean hasMetricsPlugin(Run<?, ?> build) {
        try {
            return build.getAction(TimeInQueueAction.class) != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private int getLastSuccessfulBuild() {
        if (this.build.getParent().getLastSuccessfulBuild() != null) {
            return this.build.getParent().getLastSuccessfulBuild().getNumber();
        }
        return 0;
    }

    private int getLastStableBuild() {
        if (this.build.getParent().getLastStableBuild() != null) {
            return this.build.getParent().getLastStableBuild().getNumber();
        }
        return 0;
    }

    private Properties parsePropertiesString(String propertiesString) {
        Properties properties = new Properties();
        try {
            StringReader reader = new StringReader(propertiesString);
            properties.load(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    private Map<String, Object> resolveEnvParameterAndTransformToMap(Properties properties) {
        ImmutableMap propertiesMap = Maps.fromProperties((Properties)properties);
        return Maps.transformValues((Map)propertiesMap, (Function)new Function<String, Object>(){

            @Nullable
            public Object apply(@Nullable String value) {
                if (JenkinsBasePointGenerator.this.containsEnvParameter(value)) {
                    return JenkinsBasePointGenerator.this.resolveEnvParameter(value);
                }
                return value;
            }
        });
    }

    private boolean containsEnvParameter(String value) {
        return StringUtils.length((String)value) > 3 && StringUtils.contains((String)value, (String)"${");
    }

    private String resolveEnvParameter(String stringValue) {
        try {
            EnvVars envVars = this.build.getEnvironment(this.listener);
            return StrSubstitutor.replace((Object)stringValue, (Map)envVars);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return stringValue;
        }
    }
}

