/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.Run;
import hudson.plugins.jacoco.JacocoBuildAction;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import org.influxdb.dto.Point;

public class JacocoPointGenerator
extends AbstractPointGenerator {
    private static final String JACOCO_PACKAGE_COVERAGE_RATE = "jacoco_package_coverage_rate";
    private static final String JACOCO_CLASS_COVERAGE_RATE = "jacoco_class_coverage_rate";
    private static final String JACOCO_LINE_COVERAGE_RATE = "jacoco_line_coverage_rate";
    private static final String JACOCO_BRANCH_COVERAGE_RATE = "jacoco_branch_coverage_rate";
    private static final String JACOCO_METHOD_COVERAGE_RATE = "jacoco_method_coverage_rate";
    private static final String JACOCO_INSTRUCTION_COVERAGE_RATE = "jacoco_instruction_coverage_rate";
    private final Run<?, ?> build;
    private final String customPrefix;
    private final JacocoBuildAction jacocoBuildAction;

    public JacocoPointGenerator(MeasurementRenderer<Run<?, ?>> measurementRenderer, String customPrefix, Run<?, ?> build, long timestamp, boolean replaceDashWithUnderscore) {
        super(measurementRenderer, timestamp, replaceDashWithUnderscore);
        this.build = build;
        this.customPrefix = customPrefix;
        this.jacocoBuildAction = (JacocoBuildAction)build.getAction(JacocoBuildAction.class);
    }

    @Override
    public boolean hasReport() {
        return this.jacocoBuildAction != null && this.jacocoBuildAction.getResult() != null;
    }

    @Override
    public Point[] generate() {
        Point point = this.buildPoint(this.measurementName("jacoco_data"), this.customPrefix, this.build).addField(JACOCO_INSTRUCTION_COVERAGE_RATE, (double)this.jacocoBuildAction.getResult().getInstructionCoverage().getPercentageFloat()).addField(JACOCO_CLASS_COVERAGE_RATE, (double)this.jacocoBuildAction.getResult().getClassCoverage().getPercentageFloat()).addField(JACOCO_BRANCH_COVERAGE_RATE, (double)this.jacocoBuildAction.getResult().getBranchCoverage().getPercentageFloat()).addField(JACOCO_LINE_COVERAGE_RATE, (double)this.jacocoBuildAction.getResult().getLineCoverage().getPercentageFloat()).addField(JACOCO_METHOD_COVERAGE_RATE, (double)this.jacocoBuildAction.getResult().getMethodCoverage().getPercentageFloat()).build();
        return new Point[]{point};
    }
}

