/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.Run;
import java.util.Map;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import org.influxdb.dto.Point;

public class CustomDataPointGenerator
extends AbstractPointGenerator {
    private static final String BUILD_TIME = "build_time";
    private final Run<?, ?> build;
    private final String customPrefix;
    private final String measurementName;
    private final Map<String, Object> customData;
    private final Map<String, String> customDataTags;

    public CustomDataPointGenerator(MeasurementRenderer<Run<?, ?>> projectNameRenderer, String customPrefix, Run<?, ?> build, long timestamp, Map customData, Map<String, String> customDataTags, String measurementName, boolean replaceDashWithUnderscore) {
        super(projectNameRenderer, timestamp, replaceDashWithUnderscore);
        this.build = build;
        this.customPrefix = customPrefix;
        this.customData = customData;
        this.customDataTags = customDataTags;
        this.measurementName = "jenkins_data".equals(measurementName) ? "jenkins_custom_data" : "custom_" + measurementName;
    }

    @Override
    public boolean hasReport() {
        return this.customData != null && this.customData.size() > 0;
    }

    @Override
    public Point[] generate() {
        long startTime = this.build.getTimeInMillis();
        long currTime = System.currentTimeMillis();
        long dt = currTime - startTime;
        Point.Builder pointBuilder = this.buildPoint(this.measurementName(this.measurementName), this.customPrefix, this.build).addField(BUILD_TIME, this.build.getDuration() == 0L ? dt : this.build.getDuration()).fields(this.customData);
        if (this.customDataTags != null && this.customDataTags.size() > 0) {
            pointBuilder.tag(this.customDataTags);
        }
        Point point = pointBuilder.build();
        return new Point[]{point};
    }
}

