/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import java.util.Collection;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import org.influxdb.dto.Point;

public class ChangeLogPointGenerator
extends AbstractPointGenerator {
    private static final String BUILD_DISPLAY_NAME = "display_name";
    private final Run<?, ?> build;
    private final String customPrefix;
    private StringBuilder affectedPaths;
    private StringBuilder messages;
    private StringBuilder culprits;
    private int commitCount = 0;

    public ChangeLogPointGenerator(MeasurementRenderer<Run<?, ?>> projectNameRenderer, String customPrefix, Run<?, ?> build, long timestamp, boolean replaceDashWithUnderscore) {
        super(projectNameRenderer, timestamp, replaceDashWithUnderscore);
        this.build = build;
        this.customPrefix = customPrefix;
    }

    @Override
    public boolean hasReport() {
        if (this.build instanceof AbstractBuild) {
            this.getChangeLog(this.build);
            return this.getCommitCount() > 0;
        }
        return false;
    }

    @Override
    public Point[] generate() {
        Point.Builder point = this.buildPoint(this.measurementName("changelog_data"), this.customPrefix, this.build);
        point.addField(BUILD_DISPLAY_NAME, this.build.getDisplayName()).addField("commit_messages", this.getMessages()).addField("culprits", this.getCulprits()).addField("affected_paths", this.getAffectedPaths()).addField("commit_count", (long)this.getCommitCount());
        return new Point[]{point.build()};
    }

    public void getChangeLog(Run<?, ?> run) {
        this.affectedPaths = new StringBuilder();
        this.messages = new StringBuilder();
        this.culprits = new StringBuilder();
        AbstractBuild abstractBuild = (AbstractBuild)run;
        ChangeLogSet changeset = abstractBuild.getChangeSet();
        for (ChangeLogSet.Entry str : changeset) {
            Collection affectedFiles = str.getAffectedFiles();
            for (ChangeLogSet.AffectedFile affectedFile : affectedFiles) {
                this.affectedPaths.append(affectedFile.getPath());
                this.affectedPaths.append(", ");
            }
            this.messages.append(str.getMsg());
            this.messages.append(", ");
            this.culprits.append(str.getAuthor().getFullName());
            this.culprits.append(", ");
            ++this.commitCount;
        }
    }

    private String getMessages() {
        return this.messages.length() > 0 ? this.messages.substring(0, this.messages.length() - 2) : "";
    }

    private String getCulprits() {
        return this.culprits.length() > 0 ? this.culprits.substring(0, this.culprits.length() - 2) : "";
    }

    private String getAffectedPaths() {
        return this.affectedPaths.length() > 0 ? this.affectedPaths.substring(0, this.affectedPaths.length() - 2) : "";
    }

    private int getCommitCount() {
        return this.commitCount;
    }
}

