/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb;

import com.google.common.base.Strings;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkinsci.plugins.influxdb.InfluxReportException;
import jenkinsci.plugins.influxdb.generators.ChangeLogPointGenerator;
import jenkinsci.plugins.influxdb.generators.CoberturaPointGenerator;
import jenkinsci.plugins.influxdb.generators.CustomDataMapPointGenerator;
import jenkinsci.plugins.influxdb.generators.CustomDataPointGenerator;
import jenkinsci.plugins.influxdb.generators.JacocoPointGenerator;
import jenkinsci.plugins.influxdb.generators.JenkinsBasePointGenerator;
import jenkinsci.plugins.influxdb.generators.PerfPublisherPointGenerator;
import jenkinsci.plugins.influxdb.generators.PerformancePointGenerator;
import jenkinsci.plugins.influxdb.generators.PointGenerator;
import jenkinsci.plugins.influxdb.generators.RobotFrameworkPointGenerator;
import jenkinsci.plugins.influxdb.generators.SonarQubePointGenerator;
import jenkinsci.plugins.influxdb.models.Target;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;

public class InfluxDbPublicationService {
    private static final Logger logger = Logger.getLogger(InfluxDbPublicationService.class.getName());
    private List<Target> selectedTargets;
    private String customProjectName;
    private String customPrefix;
    private Map<String, Object> customData;
    private final Map<String, String> customDataTags;
    private final Map<String, Map<String, String>> customDataMapTags;
    private Map<String, Map<String, Object>> customDataMap;
    private final long timestamp;
    private final String jenkinsEnvParameterField;
    private final String jenkinsEnvParameterTag;
    private final String measurementName;
    private boolean replaceDashWithUnderscore;

    public InfluxDbPublicationService(List<Target> selectedTargets, String customProjectName, String customPrefix, Map<String, Object> customData, Map<String, String> customDataTags, Map<String, Map<String, String>> customDataMapTags, Map<String, Map<String, Object>> customDataMap, long timestamp, String jenkinsEnvParameterField, String jenkinsEnvParameterTag, String measurementName, boolean replaceDashWithUnderscore) {
        this.selectedTargets = selectedTargets;
        this.customProjectName = customProjectName;
        this.customPrefix = customPrefix;
        this.customData = customData;
        this.customDataTags = customDataTags;
        this.customDataMapTags = customDataMapTags;
        this.customDataMap = customDataMap;
        this.timestamp = timestamp;
        this.jenkinsEnvParameterField = jenkinsEnvParameterField;
        this.jenkinsEnvParameterTag = jenkinsEnvParameterTag;
        this.measurementName = measurementName;
        this.replaceDashWithUnderscore = replaceDashWithUnderscore;
    }

    public void perform(Run<?, ?> build, TaskListener listener) {
        listener.getLogger().println("[InfluxDB Plugin] Collecting data for publication in InfluxDB...");
        ProjectNameRenderer measurementRenderer = new ProjectNameRenderer(this.customPrefix, this.customProjectName);
        ArrayList<Point> pointsToWrite = new ArrayList<Point>();
        JenkinsBasePointGenerator jGen = new JenkinsBasePointGenerator(measurementRenderer, this.customPrefix, build, this.timestamp, listener, this.jenkinsEnvParameterField, this.jenkinsEnvParameterTag, this.measurementName, this.replaceDashWithUnderscore);
        this.addPoints(pointsToWrite, jGen, listener);
        CustomDataPointGenerator cdGen = new CustomDataPointGenerator(measurementRenderer, this.customPrefix, build, this.timestamp, this.customData, this.customDataTags, this.measurementName, this.replaceDashWithUnderscore);
        if (cdGen.hasReport()) {
            listener.getLogger().println("[InfluxDB Plugin] Custom data found. Writing to InfluxDB...");
            this.addPoints(pointsToWrite, cdGen, listener);
        } else {
            logger.log(Level.FINE, "Data source empty: Custom Data");
        }
        CustomDataMapPointGenerator cdmGen = new CustomDataMapPointGenerator(measurementRenderer, this.customPrefix, build, this.timestamp, this.customDataMap, this.customDataMapTags, this.replaceDashWithUnderscore);
        if (cdmGen.hasReport()) {
            listener.getLogger().println("[InfluxDB Plugin] Custom data map found. Writing to InfluxDB...");
            this.addPoints(pointsToWrite, cdmGen, listener);
        } else {
            logger.log(Level.FINE, "Data source empty: Custom Data Map");
        }
        try {
            CoberturaPointGenerator cGen = new CoberturaPointGenerator(measurementRenderer, this.customPrefix, build, this.timestamp, this.replaceDashWithUnderscore);
            if (cGen.hasReport()) {
                listener.getLogger().println("[InfluxDB Plugin] Cobertura data found. Writing to InfluxDB...");
                this.addPoints(pointsToWrite, cGen, listener);
            }
        }
        catch (NoClassDefFoundError ignore) {
            logger.log(Level.FINE, "Plugin skipped: Cobertura");
        }
        try {
            RobotFrameworkPointGenerator rfGen = new RobotFrameworkPointGenerator(measurementRenderer, this.customPrefix, build, this.timestamp, this.replaceDashWithUnderscore);
            if (rfGen.hasReport()) {
                listener.getLogger().println("[InfluxDB Plugin] Robot Framework data found. Writing to InfluxDB...");
                this.addPoints(pointsToWrite, rfGen, listener);
            }
        }
        catch (NoClassDefFoundError ignore) {
            logger.log(Level.FINE, "Plugin skipped: Robot Framework");
        }
        try {
            JacocoPointGenerator jacoGen = new JacocoPointGenerator(measurementRenderer, this.customPrefix, build, this.timestamp, this.replaceDashWithUnderscore);
            if (jacoGen.hasReport()) {
                listener.getLogger().println("[InfluxDB Plugin] Jacoco data found. Writing to InfluxDB...");
                this.addPoints(pointsToWrite, jacoGen, listener);
            }
        }
        catch (NoClassDefFoundError ignore) {
            logger.log(Level.FINE, "Plugin skipped: JaCoCo");
        }
        try {
            PerformancePointGenerator perfGen = new PerformancePointGenerator(measurementRenderer, this.customPrefix, build, this.timestamp, this.replaceDashWithUnderscore);
            if (perfGen.hasReport()) {
                listener.getLogger().println("[InfluxDB Plugin] Performance data found. Writing to InfluxDB...");
                this.addPoints(pointsToWrite, perfGen, listener);
            }
        }
        catch (NoClassDefFoundError ignore) {
            logger.log(Level.FINE, "Plugin skipped: Performance");
        }
        SonarQubePointGenerator sonarGen = new SonarQubePointGenerator(measurementRenderer, this.customPrefix, build, this.timestamp, listener, this.replaceDashWithUnderscore);
        if (sonarGen.hasReport()) {
            listener.getLogger().println("[InfluxDB Plugin] SonarQube data found. Writing to InfluxDB...");
            this.addPoints(pointsToWrite, sonarGen, listener);
        } else {
            logger.log(Level.FINE, "Plugin skipped: SonarQube");
        }
        ChangeLogPointGenerator changeLogGen = new ChangeLogPointGenerator(measurementRenderer, this.customPrefix, build, this.timestamp, this.replaceDashWithUnderscore);
        if (changeLogGen.hasReport()) {
            listener.getLogger().println("[InfluxDB Plugin] Git ChangeLog data found. Writing to InfluxDB...");
            this.addPoints(pointsToWrite, changeLogGen, listener);
        } else {
            logger.log(Level.FINE, "Data source empty: Change Log");
        }
        try {
            PerfPublisherPointGenerator perfPublisherGen = new PerfPublisherPointGenerator(measurementRenderer, this.customPrefix, build, this.timestamp, this.replaceDashWithUnderscore);
            if (perfPublisherGen.hasReport()) {
                listener.getLogger().println("[InfluxDB Plugin] PerfPublisher data found. Writing to InfluxDB...");
                this.addPoints(pointsToWrite, perfPublisherGen, listener);
            }
        }
        catch (NoClassDefFoundError ignore) {
            logger.log(Level.FINE, "Plugin skipped: Performance Publisher");
        }
        for (Target selectedTarget : this.selectedTargets) {
            String logMessage = "[InfluxDB Plugin] Publishing data to: " + selectedTarget;
            logger.log(Level.FINE, logMessage);
            listener.getLogger().println(logMessage);
            InfluxDB influxDB = Strings.isNullOrEmpty((String)selectedTarget.getUsername()) ? InfluxDBFactory.connect((String)selectedTarget.getUrl()) : InfluxDBFactory.connect((String)selectedTarget.getUrl(), (String)selectedTarget.getUsername(), (String)selectedTarget.getPassword());
            this.writeToInflux(selectedTarget, influxDB, pointsToWrite);
        }
        listener.getLogger().println("[InfluxDB Plugin] Completed.");
    }

    private void addPoints(List<Point> pointsToWrite, PointGenerator generator, TaskListener listener) {
        try {
            pointsToWrite.addAll(Arrays.asList(generator.generate()));
        }
        catch (Exception e) {
            listener.getLogger().println("[InfluxDB Plugin] Failed to collect data. Ignoring Exception:" + e);
        }
    }

    private void writeToInflux(Target target, InfluxDB influxDB, List<Point> pointsToWrite) {
        try {
            BatchPoints batchPoints = BatchPoints.database((String)target.getDatabase()).points(pointsToWrite.toArray(new Point[0])).retentionPolicy(target.getRetentionPolicy()).consistency(InfluxDB.ConsistencyLevel.ANY).build();
            influxDB.write(batchPoints);
        }
        catch (Exception e) {
            if (target.isExposeExceptions()) {
                throw new InfluxReportException(e);
            }
            logger.log(Level.WARNING, "Could not report to InfluxDB. Ignoring Exception.", e);
        }
    }
}

