/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb;

import hudson.model.AbstractProject;
import hudson.model.ModelObject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkinsci.plugins.influxdb.InfluxDbPublisher;
import jenkinsci.plugins.influxdb.models.Target;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Symbol(value={"influxDbPublisher"})
public final class DescriptorImpl
extends BuildStepDescriptor<Publisher>
implements ModelObject,
Serializable {
    private static final String DISPLAY_NAME = "Publish build data to InfluxDB";
    private List<Target> targets = new CopyOnWriteArrayList<Target>();

    public DescriptorImpl() {
        super(InfluxDbPublisher.class);
        this.load();
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    public void removeTarget(String targetDescription) {
        this.targets.removeIf(target -> target.getDescription().equals(targetDescription));
    }

    public Target[] getTargets() {
        return this.targets.toArray(new Target[0]);
    }

    @DataBoundSetter
    public void setTargets(List<Target> targets) {
        this.targets = targets;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        this.targets.clear();
        this.targets.addAll(req.bindJSONToList(Target.class, formData.get("targets")));
        this.save();
        return true;
    }

    public ListBoxModel doFillSelectedTargetItems() {
        ListBoxModel model = new ListBoxModel();
        for (Target target : this.targets) {
            model.add(target.getDescription());
        }
        return model;
    }
}

