/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.impliedlabels;

import antlr.ANTLRException;
import hudson.Util;
import hudson.model.Label;
import hudson.model.labels.LabelAtom;
import hudson.util.CyclicGraphDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class Implication {
    @Nonnull
    private static final Set<LabelAtom> NO_ATOMS = Collections.emptySet();
    @Nonnull
    private final Set<LabelAtom> atoms;
    @CheckForNull
    private final Label expression;

    @DataBoundConstructor
    public Implication(@Nonnull String expression, @Nonnull String atoms) {
        Label e;
        this.atoms = Collections.unmodifiableSet(Label.parse((String)atoms));
        try {
            e = Label.parseExpression((String)expression);
        }
        catch (ANTLRException ex) {
            e = null;
        }
        this.expression = e;
    }

    public String expressionString() {
        return this.expression == null ? "" : this.expression.toString();
    }

    public String atomsString() {
        return Util.join(this.atoms, (String)" ");
    }

    public Label expression() {
        return this.expression;
    }

    public Set<LabelAtom> atoms() {
        return this.atoms;
    }

    public int labelSize() {
        if (this.expression == null) {
            return 0;
        }
        return this.expression.getNodes().size() + this.expression.getClouds().size();
    }

    @Nonnull
    public Collection<LabelAtom> infer(@Nonnull Collection<LabelAtom> atoms) {
        return this.expression != null && this.expression.matches(atoms) ? this.atoms : NO_ATOMS;
    }

    public String toString() {
        return (this.expression == null ? "false" : this.expression) + " => " + this.atomsString();
    }

    public int hashCode() {
        return 31 * this.atoms.hashCode() + this.expressionString().hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        if (rhs.getClass() != this.getClass()) {
            return false;
        }
        Implication other = (Implication)rhs;
        if (!this.atoms.equals(other.atoms)) {
            return false;
        }
        return this.expression == null ? other.expression == null : this.expression.equals((Object)other.expression);
    }

    @Nonnull
    static List<Implication> sort(@Nonnull Collection<Implication> implications) throws CyclicGraphDetector.CycleDetectedException {
        ImplicationSorter sorter = new ImplicationSorter(implications);
        sorter.run(implications);
        return sorter.getSorted();
    }

    private static final class ImplicationSorter
    extends CyclicGraphDetector<Implication> {
        private final Collection<Implication> implications;

        private ImplicationSorter(Collection<Implication> implications) {
            this.implications = implications;
        }

        protected Iterable<Implication> getEdges(Implication current) {
            ArrayList<Implication> edges = new ArrayList<Implication>();
            if (current.expression == null) {
                return edges;
            }
            for (Implication i : this.implications) {
                if (i == current || i.expression == null || Collections.disjoint(current.expression.listAtoms(), i.atoms)) continue;
                edges.add(i);
            }
            return edges;
        }
    }
}

