/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.impliedlabels;

import antlr.ANTLRException;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Label;
import hudson.model.LabelFinder;
import hudson.model.ManagementLink;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.util.CyclicGraphDetector;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.impliedlabels.Implication;
import org.jenkinsci.plugins.impliedlabels.Implier;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Restricted(value={NoExternalUse.class})
public class Config
extends ManagementLink {
    @Nonnull
    private static final Logger CACHE_LOGGER = Logger.getLogger("ConfigCaching");
    @Nonnull
    @GuardedBy(value="configLock")
    private List<Implication> implications = Collections.emptyList();
    @Nonnull
    @GuardedBy(value="configLock")
    private final transient Map<Collection<LabelAtom>, Collection<LabelAtom>> cache = new HashMap<Collection<LabelAtom>, Collection<LabelAtom>>();
    private transient Object configLock = new Object();

    public Config() {
        try {
            this.load();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getDisplayName() {
        return "Label implications";
    }

    public String getDescription() {
        return "Infer redundant labels automatically based on user declaration";
    }

    public String getIconFileName() {
        return "/plugin/implied-labels/icons/48x48/attribute.png";
    }

    public String getUrlName() {
        return "label-implications";
    }

    @RequirePOST
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.implications(req.bindJSONToList(Implication.class, req.getSubmittedForm().get("impl")));
        rsp.sendRedirect("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implications(@Nonnull Collection<Implication> implications) throws IOException {
        List<Implication> im;
        try {
            im = Collections.unmodifiableList(Implication.sort(implications));
        }
        catch (CyclicGraphDetector.CycleDetectedException ex) {
            throw new IOException("Implication cycle detected", ex);
        }
        Object object = this.configLock;
        synchronized (object) {
            this.implications = im;
            CACHE_LOGGER.fine("Clearing cache when implications changed");
            this.cache.clear();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<Implication> implications() {
        Object object = this.configLock;
        synchronized (object) {
            return this.implications;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<LabelAtom> evaluate(@Nonnull Node node) {
        Set<LabelAtom> initial = this.initialLabels(node);
        Collection<LabelAtom> labels = null;
        Object object = this.configLock;
        synchronized (object) {
            labels = this.cache.get(initial);
        }
        if (labels == null) {
            labels = new HashSet<LabelAtom>(initial);
            for (Implication i : this.implications()) {
                labels.addAll(i.infer(labels));
            }
            object = this.configLock;
            synchronized (object) {
                CACHE_LOGGER.fine("Caching " + initial + " -> " + labels);
                this.cache.put(initial, labels);
            }
        }
        return labels;
    }

    @Nonnull
    private Set<LabelAtom> initialLabels(@Nonnull Node node) {
        HashSet<LabelAtom> result = new HashSet<LabelAtom>();
        result.addAll(Label.parse((String)node.getLabelString()));
        result.add(node.getSelfLabel());
        for (LabelFinder labeler : LabelFinder.all()) {
            if (labeler instanceof Implier) continue;
            for (Label label : labeler.findLabels(node)) {
                if (!(label instanceof LabelAtom)) continue;
                result.add((LabelAtom)label);
            }
        }
        return result;
    }

    @Nonnull
    public Collection<LabelAtom> detectRedundantLabels(@Nonnull Node node) {
        Set<LabelAtom> initial = this.initialLabels(node);
        HashSet<LabelAtom> infered = new HashSet<LabelAtom>();
        HashSet<LabelAtom> accumulated = new HashSet<LabelAtom>(initial);
        for (Implication i : this.implications()) {
            Collection<LabelAtom> ii = i.infer(accumulated);
            infered.addAll(ii);
            accumulated.addAll(ii);
        }
        infered.retainAll(initial);
        return infered;
    }

    private XmlFile getConfigFile() {
        File file = new File(Jenkins.getInstance().root, ((Object)((Object)this)).getClass().getCanonicalName() + ".xml");
        return new XmlFile(Jenkins.XSTREAM, file);
    }

    private void save() throws IOException {
        this.getConfigFile().write((Object)this);
    }

    private void load() throws IOException {
        XmlFile file = this.getConfigFile();
        if (file.exists()) {
            file.unmarshal((Object)this);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation doCheckExpression(@QueryParameter String expression) {
        if (Util.fixEmpty((String)expression) == null) {
            return FormValidation.ok();
        }
        try {
            Label.parseExpression((String)expression);
        }
        catch (ANTLRException ex) {
            return FormValidation.error((Throwable)ex, (String)Messages.AbstractProject_AssignedLabelString_InvalidBooleanExpression((Object)ex.getMessage()));
        }
        return FormValidation.ok();
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation doInferLabels(@QueryParameter String labelString) {
        if (Util.fixEmpty((String)labelString) == null) {
            return FormValidation.ok();
        }
        Set labels = Label.parse((String)labelString);
        for (Implication i : this.implications()) {
            labels.addAll(i.infer(labels));
        }
        labels.removeAll(Label.parse((String)labelString));
        if (labels.isEmpty()) {
            return FormValidation.ok((String)"No labels infered");
        }
        return FormValidation.ok((String)"Infered labels: %s", (Object[])new Object[]{Util.join((Collection)labels, (String)" ")});
    }

    @Restricted(value={NoExternalUse.class})
    public AutoCompletionCandidates doAutoCompleteLabels(@QueryParameter String value) {
        AutoCompletionCandidates candidates = new AutoCompletionCandidates();
        for (LabelAtom atom : Jenkins.getInstance().getLabelAtoms()) {
            if (!atom.getName().startsWith(value)) continue;
            candidates.add(atom.getName());
        }
        for (Implication i : this.implications()) {
            for (LabelAtom atom : i.atoms()) {
                if (!atom.getName().startsWith(value)) continue;
                candidates.add(atom.getName());
            }
        }
        return candidates;
    }
}

