/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import jenkins.plugins.http_request.HttpMode;
import jenkins.plugins.http_request.util.HttpBodyDelete;
import jenkins.plugins.http_request.util.HttpBodyGet;
import jenkins.plugins.http_request.util.HttpRequestNameValuePair;
import jenkins.plugins.http_request.util.RequestAction;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;

public class HttpClientUtil {
    public HttpRequestBase createRequestBase(RequestAction requestAction) throws IOException {
        HttpRequestBase httpRequestBase = this.doCreateRequestBase(requestAction);
        for (HttpRequestNameValuePair header : requestAction.getHeaders()) {
            httpRequestBase.addHeader(header.getName(), header.getValue());
        }
        return httpRequestBase;
    }

    private HttpRequestBase doCreateRequestBase(RequestAction requestAction) throws IOException {
        HttpEntityEnclosingRequestBase http;
        if (requestAction.getMode() == HttpMode.HEAD) {
            return new HttpHead(this.getUrlWithParams(requestAction));
        }
        if (requestAction.getMode() == HttpMode.GET && (requestAction.getRequestBody() == null || requestAction.getRequestBody().isEmpty())) {
            return new HttpGet(this.getUrlWithParams(requestAction));
        }
        String uri = requestAction.getUrl().toString();
        if (requestAction.getMode() == HttpMode.GET) {
            http = new HttpBodyGet(this.getUrlWithParams(requestAction));
        } else if (requestAction.getMode() == HttpMode.DELETE) {
            http = new HttpBodyDelete(uri);
        } else if (requestAction.getMode() == HttpMode.PUT) {
            http = new HttpPut(uri);
        } else if (requestAction.getMode() == HttpMode.PATCH) {
            http = new HttpPatch(uri);
        } else {
            if (requestAction.getMode() == HttpMode.OPTIONS) {
                return new HttpOptions(this.getUrlWithParams(requestAction));
            }
            http = new HttpPost(uri);
        }
        http.setEntity(this.makeEntity(requestAction));
        return http;
    }

    private HttpEntity makeEntity(RequestAction requestAction) throws UnsupportedEncodingException {
        if (requestAction.getRequestBody() != null && !requestAction.getRequestBody().isEmpty()) {
            ContentType contentType = null;
            for (HttpRequestNameValuePair header : requestAction.getHeaders()) {
                if (!"Content-Type".equalsIgnoreCase(header.getName())) continue;
                contentType = ContentType.parse((String)header.getValue());
                break;
            }
            return new StringEntity(requestAction.getRequestBody(), contentType);
        }
        return HttpClientUtil.toUrlEncoded(requestAction.getParams());
    }

    private String getUrlWithParams(RequestAction requestAction) throws IOException {
        String url = requestAction.getUrl().toString();
        if (!requestAction.getParams().isEmpty()) {
            url = HttpClientUtil.appendParamsToUrl(url, requestAction.getParams());
        }
        return url;
    }

    private static UrlEncodedFormEntity toUrlEncoded(List<HttpRequestNameValuePair> params) throws UnsupportedEncodingException {
        return new UrlEncodedFormEntity(params);
    }

    public static String appendParamsToUrl(String url, List<HttpRequestNameValuePair> params) throws IOException {
        url = url + (url.contains("?") ? "&" : "?");
        url = url + HttpClientUtil.paramsToString(params);
        return url;
    }

    public static String paramsToString(List<HttpRequestNameValuePair> params) throws IOException {
        try (InputStream is = HttpClientUtil.toUrlEncoded(params).getContent();){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public HttpResponse execute(HttpClient client, HttpContext context, HttpRequestBase method, PrintStream logger) throws IOException {
        logger.println("Sending request to url: " + method.getURI());
        HttpResponse httpResponse = client.execute((HttpUriRequest)method, context);
        logger.println("Response Code: " + httpResponse.getStatusLine());
        return httpResponse;
    }
}

