/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jenkins.plugins.http_request.ResponseHandle;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class ResponseContentSupplier
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = 1L;
    private final int status;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private String charset;
    private ResponseHandle responseHandle;
    private String content;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient InputStream contentStream;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient CloseableHttpClient httpclient;

    public ResponseContentSupplier(String content, int status) {
        this.content = content;
        this.status = status;
    }

    public ResponseContentSupplier(ResponseHandle responseHandle, HttpResponse response) {
        this.status = response.getStatusLine().getStatusCode();
        this.responseHandle = responseHandle;
        this.readHeaders(response);
        this.readCharset(response);
        try {
            InputStream entityContent;
            HttpEntity entity = response.getEntity();
            InputStream inputStream = entityContent = entity != null ? entity.getContent() : null;
            if (responseHandle == ResponseHandle.STRING && entityContent != null) {
                byte[] bytes = IOUtils.toByteArray((InputStream)entityContent);
                this.contentStream = new ByteArrayInputStream(bytes);
                this.content = new String(bytes, this.charset == null || this.charset.isEmpty() ? Charset.defaultCharset().name() : this.charset);
            } else {
                this.contentStream = entityContent;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Whitelisted
    public int getStatus() {
        return this.status;
    }

    @Whitelisted
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Whitelisted
    public String getCharset() {
        return this.charset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Whitelisted
    public String getContent() {
        if (this.responseHandle == ResponseHandle.STRING) {
            return this.content;
        }
        if (this.content != null) {
            return this.content;
        }
        if (this.contentStream == null) {
            return null;
        }
        try (InputStreamReader in = new InputStreamReader(this.contentStream, this.charset == null || this.charset.isEmpty() ? Charset.defaultCharset().name() : this.charset);){
            String string = this.content = IOUtils.toString((Reader)in);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading response. If you are reading the content in pipeline you should pass responseHandle: 'LEAVE_OPEN' and close the response(response.close()) after consume it.", e);
        }
    }

    @Whitelisted
    public InputStream getContentStream() {
        return this.contentStream;
    }

    private void readCharset(HttpResponse response) {
        ContentType defaultContentType;
        Charset charset = null;
        ContentType contentType = ContentType.get((HttpEntity)response.getEntity());
        if (contentType != null && (charset = contentType.getCharset()) == null && (defaultContentType = ContentType.getByMimeType((String)contentType.getMimeType())) != null) {
            charset = defaultContentType.getCharset();
        }
        if (charset != null) {
            this.charset = charset.name();
        }
    }

    private void readHeaders(HttpResponse response) {
        Header[] respHeaders;
        for (Header respHeader : respHeaders = response.getAllHeaders()) {
            List hs = this.headers.computeIfAbsent(respHeader.getName(), k -> new ArrayList());
            hs.add(respHeader.getValue());
        }
    }

    public String toString() {
        return "Status: " + this.status;
    }

    @Override
    public void close() throws IOException {
        if (this.httpclient != null) {
            this.httpclient.close();
        }
        if (this.contentStream != null) {
            this.contentStream.close();
        }
    }

    void setHttpClient(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
    }
}

