/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request;

import hudson.util.ListBoxModel;
import org.apache.http.entity.ContentType;

public enum MimeType {
    NOT_SET(null),
    TEXT_HTML(ContentType.TEXT_HTML),
    TEXT_PLAIN(ContentType.TEXT_PLAIN),
    APPLICATION_FORM(ContentType.APPLICATION_FORM_URLENCODED),
    APPLICATION_FORM_DATA(ContentType.MULTIPART_FORM_DATA),
    APPLICATION_JSON(ContentType.create((String)"application/json")),
    APPLICATION_JSON_UTF8(ContentType.APPLICATION_JSON),
    APPLICATION_TAR(ContentType.create((String)"application/x-tar")),
    APPLICATION_ZIP(ContentType.create((String)"application/zip")),
    APPLICATION_OCTETSTREAM(ContentType.APPLICATION_OCTET_STREAM);

    private final ContentType contentType;

    private MimeType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getValue() {
        return this.contentType.getMimeType();
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public static ListBoxModel getContentTypeFillItems() {
        ListBoxModel items = new ListBoxModel();
        for (MimeType mimeType : MimeType.values()) {
            items.add(mimeType.name());
        }
        return items;
    }
}

