/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.AbortException;
import hudson.CloseProofOutputStream;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.RemoteOutputStream;
import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.IntStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import jenkins.plugins.http_request.HttpMode;
import jenkins.plugins.http_request.HttpRequest;
import jenkins.plugins.http_request.HttpRequestGlobalConfig;
import jenkins.plugins.http_request.HttpRequestStep;
import jenkins.plugins.http_request.ResponseContentSupplier;
import jenkins.plugins.http_request.ResponseHandle;
import jenkins.plugins.http_request.auth.Authenticator;
import jenkins.plugins.http_request.auth.CertificateAuthentication;
import jenkins.plugins.http_request.auth.CredentialBasicAuthentication;
import jenkins.plugins.http_request.auth.CredentialNtlmAuthentication;
import jenkins.plugins.http_request.util.HttpClientUtil;
import jenkins.plugins.http_request.util.HttpRequestFormDataPart;
import jenkins.plugins.http_request.util.HttpRequestNameValuePair;
import jenkins.plugins.http_request.util.RequestAction;
import jenkins.security.MasterToSlaveCallable;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpRequestExecution
extends MasterToSlaveCallable<ResponseContentSupplier, RuntimeException> {
    private static final long serialVersionUID = -2066857816168989599L;
    private final String url;
    private final HttpMode httpMode;
    private final boolean ignoreSslErrors;
    private final HttpHost httpProxy;
    private final StandardUsernamePasswordCredentials proxyCredentials;
    private final String body;
    private final List<HttpRequestNameValuePair> headers;
    private final List<HttpRequestFormDataPart> formData;
    private final FilePath uploadFile;
    private final String multipartName;
    private final boolean wrapAsMultipart;
    private final boolean useNtlm;
    private final boolean useSystemProperties;
    private final String validResponseCodes;
    private final String validResponseContent;
    private final FilePath outputFile;
    private final int timeout;
    private final boolean consoleLogResponseBody;
    private final ResponseHandle responseHandle;
    private final Authenticator authenticator;
    private final OutputStream remoteLogger;
    private transient PrintStream localLogger;

    static HttpRequestExecution from(HttpRequest http, EnvVars envVars, AbstractBuild<?, ?> build, TaskListener taskListener) {
        try {
            String url = http.resolveUrl(envVars, build, taskListener);
            String body = http.resolveBody(envVars, build, taskListener);
            List<HttpRequestNameValuePair> headers = http.resolveHeaders(envVars);
            FilePath outputFile = http.resolveOutputFile(envVars, build);
            FilePath uploadFile = http.resolveUploadFile(envVars, build);
            AbstractProject project = build.getProject();
            List<HttpRequestFormDataPart> formData = http.resolveFormDataParts(envVars, build);
            return new HttpRequestExecution(url, http.getHttpMode(), http.getIgnoreSslErrors(), http.getHttpProxy(), http.getProxyAuthentication(), body, headers, http.getTimeout(), uploadFile, http.getMultipartName(), http.getWrapAsMultipart(), http.getAuthentication(), http.isUseNtlm(), http.getUseSystemProperties(), formData, http.getValidResponseCodes(), http.getValidResponseContent(), http.getConsoleLogResponseBody(), outputFile, ResponseHandle.NONE, (Item)project, taskListener.getLogger());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static HttpRequestExecution from(HttpRequestStep step, TaskListener taskListener, HttpRequestStep.Execution execution) throws IOException, InterruptedException {
        List<HttpRequestNameValuePair> headers = step.resolveHeaders();
        FilePath outputFile = execution.resolveOutputFile();
        FilePath uploadFile = execution.resolveUploadFile();
        List<HttpRequestFormDataPart> formData = execution.resolveFormDataParts();
        Item project = execution.getProject();
        return new HttpRequestExecution(step.getUrl(), step.getHttpMode(), step.isIgnoreSslErrors(), step.getHttpProxy(), step.getProxyAuthentication(), step.getRequestBody(), headers, step.getTimeout(), uploadFile, step.getMultipartName(), step.isWrapAsMultipart(), step.getAuthentication(), step.isUseNtlm(), step.getUseSystemProperties(), formData, step.getValidResponseCodes(), step.getValidResponseContent(), step.getConsoleLogResponseBody(), outputFile, step.getResponseHandle(), project, taskListener.getLogger());
    }

    /*
     * Enabled aggressive block sorting
     */
    private HttpRequestExecution(String url, HttpMode httpMode, boolean ignoreSslErrors, String httpProxy, String proxyAuthentication, String body, List<HttpRequestNameValuePair> headers, Integer timeout, FilePath uploadFile, String multipartName, boolean wrapAsMultipart, String authentication, boolean useNtlm, boolean useSystemProperties, List<HttpRequestFormDataPart> formData, String validResponseCodes, String validResponseContent, Boolean consoleLogResponseBody, FilePath outputFile, ResponseHandle responseHandle, Item project, PrintStream logger) {
        this.url = url;
        this.httpMode = httpMode;
        this.ignoreSslErrors = ignoreSslErrors;
        if (StringUtils.isNotBlank((String)httpProxy)) {
            this.httpProxy = HttpHost.create((String)httpProxy);
            if (StringUtils.isNotBlank((String)proxyAuthentication)) {
                StandardCredentials credential = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)proxyAuthentication));
                if (!(credential instanceof StandardUsernamePasswordCredentials)) {
                    this.proxyCredentials = null;
                    throw new IllegalStateException("Proxy authentication '" + proxyAuthentication + "' doesn't exist anymore or is not a username/password credential type");
                }
                this.proxyCredentials = (StandardUsernamePasswordCredentials)credential;
            } else {
                this.proxyCredentials = null;
            }
        } else {
            this.httpProxy = null;
            this.proxyCredentials = null;
        }
        this.body = body;
        this.headers = headers;
        this.formData = formData;
        this.timeout = timeout != null ? timeout : -1;
        this.useNtlm = useNtlm;
        if (authentication != null && !authentication.isEmpty()) {
            StandardCredentials credential;
            Authenticator auth = HttpRequestGlobalConfig.get().getAuthentication(authentication);
            if (auth == null && (credential = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)authentication))) != null) {
                if (credential instanceof StandardUsernamePasswordCredentials) {
                    auth = this.useNtlm ? new CredentialNtlmAuthentication((StandardUsernamePasswordCredentials)credential) : new CredentialBasicAuthentication((StandardUsernamePasswordCredentials)credential);
                }
                if (credential instanceof StandardCertificateCredentials) {
                    auth = new CertificateAuthentication((StandardCertificateCredentials)credential);
                }
            }
            if (auth == null) {
                throw new IllegalStateException("Authentication '" + authentication + "' doesn't exist anymore");
            }
            this.authenticator = auth;
        } else {
            this.authenticator = null;
        }
        this.uploadFile = uploadFile;
        this.multipartName = multipartName;
        this.wrapAsMultipart = wrapAsMultipart;
        this.useSystemProperties = useSystemProperties;
        this.validResponseCodes = validResponseCodes;
        this.validResponseContent = validResponseContent != null ? validResponseContent : "";
        this.consoleLogResponseBody = Boolean.TRUE.equals(consoleLogResponseBody);
        this.responseHandle = this.consoleLogResponseBody || !this.validResponseContent.isEmpty() ? ResponseHandle.STRING : responseHandle;
        this.outputFile = outputFile;
        this.localLogger = logger;
        this.remoteLogger = new RemoteOutputStream((OutputStream)new CloseProofOutputStream((OutputStream)logger));
    }

    public ResponseContentSupplier call() throws RuntimeException {
        this.logger().println("HttpMethod: " + (Object)((Object)this.httpMode));
        this.logger().println("URL: " + this.url);
        for (HttpRequestNameValuePair header : this.headers) {
            this.logger().print(header.getName() + ": ");
            this.logger().println(header.getMaskValue() ? "*****" : header.getValue());
        }
        try {
            return this.authAndRequest();
        }
        catch (IOException | InterruptedException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private PrintStream logger() {
        if (this.localLogger == null) {
            try {
                this.localLogger = new PrintStream(this.remoteLogger, true, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.localLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseContentSupplier authAndRequest() throws IOException, InterruptedException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        ResponseHandle responseHandle = ResponseHandle.NONE;
        CloseableHttpClient httpclient = null;
        try {
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            if (this.useSystemProperties) {
                clientBuilder.useSystemProperties();
            }
            this.configureTimeoutAndSsl(clientBuilder);
            if (this.httpProxy != null) {
                clientBuilder.setProxy(this.httpProxy);
            }
            HttpClientUtil clientUtil = new HttpClientUtil();
            HttpRequestBase httpRequestBase = clientUtil.createRequestBase(new RequestAction(new URL(this.url), this.httpMode, this.body, null, this.headers));
            if (this.formData != null && !this.formData.isEmpty() && this.httpMode == HttpMode.POST) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                for (HttpRequestFormDataPart part : this.formData) {
                    if (part.getFileName() == null || part.getFileName().isEmpty()) {
                        ContentType textContentType = part.getContentType() == null || part.getContentType().isEmpty() ? ContentType.TEXT_PLAIN : ContentType.create((String)part.getContentType());
                        builder.addTextBody(part.getName(), part.getBody(), textContentType);
                        continue;
                    }
                    ContentType fileContentType = part.getContentType() == null || part.getContentType().isEmpty() ? ContentType.APPLICATION_OCTET_STREAM : ContentType.create((String)part.getContentType());
                    builder.addBinaryBody(part.getName(), new File(part.getResolvedUploadFile().getRemote()), fileContentType, part.getFileName());
                }
                HttpEntity mimeBody = builder.build();
                ((HttpEntityEnclosingRequestBase)httpRequestBase).setEntity(mimeBody);
            } else if (this.uploadFile != null && (this.httpMode == HttpMode.POST || this.httpMode == HttpMode.PUT)) {
                FileEntity entity;
                ContentType contentType = ContentType.APPLICATION_OCTET_STREAM;
                for (HttpRequestNameValuePair header : this.headers) {
                    if (!"Content-Type".equalsIgnoreCase(header.getName())) continue;
                    contentType = ContentType.parse((String)header.getValue());
                    break;
                }
                if (this.wrapAsMultipart) {
                    MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                    builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                    FileBody fileBody = new FileBody(new File(this.uploadFile.getRemote()), contentType);
                    entity = builder.addPart(this.multipartName, (ContentBody)fileBody).build();
                } else {
                    entity = new FileEntity(new File(this.uploadFile.getRemote()), contentType);
                }
                ((HttpEntityEnclosingRequestBase)httpRequestBase).setEntity((HttpEntity)entity);
                httpRequestBase.setHeader(entity.getContentType());
                httpRequestBase.setHeader(entity.getContentEncoding());
            }
            BasicHttpContext context = new BasicHttpContext();
            httpclient = this.auth(clientBuilder, httpRequestBase, (HttpContext)context);
            ResponseContentSupplier response = this.executeRequest(httpclient, clientUtil, httpRequestBase, (HttpContext)context);
            this.processResponse(response);
            responseHandle = this.responseHandle;
            if (responseHandle == ResponseHandle.LEAVE_OPEN) {
                response.setHttpClient(httpclient);
            }
            ResponseContentSupplier responseContentSupplier = response;
            return responseContentSupplier;
        }
        finally {
            if (responseHandle != ResponseHandle.LEAVE_OPEN && httpclient != null) {
                httpclient.close();
            }
        }
    }

    private void configureTimeoutAndSsl(HttpClientBuilder clientBuilder) throws NoSuchAlgorithmException, KeyManagementException {
        if (this.timeout > 0) {
            int t = this.timeout * 1000;
            RequestConfig config = RequestConfig.custom().setSocketTimeout(t).setConnectTimeout(t).setConnectionRequestTimeout(t).build();
            clientBuilder.setDefaultRequestConfig(config);
        }
        if (this.ignoreSslErrors) {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new NoopTrustManager()}, new SecureRandom());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sc, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
    }

    private CloseableHttpClient auth(HttpClientBuilder clientBuilder, HttpRequestBase httpRequestBase, HttpContext context) throws IOException, InterruptedException {
        if (this.proxyCredentials != null) {
            this.logger().println("Using proxy authentication: " + this.proxyCredentials.getId());
            if (this.authenticator instanceof CredentialBasicAuthentication) {
                ((CredentialBasicAuthentication)this.authenticator).addCredentials(this.httpProxy, this.proxyCredentials);
            } else {
                new CredentialBasicAuthentication(this.proxyCredentials).prepare(clientBuilder, context, this.httpProxy);
            }
        }
        if (this.authenticator == null) {
            return clientBuilder.build();
        }
        this.logger().println("Using authentication: " + this.authenticator.getKeyName());
        return this.authenticator.authenticate(clientBuilder, context, httpRequestBase, this.logger());
    }

    private ResponseContentSupplier executeRequest(CloseableHttpClient httpclient, HttpClientUtil clientUtil, HttpRequestBase httpRequestBase, HttpContext context) throws IOException {
        ResponseContentSupplier responseContentSupplier;
        try {
            HttpResponse response = clientUtil.execute((HttpClient)httpclient, context, httpRequestBase, this.logger());
            responseContentSupplier = new ResponseContentSupplier(this.responseHandle, response);
        }
        catch (UnknownHostException uhe) {
            this.logger().println("Treating UnknownHostException(" + uhe.getMessage() + ") as 404 Not Found");
            responseContentSupplier = new ResponseContentSupplier("UnknownHostException as 404 Not Found", 404);
        }
        catch (ConnectException | SocketTimeoutException ce) {
            this.logger().println("Treating " + ce.getClass() + "(" + ce.getMessage() + ") as 408 Request Timeout");
            responseContentSupplier = new ResponseContentSupplier(ce.getClass() + "(" + ce.getMessage() + ") as 408 Request Timeout", 408);
        }
        return responseContentSupplier;
    }

    private void responseCodeIsValid(ResponseContentSupplier response) throws AbortException {
        List<IntStream> ranges = HttpRequest.DescriptorImpl.parseToRange(this.validResponseCodes);
        for (IntStream range : ranges) {
            if (!range.anyMatch(status -> status == response.getStatus())) continue;
            this.logger().println("Success: Status code " + response.getStatus() + " is in the accepted range: " + this.validResponseCodes);
            return;
        }
        throw new AbortException("Fail: Status code " + response.getStatus() + " is not in the accepted range: " + this.validResponseCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(ResponseContentSupplier response) throws IOException, InterruptedException {
        if (this.consoleLogResponseBody) {
            this.logger().println("Response: \n" + response.getContent());
        }
        this.responseCodeIsValid(response);
        if (!this.validResponseContent.isEmpty() && !response.getContent().contains(this.validResponseContent)) {
            throw new AbortException("Fail: Response doesn't contain expected content '" + this.validResponseContent + "'");
        }
        if (this.outputFile == null) {
            return;
        }
        this.logger().println("Saving response body to " + this.outputFile);
        InputStream in = response.getContentStream();
        if (in == null) {
            return;
        }
        OutputStream out = null;
        try {
            out = this.outputFile.write();
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            in.close();
        }
    }

    private static class NoopTrustManager
    extends X509ExtendedTrustManager {
        private NoopTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        }
    }
}

