/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request;

import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import jenkins.plugins.http_request.HttpMode;
import jenkins.plugins.http_request.HttpRequestExecution;
import jenkins.plugins.http_request.HttpRequestGlobalConfig;
import jenkins.plugins.http_request.MimeType;
import jenkins.plugins.http_request.auth.BasicDigestAuthentication;
import jenkins.plugins.http_request.auth.FormAuthentication;
import jenkins.plugins.http_request.util.HttpClientUtil;
import jenkins.plugins.http_request.util.HttpRequestFormDataPart;
import jenkins.plugins.http_request.util.HttpRequestNameValuePair;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class HttpRequest
extends Builder {
    @NonNull
    private final String url;
    private Boolean ignoreSslErrors = false;
    private HttpMode httpMode = DescriptorImpl.httpMode;
    private String httpProxy = "";
    private String proxyAuthentication = "";
    private Boolean passBuildParameters = DescriptorImpl.passBuildParameters;
    private String validResponseCodes = "100:399";
    private String validResponseContent = "";
    private MimeType acceptType = DescriptorImpl.acceptType;
    private MimeType contentType = DescriptorImpl.contentType;
    private String outputFile = "";
    private Integer timeout = 0;
    private Boolean consoleLogResponseBody = DescriptorImpl.consoleLogResponseBody;
    private Boolean quiet = DescriptorImpl.quiet;
    private String authentication = "";
    private String requestBody = "";
    private String uploadFile = "";
    private String multipartName = "";
    private Boolean wrapAsMultipart = true;
    private Boolean useSystemProperties = DescriptorImpl.useSystemProperties;
    private boolean useNtlm = false;
    private List<HttpRequestNameValuePair> customHeaders = DescriptorImpl.customHeaders;
    private List<HttpRequestFormDataPart> formData = DescriptorImpl.formData;

    @DataBoundConstructor
    public HttpRequest(@NonNull String url) {
        this.url = url;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public Boolean getIgnoreSslErrors() {
        return this.ignoreSslErrors;
    }

    @DataBoundSetter
    public void setIgnoreSslErrors(Boolean ignoreSslErrors) {
        this.ignoreSslErrors = ignoreSslErrors;
    }

    public HttpMode getHttpMode() {
        return this.httpMode;
    }

    @DataBoundSetter
    public void setHttpMode(HttpMode httpMode) {
        this.httpMode = httpMode;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    @DataBoundSetter
    public void setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
    }

    public Boolean getPassBuildParameters() {
        return this.passBuildParameters;
    }

    @DataBoundSetter
    public void setPassBuildParameters(Boolean passBuildParameters) {
        this.passBuildParameters = passBuildParameters;
    }

    @NonNull
    public String getValidResponseCodes() {
        return this.validResponseCodes;
    }

    @DataBoundSetter
    public void setValidResponseCodes(String validResponseCodes) {
        this.validResponseCodes = validResponseCodes;
    }

    public String getValidResponseContent() {
        return this.validResponseContent;
    }

    @DataBoundSetter
    public void setValidResponseContent(String validResponseContent) {
        this.validResponseContent = validResponseContent;
    }

    public MimeType getAcceptType() {
        return this.acceptType;
    }

    @DataBoundSetter
    public void setAcceptType(MimeType acceptType) {
        this.acceptType = acceptType;
    }

    public MimeType getContentType() {
        return this.contentType;
    }

    @DataBoundSetter
    public void setContentType(MimeType contentType) {
        this.contentType = contentType;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    @DataBoundSetter
    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Boolean getConsoleLogResponseBody() {
        return this.consoleLogResponseBody;
    }

    @DataBoundSetter
    public void setConsoleLogResponseBody(Boolean consoleLogResponseBody) {
        this.consoleLogResponseBody = consoleLogResponseBody;
    }

    public Boolean getQuiet() {
        return this.quiet;
    }

    @DataBoundSetter
    public void setQuiet(Boolean quiet) {
        this.quiet = quiet;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    @DataBoundSetter
    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getProxyAuthentication() {
        return this.proxyAuthentication;
    }

    @DataBoundSetter
    public void setProxyAuthentication(String proxyAuthentication) {
        this.proxyAuthentication = proxyAuthentication;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    @DataBoundSetter
    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public Boolean getUseSystemProperties() {
        return this.useSystemProperties;
    }

    @DataBoundSetter
    public void setUseSystemProperties(Boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    public List<HttpRequestNameValuePair> getCustomHeaders() {
        return this.customHeaders;
    }

    @DataBoundSetter
    public void setCustomHeaders(List<HttpRequestNameValuePair> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public List<HttpRequestFormDataPart> getFormData() {
        return this.formData;
    }

    @DataBoundSetter
    public void setFormData(List<HttpRequestFormDataPart> formData) {
        this.formData = Collections.unmodifiableList(formData);
    }

    public String getUploadFile() {
        return this.uploadFile;
    }

    @DataBoundSetter
    public void setUploadFile(String uploadFile) {
        this.uploadFile = uploadFile;
    }

    public String getMultipartName() {
        return this.multipartName;
    }

    @DataBoundSetter
    public void setMultipartName(String multipartName) {
        this.multipartName = multipartName;
    }

    public Boolean getWrapAsMultipart() {
        return this.wrapAsMultipart;
    }

    @DataBoundSetter
    public void setWrapAsMultipart(Boolean wrapAsMultipart) {
        this.wrapAsMultipart = wrapAsMultipart;
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void xStreamCompatibility() {
        Items.XSTREAM2.aliasField("logResponseBody", HttpRequest.class, "consoleLogResponseBody");
        Items.XSTREAM2.aliasField("consoleLogResponseBody", HttpRequest.class, "consoleLogResponseBody");
        Items.XSTREAM2.alias("pair", HttpRequestNameValuePair.class);
    }

    protected Object readResolve() {
        if (this.customHeaders == null) {
            this.customHeaders = DescriptorImpl.customHeaders;
        }
        if (this.formData == null) {
            this.formData = DescriptorImpl.formData;
        }
        if (this.validResponseCodes == null || this.validResponseCodes.trim().isEmpty()) {
            this.validResponseCodes = "100:399";
        }
        if (this.ignoreSslErrors == null) {
            this.ignoreSslErrors = true;
        }
        if (this.quiet == null) {
            this.quiet = DescriptorImpl.quiet;
        }
        if (this.useSystemProperties == null) {
            this.useSystemProperties = DescriptorImpl.useSystemProperties == false;
        }
        if (this.wrapAsMultipart == null) {
            this.wrapAsMultipart = true;
        }
        return this;
    }

    private List<HttpRequestNameValuePair> createParams(EnvVars envVars, AbstractBuild<?, ?> build, TaskListener listener) {
        Map buildVariables = build.getBuildVariables();
        if (buildVariables.isEmpty()) {
            return Collections.emptyList();
        }
        PrintStream logger = listener.getLogger();
        logger.println("Parameters: ");
        ArrayList<HttpRequestNameValuePair> l = new ArrayList<HttpRequestNameValuePair>();
        for (Map.Entry entry : buildVariables.entrySet()) {
            String value = envVars.expand((String)entry.getValue());
            logger.println("  " + (String)entry.getKey() + " = " + value);
            l.add(new HttpRequestNameValuePair((String)entry.getKey(), value));
        }
        return l;
    }

    String resolveUrl(EnvVars envVars, AbstractBuild<?, ?> build, TaskListener listener) throws IOException {
        List<HttpRequestNameValuePair> params;
        String url = envVars.expand(this.getUrl());
        if (Boolean.TRUE.equals(this.getPassBuildParameters()) && this.getHttpMode() == HttpMode.GET && !(params = this.createParams(envVars, build, listener)).isEmpty()) {
            url = HttpClientUtil.appendParamsToUrl(url, params);
        }
        return url;
    }

    List<HttpRequestNameValuePair> resolveHeaders(EnvVars envVars) {
        ArrayList<HttpRequestNameValuePair> headers = new ArrayList<HttpRequestNameValuePair>();
        if (this.contentType != null && this.contentType != MimeType.NOT_SET) {
            headers.add(new HttpRequestNameValuePair("Content-Type", this.contentType.getContentType().toString()));
        }
        if (this.acceptType != null && this.acceptType != MimeType.NOT_SET) {
            headers.add(new HttpRequestNameValuePair("Accept", this.acceptType.getValue()));
        }
        for (HttpRequestNameValuePair header : this.customHeaders) {
            String headerName = envVars.expand(header.getName());
            String headerValue = envVars.expand(header.getValue());
            boolean maskValue = headerName.equalsIgnoreCase("Authorization") || header.getMaskValue();
            headers.add(new HttpRequestNameValuePair(headerName, headerValue, maskValue));
        }
        return headers;
    }

    String resolveBody(EnvVars envVars, AbstractBuild<?, ?> build, TaskListener listener) throws IOException {
        List<HttpRequestNameValuePair> params;
        String body = envVars.expand(this.getRequestBody());
        if ((body == null || body.isEmpty()) && Boolean.TRUE.equals(this.getPassBuildParameters()) && !(params = this.createParams(envVars, build, listener)).isEmpty()) {
            body = HttpClientUtil.paramsToString(params);
        }
        return body;
    }

    FilePath resolveOutputFile(EnvVars envVars, AbstractBuild<?, ?> build) {
        if (this.outputFile == null || this.outputFile.trim().isEmpty()) {
            return null;
        }
        String filePath = envVars.expand(this.outputFile);
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IllegalStateException("Could not find workspace to save file outputFile: " + this.outputFile);
        }
        return workspace.child(filePath);
    }

    FilePath resolveUploadFile(EnvVars envVars, AbstractBuild<?, ?> build) {
        return HttpRequest.resolveUploadFileInternal(this.uploadFile, envVars, build);
    }

    private static FilePath resolveUploadFileInternal(String path, EnvVars envVars, AbstractBuild<?, ?> build) {
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        String filePath = envVars.expand(path);
        try {
            FilePath workspace = build.getWorkspace();
            if (workspace == null) {
                throw new IllegalStateException("Could not find workspace to check existence of upload file: " + path + ". You should use it inside a 'node' block");
            }
            FilePath uploadFilePath = workspace.child(filePath);
            if (!uploadFilePath.exists()) {
                throw new IllegalStateException("Could not find upload file: " + path);
            }
            return uploadFilePath;
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    List<HttpRequestFormDataPart> resolveFormDataParts(EnvVars envVars, AbstractBuild<?, ?> build) {
        if (this.formData == null || this.formData.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HttpRequestFormDataPart> resolved = new ArrayList<HttpRequestFormDataPart>(this.formData.size());
        for (HttpRequestFormDataPart part : this.formData) {
            String name = envVars.expand(part.getName());
            String fileName = envVars.expand(part.getFileName());
            FilePath resolvedUploadFile = HttpRequest.resolveUploadFileInternal(part.getUploadFile(), envVars, build);
            String body = envVars.expand(part.getBody());
            HttpRequestFormDataPart newPart = new HttpRequestFormDataPart(part.getUploadFile(), name, fileName, part.getContentType(), body);
            newPart.setResolvedUploadFile(resolvedUploadFile);
            resolved.add(newPart);
        }
        return resolved;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        envVars.putAll(build.getBuildVariables());
        HttpRequestExecution exec = HttpRequestExecution.from(this, envVars, build, (TaskListener)(this.getQuiet() != false ? TaskListener.NULL : listener));
        VirtualChannel channel = launcher.getChannel();
        if (channel == null) {
            throw new IllegalStateException("Launcher doesn't support remoting but it is required");
        }
        channel.call((Callable)exec);
        return true;
    }

    public boolean isUseNtlm() {
        return this.useNtlm;
    }

    public void setUseNtlm(boolean useNtlm) {
        this.useNtlm = useNtlm;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final boolean ignoreSslErrors = false;
        public static final HttpMode httpMode = HttpMode.GET;
        public static final String httpProxy = "";
        public static final String proxyAuthentication = "";
        public static final Boolean passBuildParameters = false;
        public static final String validResponseCodes = "100:399";
        public static final String validResponseContent = "";
        public static final MimeType acceptType = MimeType.NOT_SET;
        public static final MimeType contentType = MimeType.NOT_SET;
        public static final String outputFile = "";
        public static final int timeout = 0;
        public static final Boolean consoleLogResponseBody = false;
        public static final Boolean quiet = false;
        public static final String authentication = "";
        public static final String requestBody = "";
        public static final String uploadFile = "";
        public static final String multipartName = "";
        public static final boolean wrapAsMultipart = true;
        public static final Boolean useSystemProperties = false;
        public static final boolean useNtlm = false;
        public static final List<HttpRequestNameValuePair> customHeaders = Collections.emptyList();
        public static final List<HttpRequestFormDataPart> formData = Collections.emptyList();

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "HTTP Request";
        }

        public ListBoxModel doFillHttpModeItems() {
            return HttpMode.getFillItems();
        }

        public ListBoxModel doFillAcceptTypeItems() {
            return MimeType.getContentTypeFillItems();
        }

        public ListBoxModel doFillContentTypeItems() {
            return MimeType.getContentTypeFillItems();
        }

        public ListBoxModel doFillAuthenticationItems(@AncestorInPath Item project, @QueryParameter String url) {
            return DescriptorImpl.fillAuthenticationItems(project, url);
        }

        public ListBoxModel doFillProxyAuthenticationItems(@AncestorInPath Item project, @QueryParameter String url) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, project, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)url).build());
        }

        public static ListBoxModel fillAuthenticationItems(Item project, String url) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel();
            }
            ArrayList<ListBoxModel.Option> options = new ArrayList<ListBoxModel.Option>();
            for (BasicDigestAuthentication basic : HttpRequestGlobalConfig.get().getBasicDigestAuthentications()) {
                options.add(new ListBoxModel.Option("(deprecated - use Jenkins Credentials) " + basic.getKeyName(), basic.getKeyName()));
            }
            for (FormAuthentication formAuthentication : HttpRequestGlobalConfig.get().getFormAuthentications()) {
                options.add(new ListBoxModel.Option(formAuthentication.getKeyName()));
            }
            AbstractIdCredentialsListBoxModel items = new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, project, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)url).build());
            items.addMissing(options);
            return items;
        }

        public static List<IntStream> parseToRange(String value) {
            String[] codes;
            ArrayList<IntStream> validRanges = new ArrayList<IntStream>();
            if (value == null || value.isEmpty()) {
                value = validResponseCodes;
            }
            for (String code : codes = value.split(",")) {
                int from;
                String[] fromTo = code.trim().split(":");
                if (fromTo.length > 2) {
                    throw new IllegalArgumentException(String.format("Code %s should be an interval from:to or a single value", code));
                }
                try {
                    from = Integer.parseInt(fromTo[0]);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid number " + fromTo[0]);
                }
                int to = from;
                if (fromTo.length != 1) {
                    try {
                        to = Integer.parseInt(fromTo[1]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Invalid number " + fromTo[1]);
                    }
                }
                if (from > to) {
                    throw new IllegalArgumentException(String.format("Interval %s should be FROM less than TO", code));
                }
                validRanges.add(IntStream.rangeClosed(from, to));
            }
            return validRanges;
        }

        public FormValidation doCheckValidResponseCodes(@QueryParameter String value) {
            return DescriptorImpl.checkValidResponseCodes(value);
        }

        public static FormValidation checkValidResponseCodes(String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                DescriptorImpl.parseToRange(value);
            }
            catch (IllegalArgumentException iae) {
                return FormValidation.error((String)("Response codes expected is wrong. " + iae.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

