/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.jenkinsci.plugins.htmlresource;

import com.cwctravel.jenkinsci.plugins.htmlresource.HTMLResourceManagement;
import com.cwctravel.jenkinsci.plugins.htmlresource.HTMLResourceUtil;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResource;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResourceConfiguration;
import hudson.Plugin;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.Logger;

public class HTMLResourcePluginImpl
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(HTMLResourcePluginImpl.class.getName());

    public void start() throws Exception {
        super.start();
        this.synchronizeConfig();
    }

    private void synchronizeConfig() throws IOException {
        LOGGER.info("initialize htmlresource");
        File htmlResourceHomeDirectory = HTMLResourceManagement.getHTMLResourceHomeDirectory();
        if (!htmlResourceHomeDirectory.exists() && !htmlResourceHomeDirectory.mkdirs()) {
            throw new IOException("Could not mkdir " + htmlResourceHomeDirectory.getAbsolutePath());
        }
        File webjarDirectory = HTMLResourceManagement.getWebJARDirectory();
        if (!webjarDirectory.exists() && !webjarDirectory.mkdirs()) {
            throw new IOException("Could not mkdir " + webjarDirectory.getAbsolutePath());
        }
        HTMLResourceConfiguration cfg = HTMLResourceConfiguration.load();
        if (cfg == null) {
            cfg = new HTMLResourceConfiguration(new TreeSet<HTMLResource>());
        }
        HTMLResourceUtil.syncDirWithCfg(webjarDirectory, cfg);
        cfg.save();
    }
}

