/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import hudson.util.HttpResponses;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.RunAction2;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class HtmlPublisherTarget
extends AbstractDescribableImpl<HtmlPublisherTarget> {
    private final String reportName;
    private final String reportDir;
    private final String reportFiles;
    private final boolean alwaysLinkToLastBuild;
    private String reportTitles;
    private final boolean keepAll;
    private final boolean allowMissing;
    @Deprecated
    private transient String wrapperName;
    private static final String WRAPPER_NAME = "htmlpublisher-wrapper.html";
    public static final String INCLUDE_ALL_PATTERN = "**/*";
    private String includes;

    @Deprecated
    public HtmlPublisherTarget(String reportName, String reportDir, String reportFiles, boolean keepAll, boolean allowMissing) {
        this(reportName, reportDir, reportFiles, "", keepAll, false, allowMissing);
    }

    public String getReportTitles() {
        return this.reportTitles;
    }

    @DataBoundConstructor
    public HtmlPublisherTarget(String reportName, String reportDir, String reportFiles, String reportTitles, boolean keepAll, boolean alwaysLinkToLastBuild, boolean allowMissing) {
        this.reportName = StringUtils.trim((String)reportName);
        this.reportDir = StringUtils.trim((String)reportDir);
        this.reportFiles = StringUtils.trim((String)reportFiles);
        this.reportTitles = StringUtils.trim((String)reportTitles);
        this.keepAll = keepAll;
        this.alwaysLinkToLastBuild = alwaysLinkToLastBuild;
        this.allowMissing = allowMissing;
    }

    public HtmlPublisherTarget(String reportName, String reportDir, String reportFiles, boolean keepAll, boolean alwaysLinkToLastBuild, boolean allowMissing) {
        this(reportName, reportDir, reportFiles, null, keepAll, alwaysLinkToLastBuild, allowMissing);
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public String getReportFiles() {
        return this.reportFiles;
    }

    public boolean getAlwaysLinkToLastBuild() {
        return this.alwaysLinkToLastBuild;
    }

    public boolean getKeepAll() {
        return this.keepAll;
    }

    public boolean getAllowMissing() {
        return this.allowMissing;
    }

    public String getSanitizedName() {
        String safeName = this.reportName;
        safeName = safeName.replace(" ", "_");
        return safeName;
    }

    public String getWrapperName() {
        return WRAPPER_NAME;
    }

    public FilePath getArchiveTarget(Run build) {
        return new FilePath(this.keepAll ? this.getBuildArchiveDir(build) : this.getProjectArchiveDir((AbstractItem)build.getParent()));
    }

    private File getProjectArchiveDir(AbstractItem project) {
        return new File(new File(project.getRootDir(), "htmlreports"), this.getSanitizedName());
    }

    private File getBuildArchiveDir(Run run) {
        return new File(new File(run.getRootDir(), "htmlreports"), this.getSanitizedName());
    }

    @Deprecated
    public void handleAction(Run<?, ?> build) {
        this.handleAction(build, null);
    }

    void handleAction(Run<?, ?> build, String checksum) {
        if (this.keepAll) {
            HTMLBuildAction a = new HTMLBuildAction(build, this);
            a.setWrapperChecksum(checksum);
            build.addAction((Action)a);
        } else {
            build.addAction((Action)new HTMLPublishedForProjectMarkerAction(build, this));
        }
    }

    public Action getProjectAction(AbstractItem item) {
        return new HTMLAction(item, this);
    }

    public String getIncludes() {
        if (Util.fixEmpty((String)this.includes) == null) {
            return INCLUDE_ALL_PATTERN;
        }
        return this.includes;
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.includes = includes;
    }

    protected Object readResolve() {
        if (this.includes == null) {
            this.includes = INCLUDE_ALL_PATTERN;
        }
        return this;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.reportName != null ? this.reportName.hashCode() : 0);
        hash = 97 * hash + (this.reportDir != null ? this.reportDir.hashCode() : 0);
        hash = 97 * hash + (this.reportFiles != null ? this.reportFiles.hashCode() : 0);
        hash = 97 * hash + (this.alwaysLinkToLastBuild ? 1 : 0);
        hash = 97 * hash + (this.keepAll ? 1 : 0);
        hash = 97 * hash + (this.allowMissing ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HtmlPublisherTarget other = (HtmlPublisherTarget)((Object)obj);
        if (this.reportName == null ? other.reportName != null : !this.reportName.equals(other.reportName)) {
            return false;
        }
        if (this.reportDir == null ? other.reportDir != null : !this.reportDir.equals(other.reportDir)) {
            return false;
        }
        if (this.reportFiles == null ? other.reportFiles != null : !this.reportFiles.equals(other.reportFiles)) {
            return false;
        }
        if (this.alwaysLinkToLastBuild != other.alwaysLinkToLastBuild) {
            return false;
        }
        if (this.keepAll != other.keepAll) {
            return false;
        }
        return this.allowMissing == other.allowMissing;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<HtmlPublisherTarget> {
        public String getDisplayName() {
            return "";
        }
    }

    public class HTMLBuildAction
    extends BaseHTMLAction
    implements RunAction2 {
        private transient Run<?, ?> build;
        private String wrapperChecksum;

        public HTMLBuildAction(Run<?, ?> build, HtmlPublisherTarget actualHtmlPublisherTarget) {
            super(actualHtmlPublisherTarget);
            this.build = build;
        }

        @WithBridgeMethods(value={AbstractBuild.class}, castRequired=true)
        public final Run<?, ?> getOwner() {
            return this.build;
        }

        @Override
        protected String getTitle() {
            return this.build.getDisplayName() + " html3";
        }

        @Override
        protected File dir() {
            return HtmlPublisherTarget.this.getBuildArchiveDir(this.build);
        }

        @Nonnull
        public HtmlPublisherTarget getHTMLTarget() {
            return HtmlPublisherTarget.this;
        }

        public void onAttached(Run<?, ?> r) {
            this.build = r;
            this.project = r.getParent();
        }

        public void onLoad(Run<?, ?> r) {
            this.build = r;
            this.project = r.getParent();
        }

        public String getWrapperChecksum() {
            return this.wrapperChecksum;
        }

        private void setWrapperChecksum(String wrapperChecksum) {
            this.wrapperChecksum = wrapperChecksum;
        }
    }

    public static class HTMLPublishedForProjectMarkerAction
    extends InvisibleAction
    implements RunAction2 {
        private transient Run<?, ?> build;
        private final HtmlPublisherTarget actualHtmlPublisherTarget;

        public HTMLPublishedForProjectMarkerAction(Run<?, ?> build, HtmlPublisherTarget actualHtmlPublisherTarget) {
            this.actualHtmlPublisherTarget = actualHtmlPublisherTarget;
            this.build = build;
        }

        @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuildOwner")
        public final Run<?, ?> getOwner() {
            return this.build;
        }

        @Deprecated
        private final Object getAbstractBuildOwner(Run build, Class targetClass) {
            return build instanceof AbstractBuild ? (AbstractBuild)build : null;
        }

        public void onAttached(Run<?, ?> r) {
            this.build = r;
        }

        public void onLoad(Run<?, ?> r) {
            this.build = r;
        }

        public HtmlPublisherTarget getHTMLTarget() {
            return this.actualHtmlPublisherTarget;
        }
    }

    public class HTMLAction
    extends BaseHTMLAction
    implements ProminentProjectAction {
        private transient HTMLBuildAction actualBuildAction;

        public HTMLAction(AbstractItem project, HtmlPublisherTarget actualHtmlPublisherTarget) {
            super(actualHtmlPublisherTarget);
            this.project = project;
        }

        @Override
        protected File dir() {
            File javadocDir;
            Job job;
            Run run;
            if (this.project instanceof Job && (run = this.getArchiveBuild(job = (Job)this.project)) != null && (javadocDir = HtmlPublisherTarget.this.getBuildArchiveDir(run)).exists()) {
                for (HTMLBuildAction a : run.getActions(HTMLBuildAction.class)) {
                    if (!a.getHTMLTarget().getReportName().equals(this.getHTMLTarget().getReportName())) continue;
                    this.actualBuildAction = a;
                }
                return javadocDir;
            }
            return HtmlPublisherTarget.this.getProjectArchiveDir(this.project);
        }

        private Run getArchiveBuild(@Nonnull Job job) {
            if (this.shouldLinkToLastBuild()) {
                return job.getLastBuild();
            }
            return job.getLastSuccessfulBuild();
        }

        @Override
        protected String getTitle() {
            return this.project.getDisplayName() + " html2";
        }

        @Nonnull
        public HtmlPublisherTarget getHTMLTarget() {
            return HtmlPublisherTarget.this;
        }

        @Restricted(value={NoExternalUse.class})
        public HTMLBuildAction getActualBuildAction() {
            return this.actualBuildAction;
        }
    }

    protected abstract class BaseHTMLAction
    implements Action {
        private HtmlPublisherTarget actualHtmlPublisherTarget;
        protected transient AbstractItem project;

        public BaseHTMLAction(HtmlPublisherTarget actualHtmlPublisherTarget) {
            this.actualHtmlPublisherTarget = actualHtmlPublisherTarget;
        }

        public String getUrlName() {
            return this.actualHtmlPublisherTarget.getSanitizedName();
        }

        public String getDisplayName() {
            String action = this.actualHtmlPublisherTarget.reportName;
            return this.dir().exists() ? action : null;
        }

        public String getIconFileName() {
            return this.dir().exists() ? "graph.gif" : null;
        }

        public boolean shouldLinkToLastBuild() {
            return this.actualHtmlPublisherTarget.getAlwaysLinkToLastBuild();
        }

        public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, new FilePath(this.dir()), this.getTitle(), "graph.gif", false);
            if (req.getRestOfPath().equals("")) {
                throw HttpResponses.forwardToView((Object)this, (String)"index.jelly");
            }
            dbs.generateResponse(req, rsp, (Object)this);
        }

        protected abstract String getTitle();

        protected abstract File dir();
    }
}

