/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.plugin.results;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.nvemulation.model.NvProfileDTO;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvTestSuiteResult;

public class NvJUnitResult
implements Serializable {
    private static final long serialVersionUID = 74133989369447160L;
    private ArrayList<NvProfileDTO> profiles = new ArrayList();
    private Map<String, NvTestSuiteResult> results = new HashMap<String, NvTestSuiteResult>();

    public ArrayList<NvProfileDTO> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(ArrayList<NvProfileDTO> profiles) {
        this.profiles = profiles;
    }

    @JsonGetter(value="suites")
    public List<NvTestSuiteResult> getResults() {
        Collection<NvTestSuiteResult> values = this.results.values();
        if (values instanceof List) {
            return (List)values;
        }
        return new ArrayList<NvTestSuiteResult>(values);
    }

    @JsonSetter
    public void setResults(List<NvTestSuiteResult> results) {
        if (null != results) {
            for (NvTestSuiteResult result : results) {
                this.results.put(result.getName(), result);
            }
        }
    }

    protected NvTestSuiteResult getNvTestSuiteResult(String testSuiteName) {
        return this.results.get(testSuiteName);
    }

    protected void addNvTestSuiteResult(NvTestSuiteResult testSuiteResult) {
        this.results.put(testSuiteResult.getName(), testSuiteResult);
    }

    public void tally() {
        for (NvTestSuiteResult testSuiteResult : this.results.values()) {
            testSuiteResult.tally();
        }
    }
}

