/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.plugin;

import com.hpe.nv.api.Flow;
import com.hpe.nv.api.IPRange;
import com.hpe.nv.api.NVExceptions;
import com.hpe.nv.api.Test;
import com.hpe.nv.api.TestManager;
import com.hpe.nv.api.Transaction;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStep;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.nvemulation.common.NvTestUtils;
import org.jenkinsci.plugins.nvemulation.common.NvValidatorUtils;
import org.jenkinsci.plugins.nvemulation.model.BandwidthEnum;
import org.jenkinsci.plugins.nvemulation.model.NvContext;
import org.jenkinsci.plugins.nvemulation.model.NvDataHolder;
import org.jenkinsci.plugins.nvemulation.model.NvModel;
import org.jenkinsci.plugins.nvemulation.model.NvNetworkProfile;
import org.jenkinsci.plugins.nvemulation.plugin.VariableInjectionAction;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvJUnitResultsHandler;
import org.jenkinsci.remoting.RoleChecker;

public class NvEmulationInvoker {
    private static final String SCENARIO_PREFIX = "Network Scenario ";
    private static final String DEFAULT_FLOW = "Flow_1";
    private static final String DEFAULT_TRANSACTION = "Transaction";
    private final NvModel nvModel;
    private AbstractBuild<?, ?> build;
    private Launcher launcher;
    private BuildListener listener;
    private List<String> possibleIps;
    private NvNetworkProfile currentProfile;
    private NvJUnitResultsHandler jUnitHandler = null;

    public NvEmulationInvoker(NvModel nvModel, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        this.nvModel = nvModel;
        this.build = build;
        this.launcher = launcher;
        this.listener = listener;
    }

    public boolean invoke() throws InterruptedException, IOException {
        List<NvNetworkProfile> profiles = this.nvModel.getProfiles();
        if (null == profiles || profiles.size() == 0) {
            return this.invokeBuildSteps(this.build, this.launcher, this.listener);
        }
        Map<String, Float> thresholdsMap = this.readThresholds();
        if (null == thresholdsMap) {
            this.listener.getLogger().println("Thresholds file is not valid. Tests will not be affected by thresholds. Check that the file exists and is readable. Check file contents correctness.");
        }
        if (null != this.nvModel.getReportFiles() && !this.nvModel.getReportFiles().isEmpty()) {
            this.jUnitHandler = new NvJUnitResultsHandler(thresholdsMap, this.nvModel.getReportFiles());
        } else {
            this.listener.getLogger().println("JUnit test xmls pattern is null or empty. Thresholds will not be imposed on tests.");
        }
        this.possibleIps = this.getPossibleIpAddresses();
        this.initProxy();
        Iterator<NvNetworkProfile> profilesIter = profiles.iterator();
        NvContext context = new NvContext();
        NvDataHolder.getInstance().put(NvTestUtils.getBuildKey(this.build), context);
        Test test = this.initAndStartTest(profilesIter);
        context.setTest(test);
        Transaction transaction = this.initTransaction(test);
        context.setTransaction(transaction);
        context.increaseRun();
        return this.invokePerProfile(context, profilesIter);
    }

    private Map<String, Float> readThresholds() throws IOException {
        if (null == this.nvModel.getThresholdsFile() || this.nvModel.getThresholdsFile().isEmpty() || !NvValidatorUtils.validateFile(this.nvModel.getThresholdsFile())) {
            return null;
        }
        return NvValidatorUtils.readThresholdsFile(this.nvModel.getThresholdsFile());
    }

    private boolean invokePerProfile(NvContext context, Iterator<NvNetworkProfile> profilersIter) throws IOException, InterruptedException {
        if (context.getRun() > 1) {
            this.currentProfile = profilersIter.next();
            this.listener.getLogger().print(this.currentProfile);
            Flow flow = this.createFlow(this.currentProfile);
            ArrayList<Flow> flows = new ArrayList<Flow>();
            flows.add(flow);
            try {
                context.getTest().realTimeUpdate(SCENARIO_PREFIX + this.currentProfile.getProfileName(), null, flows);
            }
            catch (NVExceptions.IllegalActionException | NVExceptions.ServerErrorException e) {
                throw new IOException("Failed to update network profile for profile: " + this.currentProfile.getProfileName() + ". Error: " + e.getMessage(), e);
            }
            this.listener.getLogger().println("Successfully updated network profile for profile: " + this.currentProfile.getProfileName());
        }
        try {
            context.getTransaction().start();
        }
        catch (NVExceptions.IllegalActionException | NVExceptions.ServerErrorException e) {
            throw new IOException("Failed to start transaction. Error: " + e.getMessage(), e);
        }
        this.listener.getLogger().println("Successfully started transaction.");
        this.invokeBuildSteps(this.build, this.launcher, this.listener);
        if (profilersIter.hasNext()) {
            try {
                context.getTransaction().stop();
            }
            catch (NVExceptions.ServerErrorException e) {
                throw new IOException("Failed to stop transaction. Error: " + e.getMessage(), e);
            }
            this.listener.getLogger().println("Successfully stopped transaction.");
            context.increaseRun();
            this.handleTestResults(false);
            return this.invokePerProfile(context, profilersIter);
        }
        NvTestUtils.stopTestEmulation(this.build, (TaskListener)this.listener);
        this.handleTestResults(true);
        return true;
    }

    private void handleTestResults(boolean finalize) throws IOException, InterruptedException {
        if (this.jUnitHandler != null) {
            this.jUnitHandler.handle(this.build, this.launcher, this.listener, this.currentProfile);
            if (finalize) {
                this.jUnitHandler.finalizeResults(this.build);
            }
        }
    }

    private Transaction initTransaction(Test test) throws IOException {
        try {
            test.connectToTransactionManager();
        }
        catch (NVExceptions.ServerErrorException e) {
            throw new IOException("Failed to connect to transaction manager. Error: " + e.getMessage(), e);
        }
        this.listener.getLogger().println("Successfully connected to transaction manager.");
        Transaction transaction = new Transaction(DEFAULT_TRANSACTION);
        try {
            transaction.addToTest(test);
        }
        catch (NVExceptions.ServerErrorException e) {
            throw new IOException("Failed to add transaction. Error: " + e.getMessage(), e);
        }
        this.listener.getLogger().println("Successfully added transaction.");
        return transaction;
    }

    private void initProxy() throws IOException, InterruptedException {
        if (this.nvModel.isUseProxy()) {
            if (this.nvModel.getNvServer().getProxyPort().isEmpty()) {
                throw new ConnectException("Proxy port was not configured for the selected NV Test Manager");
            }
            VariableInjectionAction action = new VariableInjectionAction(this.nvModel.getEnvVariable(), this.nvModel.getNvServer().getServerIp() + ":" + this.nvModel.getNvServer().getProxyPort());
            this.build.addAction((Action)action);
        }
    }

    private Test initAndStartTest(Iterator<NvNetworkProfile> profilersIter) throws IOException {
        Test test;
        TestManager tm = new TestManager(this.nvModel.getNvServer().getServerIp(), Integer.parseInt(this.nvModel.getNvServer().getNvPort()), this.nvModel.getNvServer().getUsername(), this.nvModel.getNvServer().getPassword());
        try {
            tm.init();
        }
        catch (NVExceptions.MissingPropertyException | NVExceptions.ServerErrorException e) {
            throw new IOException("Failed to start Network Virtualization emulation on host. Error: " + e.getMessage(), e);
        }
        this.listener.getLogger().println("Created Network Virtualization emulation.");
        this.currentProfile = profilersIter.next();
        this.listener.getLogger().print(this.currentProfile);
        String testId = NvTestUtils.getNvTestId(this.build);
        try {
            test = new Test(tm, testId, SCENARIO_PREFIX + this.currentProfile.getProfileName());
            test.setTestMode(Test.Mode.CUSTOM);
            if (this.nvModel.isUseProxy()) {
                test.setUseNVProxy(true);
            }
        }
        catch (NVExceptions.MissingPropertyException e) {
            throw new IOException("Failed to create Network Virtualiation test", e);
        }
        this.listener.getLogger().println("Created Network Virtualization test.");
        try {
            Flow flow = this.createFlow(this.currentProfile);
            test.addFlow(flow);
        }
        catch (NVExceptions.MissingPropertyException | NVExceptions.NotSupportedException e) {
            throw new IOException("Failed to add Network Virtualiation flow to test.", e);
        }
        try {
            test.start();
        }
        catch (NVExceptions.IllegalActionException | NVExceptions.NotSupportedException | NVExceptions.ServerErrorException e) {
            throw new IOException("Failed to start Network Virtualization test. Error: " + e.getMessage(), e);
        }
        this.listener.getLogger().println("Network Virtualization test was started successfully.");
        return test;
    }

    private Flow createFlow(NvNetworkProfile nvProfile) throws IOException {
        try {
            double bandwidthIn = BandwidthEnum.valueOf(nvProfile.getBandwidthIn()).getValue();
            double bandwidthOut = BandwidthEnum.valueOf(nvProfile.getBandwidthOut()).getValue();
            Flow flow = new Flow(DEFAULT_FLOW, Double.parseDouble(nvProfile.getLatency()), Double.parseDouble(nvProfile.getPacket()), bandwidthIn, bandwidthOut);
            flow.includeDestIPRange(new IPRange(null, null, 0, IPRange.Protocol.ALL.getId()));
            this.addIncludeClientIPs(flow);
            this.addCustomExcludeServerIPs(flow);
            if (this.nvModel.isUseProxy()) {
                flow.excludeDestIPRange(new IPRange(this.nvModel.getNvServer().getServerIp(), this.nvModel.getNvServer().getServerIp(), 0, IPRange.Protocol.ALL.getId()));
            }
            return flow;
        }
        catch (NVExceptions.IllegalArgumentException | NVExceptions.MissingPropertyException | NVExceptions.NotSupportedException e) {
            throw new IOException("Failed to create Network Virtualiation flow.", e);
        }
    }

    private void addIncludeClientIPs(Flow flow) throws NVExceptions.NotSupportedException, NVExceptions.IllegalArgumentException {
        HashSet<String> ips = new HashSet<String>(this.possibleIps);
        boolean invalidIpsFound = false;
        if (null != this.nvModel.getIncludeClientIPs() && !this.nvModel.getIncludeClientIPs().isEmpty()) {
            String[] includedIps;
            for (String ip : includedIps = this.nvModel.getIncludeClientIPs().split(";")) {
                if (ip.isEmpty()) continue;
                if (this.isIpValid(ip)) {
                    ips.add(ip);
                    continue;
                }
                invalidIpsFound = true;
            }
            if (invalidIpsFound) {
                this.listener.getLogger().println("Invalid IPs were found in \"Include Client IPs\" section. It might affect network emulation");
            }
        }
        for (String includedIp : ips) {
            if (includedIp.isEmpty()) continue;
            if (includedIp.contains("-")) {
                String[] ranges = includedIp.split("-");
                flow.includeSourceIPRange(new IPRange(ranges[0], ranges[1], 0, IPRange.Protocol.ALL.getId()));
                flow.excludeDestIPRange(new IPRange(ranges[0], ranges[1], 0, IPRange.Protocol.ALL.getId()));
                continue;
            }
            flow.includeSourceIPRange(new IPRange(includedIp, includedIp, 0, IPRange.Protocol.ALL.getId()));
            flow.excludeDestIPRange(new IPRange(includedIp, includedIp, 0, IPRange.Protocol.ALL.getId()));
        }
    }

    private boolean isIpValid(String ip) {
        if (ip.contains("-")) {
            String[] ranges = ip.split("-");
            if (!NvValidatorUtils.isValidHostIp(ranges[0]) || !NvValidatorUtils.isValidHostIp(ranges[1])) {
                this.listener.getLogger().println("IP range: " + ip + " contains an invalid IPv4 address");
                return false;
            }
        } else if (!NvValidatorUtils.isValidHostIp(ip)) {
            this.listener.getLogger().println("IP: " + ip + " is an invalid IPv4 address");
            return false;
        }
        return true;
    }

    private void addCustomExcludeServerIPs(Flow flow) throws NVExceptions.NotSupportedException, NVExceptions.IllegalArgumentException {
        if (null != this.nvModel.getExcludeServerIPs() && !this.nvModel.getExcludeServerIPs().isEmpty()) {
            String[] excludedIps = this.nvModel.getExcludeServerIPs().split(";");
            boolean invalidIpsFound = false;
            for (String excludedIp : excludedIps) {
                if (excludedIp.isEmpty()) continue;
                if (this.isIpValid(excludedIp)) {
                    if (excludedIp.contains("-")) {
                        String[] ranges = excludedIp.split("-");
                        flow.excludeDestIPRange(new IPRange(ranges[0], ranges[1], 0, IPRange.Protocol.ALL.getId()));
                        continue;
                    }
                    flow.excludeDestIPRange(new IPRange(excludedIp, excludedIp, 0, IPRange.Protocol.ALL.getId()));
                    continue;
                }
                invalidIpsFound = true;
            }
            if (invalidIpsFound) {
                this.listener.getLogger().println("Invalid IPs were found in \"Exclude Server IPs\" section");
            }
        }
    }

    private List<String> getPossibleIpAddresses() throws IOException, InterruptedException {
        return (List)this.launcher.getChannel().call((Callable)new HostIpRetrieverCallable());
    }

    private boolean invokeBuildSteps(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        boolean result = true;
        for (BuildStep step : this.nvModel.getSteps()) {
            result = step.perform(build, launcher, listener);
        }
        return result;
    }

    public static class HostIpRetrieverCallable
    implements Callable<List<String>, IOException> {
        private static final long serialVersionUID = 3959091053778932297L;

        public List<String> call() throws IOException {
            ArrayList<String> result = new ArrayList<String>();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                Enumeration<InetAddress> inetAddresses = networkInterfaces.nextElement().getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    result.add(inetAddress.getHostAddress());
                }
            }
            return result;
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }
    }
}

