/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.plugin;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.nvemulation.common.NvNetworkProfileRegistry;
import org.jenkinsci.plugins.nvemulation.common.NvValidatorUtils;
import org.jenkinsci.plugins.nvemulation.model.NvModel;
import org.jenkinsci.plugins.nvemulation.model.NvNetworkProfile;
import org.jenkinsci.plugins.nvemulation.model.NvServer;
import org.jenkinsci.plugins.nvemulation.plugin.NetworkProfileSelector;
import org.jenkinsci.plugins.nvemulation.plugin.NvEmulationInvoker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class NvEmulationBuilder
extends Builder {
    private final NvModel nvModel;
    private Set<NetworkProfileSelector> profileNames = new HashSet<NetworkProfileSelector>();

    @DataBoundConstructor
    public NvEmulationBuilder(String serverName, String includeClientIPs, String excludeServerIPs, String reportFiles, String thresholdsFile, UseProxyCheckbox useProxyCheckbox, List<BuildStep> steps) {
        String envVariable = useProxyCheckbox == null ? null : useProxyCheckbox.getEnvVariable();
        this.nvModel = new NvModel(serverName, includeClientIPs, excludeServerIPs, envVariable, reportFiles, thresholdsFile, steps);
        this.nvModel.setNvServer(this.getNvServer(serverName));
    }

    public NvModel getNvModel() {
        return this.nvModel;
    }

    public String getServerName() {
        return this.nvModel.getServerName();
    }

    public NetworkProfileSelector[] getProfileNames() {
        if (null == this.profileNames) {
            this.profileNames = new HashSet<NetworkProfileSelector>();
        }
        return this.profileNames.toArray(new NetworkProfileSelector[this.profileNames.size()]);
    }

    @DataBoundSetter
    public void setProfileNames(NetworkProfileSelector[] profileNames) {
        if (profileNames != null) {
            this.profileNames.addAll(Arrays.asList(profileNames));
            ArrayList<String> profileNamesList = new ArrayList<String>();
            for (NetworkProfileSelector profileName : profileNames) {
                profileNamesList.add(profileName.getProfileName());
            }
            this.nvModel.setProfiles(NvNetworkProfileRegistry.getInstance().getNetworkProfiles(profileNamesList));
        }
    }

    private NvServer getNvServer(String serverName) {
        return this.getDescriptor().getNvServer(serverName);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return new NvEmulationInvoker(this.nvModel, build, launcher, listener).invoke();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static class UseProxyCheckbox {
        private String envVariable;

        @DataBoundConstructor
        public UseProxyCheckbox(String envVariable) {
            this.envVariable = envVariable;
        }

        public String getEnvVariable() {
            return this.envVariable;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private List<NvNetworkProfile> customProfiles = new ArrayList<NvNetworkProfile>();
        private List<NvServer> nvServers = new ArrayList<NvServer>();

        public DescriptorImpl() {
            this.load();
            this.registerCustomProfiles();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.customProfiles = new ArrayList<NvNetworkProfile>(req.bindJSONToList(NvNetworkProfile.class, formData.get("customProfiles")));
            this.unregisterCustomProfiles();
            this.registerCustomProfiles();
            this.nvServers = new ArrayList<NvServer>(req.bindJSONToList(NvServer.class, formData.get("nvServers")));
            this.save();
            return super.configure(req, formData);
        }

        private void registerCustomProfiles() {
            NvNetworkProfileRegistry.getInstance().register(this.customProfiles);
        }

        private void unregisterCustomProfiles() {
            NvNetworkProfileRegistry.getInstance().unregisterCustom();
        }

        public NvNetworkProfile[] getCustomProfiles() {
            return this.customProfiles.toArray(new NvNetworkProfile[this.customProfiles.size()]);
        }

        public NvServer[] getNvServers() {
            return this.nvServers.toArray(new NvServer[this.nvServers.size()]);
        }

        public NvServer getNvServer(String serverName) {
            NvServer result = null;
            for (NvServer nvServer : this.nvServers) {
                if (!serverName.equals(nvServer.getServerName())) continue;
                result = nvServer;
                break;
            }
            return result;
        }

        public ListBoxModel doFillServerNameItems() {
            ListBoxModel items = new ListBoxModel();
            for (NvServer nvServer : this.nvServers) {
                items.add(nvServer.getServerName(), nvServer.getServerName());
            }
            return items;
        }

        public FormValidation doCheckIncludeClientIPs(@QueryParameter String value) throws IOException, ServletException {
            return this.validateIPs(value);
        }

        public FormValidation doCheckExcludeServerIPs(@QueryParameter String value) throws IOException, ServletException {
            return this.validateIPs(value);
        }

        private FormValidation validateIPs(String value) {
            String[] ips;
            value = value.replace(" ", "");
            for (String ip : ips = value.split(";")) {
                if (ip.isEmpty()) continue;
                if (ip.contains("-")) {
                    String[] ranges = ip.split("-");
                    if (NvValidatorUtils.isValidHostIp(ranges[0]) && NvValidatorUtils.isValidHostIp(ranges[1])) continue;
                    return FormValidation.error((String)"IP range must contain valid IPv4 addresses");
                }
                if (NvValidatorUtils.isValidHostIp(ip)) continue;
                return FormValidation.error((String)"IP must be a valid IPv4 address");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUseProxyCheckbox(@QueryParameter String value, @QueryParameter String serverName) throws IOException, ServletException {
            boolean isProxyChecked;
            NvServer nvServer = this.getNvServer(serverName);
            if (null != nvServer && (isProxyChecked = Boolean.parseBoolean(value)) && nvServer.getProxyPort().isEmpty()) {
                return FormValidation.error((String)"The proxy port for the selected NV Test Manager was not configured");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEnvVariable(@QueryParameter String value) throws IOException, ServletException {
            if (value.trim().length() == 0) {
                return FormValidation.error((String)"Please set an environment variable name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckReportFiles(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
            if (value.trim().length() == 0) {
                return FormValidation.error((String)"Please set pattern for test report XMLs");
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public FormValidation doCheckThresholdsFile(@QueryParameter String value) throws IOException, ServletException {
            if (value.trim().length() == 0) {
                return FormValidation.error((String)"Please set file location");
            }
            if (!NvValidatorUtils.validateFile(value)) {
                return FormValidation.error((String)"File can not be read. Check that the file exists and can be accessed");
            }
            try {
                if (null == NvValidatorUtils.readThresholdsFile(value)) {
                    return FormValidation.error((String)"File must contain valid threshold records. Please check the help tooltip");
                }
            }
            catch (IOException e) {
                return FormValidation.error((String)"An error occurred while trying to read the specified file");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "HPE Network Virtualization";
        }

        public List<? extends Descriptor<? extends BuildStep>> getSteps(AbstractProject<?, ?> project) {
            ArrayList<BuildStepDescriptor> builders = new ArrayList<BuildStepDescriptor>();
            if (null == project) {
                return builders;
            }
            for (Descriptor descriptor : Builder.all()) {
                BuildStepDescriptor buildStepDescriptor;
                if (descriptor instanceof DescriptorImpl || !(buildStepDescriptor = (BuildStepDescriptor)descriptor).isApplicable(project.getClass()) || !this.hasDbc(buildStepDescriptor.clazz)) continue;
                builders.add(buildStepDescriptor);
            }
            return builders;
        }

        private boolean hasDbc(Class<?> clazz) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (!constructor.isAnnotationPresent(DataBoundConstructor.class)) continue;
                return true;
            }
            return false;
        }
    }
}

