/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.nvemulation.common.NvValidatorUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@JsonIgnoreProperties(value={"serialVersionUID"})
public class NvServer
extends AbstractDescribableImpl<NvServer>
implements Serializable {
    private static final long serialVersionUID = -5822820278864676678L;
    private String serverName;
    private String serverIp;
    private String nvPort;
    private String proxyPort;
    private String username;
    private String password;

    @DataBoundConstructor
    public NvServer(String serverName, String serverIp, String nvPort, String proxyPort, String username, String password) {
        this.serverName = serverName;
        this.serverIp = serverIp;
        this.nvPort = nvPort;
        this.proxyPort = proxyPort;
        this.username = username;
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public String getNvPort() {
        return this.nvPort;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "NvServer{serverName='" + this.serverName + '\'' + ", serverIp='" + this.serverIp + '\'' + ", nvPort='" + this.nvPort + '\'' + ", proxyPort='" + this.proxyPort + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + '}';
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<NvServer> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckServerName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a server name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServerIp(@QueryParameter String value) throws IOException, ServletException {
            if ((value = value.trim()).length() == 0) {
                return FormValidation.error((String)"Please set an IPv4 address");
            }
            if (!NvValidatorUtils.isValidHostIp(value)) {
                return FormValidation.error((String)"Value must be a valid IPv4 address");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNvPort(@QueryParameter String value) throws IOException, ServletException {
            return this.validatePort(value, true);
        }

        public FormValidation doCheckProxyPort(@QueryParameter String value) throws IOException, ServletException {
            return this.validatePort(value, false);
        }

        private FormValidation validatePort(String value, boolean isMandatory) {
            value = value.trim();
            if (isMandatory && value.length() == 0) {
                return FormValidation.error((String)"Please set a port");
            }
            try {
                int port = 0;
                if (value.length() > 0 && (port = Integer.parseInt(value)) <= 0) {
                    return FormValidation.error((String)"Port must be a positive integer");
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Port must be a positive integer");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUsername(@QueryParameter String value) throws IOException, ServletException {
            if (value.trim().length() == 0) {
                return FormValidation.error((String)"Please enter a username");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value) throws IOException, ServletException {
            if (value.trim().length() == 0) {
                return FormValidation.error((String)"Please enter a password");
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "NV Test Manager";
        }
    }
}

