/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.InetAddressValidator;

public class NvValidatorUtils {
    private static final Pattern FQ_CLASS_NAME_PATTERN = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Pattern POSITIVE_FLOATING_POINT_PATTERN = Pattern.compile("^[+]?[0-9]*\\.?[0-9]+$");
    private static final String DEFAULT_THRESHOLD = "default";

    public static boolean isValidHostIp(String address) {
        return InetAddressValidator.getInstance().isValidInet4Address(address);
    }

    public static boolean validateClassName(String identifier) {
        return FQ_CLASS_NAME_PATTERN.matcher(identifier).matches();
    }

    public static boolean validateFloatingPoint(String number) {
        return POSITIVE_FLOATING_POINT_PATTERN.matcher(number).matches();
    }

    public static boolean validateFloatingPoint(String number, double maxValue) {
        Double dVal;
        boolean isValid = NvValidatorUtils.validateFloatingPoint(number);
        if (isValid && ((dVal = Double.valueOf(Double.parseDouble(number))) < 0.0 || dVal > maxValue)) {
            isValid = false;
        }
        return isValid;
    }

    public static boolean validateFile(String fileName) {
        File thresholdFile = new File(fileName);
        Path filePath = thresholdFile.toPath();
        return Files.isReadable(filePath);
    }

    public static Map<String, Float> readThresholdsFile(String fileName) throws IOException {
        String line;
        HashMap<String, Float> result = new HashMap<String, Float>();
        BufferedReader br = new BufferedReader(new FileReader(new File(fileName)));
        while (null != (line = br.readLine())) {
            if (NvValidatorUtils.isComment(line)) continue;
            String[] parts = line.split(",");
            if (line.startsWith(DEFAULT_THRESHOLD)) {
                if (parts.length != 2 || !NvValidatorUtils.validateFloatingPoint(parts[1])) {
                    return null;
                }
                result.put(parts[0], Float.valueOf(Float.parseFloat(parts[1])));
                continue;
            }
            if (parts.length != 3 || !NvValidatorUtils.validateClassName(parts[0]) || parts[1].isEmpty() || !NvValidatorUtils.validateFloatingPoint(parts[2])) {
                return null;
            }
            result.put(parts[0] + "." + parts[1], Float.valueOf(Float.parseFloat(parts[2])));
        }
        return result;
    }

    private static boolean isComment(String line) {
        return line.startsWith("//") || line.startsWith("#");
    }
}

