/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import groovy.lang.Binding;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.groovy.AbstractGroovy;
import hudson.plugins.groovy.FileScriptSource;
import hudson.plugins.groovy.FileSystemScriptSource;
import hudson.plugins.groovy.ScriptSource;
import hudson.plugins.groovy.StringScriptSource;
import hudson.plugins.groovy.StringSystemScriptSource;
import hudson.plugins.groovy.SystemScriptSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SystemGroovy
extends AbstractGroovy {
    private SystemScriptSource source;
    private String bindings;
    @Deprecated
    private transient String command;
    @Deprecated
    private transient ScriptSource scriptSource;
    @Deprecated
    private transient String classpath;

    @DataBoundConstructor
    public SystemGroovy(SystemScriptSource source) {
        this.source = source;
    }

    @Deprecated
    public SystemGroovy(ScriptSource scriptSource, String bindings, String classpath) {
        this.source = scriptSource instanceof StringScriptSource ? new StringSystemScriptSource(new SecureGroovyScript(((StringScriptSource)scriptSource).getCommand(), false, null)) : new FileSystemScriptSource(((FileScriptSource)scriptSource).getScriptFile());
        this.bindings = bindings;
        if (Util.fixEmpty((String)classpath) != null) {
            throw new UnsupportedOperationException("classpath no longer supported");
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Object output = this.run(build, listener, launcher);
        if (output instanceof Boolean) {
            return (Boolean)output;
        }
        if (output != null) {
            listener.getLogger().println("Script returned: " + output);
        }
        if (output instanceof Number) {
            return ((Number)output).intValue() == 0;
        }
        return true;
    }

    Object run(AbstractBuild<?, ?> build, BuildListener listener, @CheckForNull Launcher launcher) throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins instance is null - Jenkins is shutting down?");
        }
        ClassLoader cl = jenkins.getPluginManager().uberClassLoader;
        HashMap<Object, Object> binding = new HashMap<Object, Object>();
        binding.putAll(SystemGroovy.parseProperties(this.bindings));
        binding.put("build", build);
        if (launcher != null) {
            binding.put("launcher", launcher);
        }
        if (listener != null) {
            binding.put("listener", listener);
            binding.put("out", listener.getLogger());
        }
        try {
            return this.source.getSecureGroovyScript(build.getWorkspace(), build, (TaskListener)listener).evaluate(cl, new Binding(binding));
        }
        catch (IOException x) {
            throw x;
        }
        catch (InterruptedException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new IOException(x);
        }
    }

    private Object readResolve() throws Exception {
        if (this.command != null) {
            this.source = new StringSystemScriptSource(new SecureGroovyScript(this.command, false, null).configuring(ApprovalContext.create()));
            this.command = null;
        } else if (this.scriptSource instanceof StringScriptSource) {
            ArrayList<ClasspathEntry> classpathEntries = new ArrayList<ClasspathEntry>();
            if (this.classpath != null) {
                StringTokenizer tokens = new StringTokenizer(this.classpath);
                while (tokens.hasMoreTokens()) {
                    ClasspathEntry ce = new ClasspathEntry(tokens.nextToken());
                    if (ce.isClassDirectory()) {
                        throw new UnsupportedOperationException("directory-based classpath entries not supported in system Groovy script string source");
                    }
                    classpathEntries.add(ce);
                }
            }
            this.source = new StringSystemScriptSource(new SecureGroovyScript(Util.fixNull((String)((StringScriptSource)this.scriptSource).getCommand()), false, classpathEntries).configuring(ApprovalContext.create()));
            this.scriptSource = null;
        } else if (this.scriptSource instanceof FileScriptSource) {
            if (Util.fixEmpty((String)this.classpath) != null) {
                throw new UnsupportedOperationException("classpath no longer supported in conjunction with system Groovy script file source");
            }
            this.source = new FileSystemScriptSource(((FileScriptSource)this.scriptSource).getScriptFile());
            this.scriptSource = null;
        }
        return this;
    }

    public SystemScriptSource getSource() {
        return this.source;
    }

    public String getBindings() {
        return Util.fixEmpty((String)this.bindings);
    }

    @DataBoundSetter
    public void setBindings(String bindings) {
        this.bindings = Util.fixEmpty((String)bindings);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractGroovy.AbstractGroovyDescriptor {
        public DescriptorImpl() {
            super(SystemGroovy.class);
            this.load();
        }

        public String getDisplayName() {
            return "Execute system Groovy script";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

