/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.groovy.ScriptSource;
import hudson.util.FormValidation;
import java.io.IOException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StringScriptSource
extends ScriptSource {
    private String command;

    @DataBoundConstructor
    public StringScriptSource(String command) {
        this.command = command;
    }

    @Override
    public FilePath getScriptFile(FilePath projectWorkspace, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        return projectWorkspace.createTextTempFile("hudson", ".groovy", this.command, true);
    }

    public String getCommand() {
        return this.command;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringScriptSource that = (StringScriptSource)o;
        return this.command != null ? this.command.equals(that.command) : that.command == null;
    }

    public int hashCode() {
        return this.command != null ? this.command.hashCode() : 0;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ScriptSource> {
        public String getDisplayName() {
            return "Groovy command";
        }

        public FormValidation doCheckScript(@QueryParameter String command) {
            if (command == null || command.trim().isEmpty()) {
                return FormValidation.error((String)"Script seems to be empty string!");
            }
            try {
                new GroovyShell(GroovySandbox.createSecureCompilerConfiguration()).parse(command);
                return FormValidation.ok((String)"So far so good");
            }
            catch (CompilationFailedException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

