/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googlelogin;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeResponseUrl;
import hudson.remoting.Base64;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;

public abstract class OAuthSession
implements Serializable {
    private static final long serialVersionUID = 1438835558745081350L;
    private final String uuid = Base64.encode((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8)).substring(0, 20);
    private final String from;
    private final String redirectUrl;
    private final String domain;

    public OAuthSession(String from, String redirectUrl, String domain) {
        this.from = from;
        this.redirectUrl = redirectUrl;
        this.domain = domain;
    }

    public HttpResponse doCommenceLogin(AuthorizationCodeFlow flow) throws IOException {
        AuthorizationCodeRequestUrl authorizationCodeRequestUrl = flow.newAuthorizationUrl().setState(this.uuid).setRedirectUri(this.redirectUrl);
        if (this.domain != null) {
            if (this.domain.contains(",")) {
                authorizationCodeRequestUrl.set("hd", (Object)"*");
            } else {
                authorizationCodeRequestUrl.set("hd", (Object)this.domain);
            }
        }
        return new HttpRedirect(authorizationCodeRequestUrl.toString());
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        AuthorizationCodeResponseUrl responseUrl;
        if (request.getParameter("state") == null) {
            return HttpResponses.redirectToContextRoot();
        }
        StringBuffer buf = request.getRequestURL();
        if (request.getQueryString() != null) {
            buf.append('?').append(request.getQueryString());
        }
        if (!this.uuid.equals((responseUrl = new AuthorizationCodeResponseUrl(buf.toString())).getState())) {
            return HttpResponses.error((int)401, (String)"State is invalid");
        }
        String code = responseUrl.getCode();
        if (responseUrl.getError() != null) {
            return HttpResponses.error((int)401, (String)("Error from provider: " + code));
        }
        if (code == null) {
            return HttpResponses.error((int)404, (String)"Missing authorization code");
        }
        return this.onSuccess(code);
    }

    protected String getFrom() {
        return this.from;
    }

    protected abstract HttpResponse onSuccess(String var1) throws IOException;
}

