/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googlelogin;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeResponseUrl;
import hudson.remoting.Base64;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class OAuthSession {
    private final AuthorizationCodeFlow flow;
    private final String uuid = Base64.encode((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8)).substring(0, 20);
    private final String from;
    private final String redirectUrl;
    private final String domain;
    private static final String SESSION_NAME = OAuthSession.class.getName();

    public OAuthSession(AuthorizationCodeFlow flow, String from, String redirectUrl, String domain) {
        this.flow = flow;
        this.from = from;
        this.redirectUrl = redirectUrl;
        this.domain = domain;
    }

    public HttpResponse doCommenceLogin() throws IOException {
        Stapler.getCurrentRequest().getSession().setAttribute(SESSION_NAME, (Object)this);
        AuthorizationCodeRequestUrl authorizationCodeRequestUrl = this.flow.newAuthorizationUrl().setState(this.uuid).setRedirectUri(this.redirectUrl);
        if (this.domain != null) {
            authorizationCodeRequestUrl.set("hd", (Object)this.domain);
        }
        return new HttpRedirect(authorizationCodeRequestUrl.toString());
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        AuthorizationCodeResponseUrl responseUrl;
        StringBuffer buf = request.getRequestURL();
        if (request.getQueryString() != null) {
            buf.append('?').append(request.getQueryString());
        }
        if (!this.uuid.equals((responseUrl = new AuthorizationCodeResponseUrl(buf.toString())).getState())) {
            return HttpResponses.error((int)401, (String)"State is invalid");
        }
        String code = responseUrl.getCode();
        if (responseUrl.getError() != null) {
            return HttpResponses.error((int)401, (String)("Error from provider: " + code));
        }
        if (code == null) {
            return HttpResponses.error((int)404, (String)"Missing authorization code");
        }
        return this.onSuccess(code);
    }

    protected String getFrom() {
        return this.from;
    }

    protected abstract HttpResponse onSuccess(String var1) throws IOException;

    public static OAuthSession getCurrent() {
        return (OAuthSession)Stapler.getCurrentRequest().getSession().getAttribute(SESSION_NAME);
    }
}

