/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine.client;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.CloudResourceManagerRequestInitializer;
import com.google.api.services.container.Container;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.k8sengine.CredentialsUtil;
import com.google.jenkins.plugins.k8sengine.client.CloudResourceManagerClient;
import com.google.jenkins.plugins.k8sengine.client.ContainerClient;
import com.google.jenkins.plugins.k8sengine.client.Messages;
import com.google.jenkins.plugins.k8sengine.client.RetryHttpInitializerWrapper;
import hudson.AbortException;
import hudson.model.ItemGroup;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;

public class ClientFactory {
    public static final String APPLICATION_NAME = "jenkins-google-gke-plugin";
    private final Credential credential;
    private final HttpTransport transport;
    private final JsonFactory jsonFactory;
    private final String credentialsId;
    private final String defaultProjectId;

    public ClientFactory(ItemGroup itemGroup, ImmutableList<DomainRequirement> domainRequirements, String credentialsId, Optional<HttpTransport> httpTransport) throws AbortException {
        GoogleRobotCredentials robotCreds = CredentialsUtil.getRobotCredentials(itemGroup, domainRequirements, credentialsId);
        this.credential = CredentialsUtil.getGoogleCredential(robotCreds);
        this.defaultProjectId = Strings.isNullOrEmpty((String)robotCreds.getProjectId()) ? "" : robotCreds.getProjectId();
        this.credentialsId = credentialsId;
        try {
            this.transport = httpTransport.orElse((HttpTransport)GoogleNetHttpTransport.newTrustedTransport());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new AbortException(Messages.ClientFactory_FailedToInitializeHTTPTransport(e.getMessage()));
        }
        this.jsonFactory = new JacksonFactory();
    }

    public ClientFactory(ItemGroup itemGroup, String credentialsId) throws AbortException {
        this(itemGroup, (ImmutableList<DomainRequirement>)ImmutableList.of(), credentialsId, Optional.empty());
    }

    public ContainerClient containerClient() {
        return new ContainerClient(new Container.Builder(this.transport, this.jsonFactory, (HttpRequestInitializer)this.credential).setGoogleClientRequestInitializer(request -> request.setRequestHeaders(request.getRequestHeaders().setUserAgent(APPLICATION_NAME))).setHttpRequestInitializer((HttpRequestInitializer)new RetryHttpInitializerWrapper(this.credential)).setApplicationName(APPLICATION_NAME).build());
    }

    public CloudResourceManagerClient cloudResourceManagerClient() {
        return new CloudResourceManagerClient(new CloudResourceManager.Builder(this.transport, this.jsonFactory, (HttpRequestInitializer)new RetryHttpInitializerWrapper(this.credential)).setGoogleClientRequestInitializer(request -> request.setRequestHeaders(request.getRequestHeaders().setUserAgent(APPLICATION_NAME))).setApplicationName(APPLICATION_NAME).setCloudResourceManagerRequestInitializer(new CloudResourceManagerRequestInitializer()).build());
    }

    public String getDefaultProjectId() {
        return this.defaultProjectId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }
}

