/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.k8sengine.KubeConfig;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidJsonException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class KubectlWrapper {
    private static final Logger LOGGER = Logger.getLogger(KubectlWrapper.class.getName());
    private static final String CHARSET = "UTF-8";
    private KubeConfig kubeConfig;
    private Launcher launcher;
    private FilePath workspace;
    private String namespace;
    private boolean verboseLogging;

    private KubectlWrapper() {
    }

    private KubeConfig getKubeConfig() {
        return this.kubeConfig;
    }

    private void setKubeConfig(KubeConfig kubeConfig) {
        this.kubeConfig = kubeConfig;
    }

    private void setLauncher(Launcher launcher) {
        this.launcher = launcher;
    }

    private Launcher getLauncher() {
        return this.launcher;
    }

    private void setWorkspace(FilePath workspace) {
        this.workspace = workspace;
    }

    private FilePath getWorkspace() {
        return this.workspace;
    }

    private void setNamespace(String namespace) {
        this.namespace = namespace == null ? "" : namespace;
    }

    private String getNamespace() {
        return this.namespace;
    }

    private void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    private boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public String runKubectlCommand(String command, ImmutableList<String> args) throws IOException, InterruptedException {
        String output = "";
        HashSet<String> tempFiles = new HashSet<String>();
        try {
            FilePath kubeConfigFile = this.workspace.createTempFile(".kube", "config");
            tempFiles.add(kubeConfigFile.getRemote());
            String config = this.getKubeConfig().toYaml();
            kubeConfigFile.write(config, null);
            KubectlWrapper.launchAndJoinCommand(this.getLauncher(), new ArgumentListBuilder().add("kubectl").add("--kubeconfig").add(kubeConfigFile.getRemote()).add("config").add("use-context").add(this.kubeConfig.getCurrentContext()).toList(), this.verboseLogging);
            ArgumentListBuilder kubectlCmdBuilder = new ArgumentListBuilder().add("kubectl").add("--kubeconfig").add(kubeConfigFile.getRemote()).add(command);
            if (!this.namespace.isEmpty()) {
                kubectlCmdBuilder.add("--namespace").add(this.namespace);
            }
            args.forEach(arg_0 -> ((ArgumentListBuilder)kubectlCmdBuilder).add(arg_0));
            output = KubectlWrapper.launchAndJoinCommand(this.getLauncher(), kubectlCmdBuilder.toList(), this.verboseLogging);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, String.format("Failed to execute kubectl command: %s, args: %s", command, args), e);
            throw e;
        }
        finally {
            for (String tempFile : tempFiles) {
                this.getWorkspace().child(tempFile).delete();
            }
        }
        return output;
    }

    private static String launchAndJoinCommand(Launcher launcher, List<String> args, boolean verboseLogging) throws IOException, InterruptedException {
        ByteArrayOutputStream cmdLogStream = new ByteArrayOutputStream();
        int status = launcher.launch().cmds(args).stderr((OutputStream)cmdLogStream).stdout((OutputStream)cmdLogStream).quiet(!verboseLogging).join();
        if (status != 0) {
            String logs = cmdLogStream.toString(CHARSET);
            LOGGER.log(Level.SEVERE, String.format("kubectl command log: %s", logs));
            throw new IOException(String.format("Failed to launch command args: %s, status: %s. Logs: %s", args, status, logs));
        }
        return cmdLogStream.toString(CHARSET);
    }

    public Object getObject(String kind, String name) throws IOException, InterruptedException {
        String json = this.runKubectlCommand("get", (ImmutableList<String>)ImmutableList.of((Object)kind, (Object)name, (Object)"-o", (Object)"json"));
        return Configuration.defaultConfiguration().jsonProvider().parse(json);
    }

    public ImmutableList<Object> getObjectsThatMatchLabels(String kind, Map<String, String> labels) throws IOException, InterruptedException, InvalidJsonException {
        String labelsArg = labels.keySet().stream().map(k -> String.format("%s=%s", k, labels.get(k))).collect(Collectors.joining(","));
        String json = this.runKubectlCommand("get", (ImmutableList<String>)ImmutableList.of((Object)(kind + "s"), (Object)labelsArg));
        Map result = (Map)Configuration.defaultConfiguration().jsonProvider().parse(json);
        List items = (List)result.get("items");
        return ImmutableList.copyOf((Collection)items);
    }

    public static class Builder {
        private KubectlWrapper wrapper = new KubectlWrapper();

        public Builder launcher(Launcher launcher) {
            this.wrapper.setLauncher(launcher);
            return this;
        }

        public Builder kubeConfig(KubeConfig kubeConfig) {
            this.wrapper.setKubeConfig(kubeConfig);
            return this;
        }

        public Builder workspace(FilePath workspace) {
            this.wrapper.setWorkspace(workspace);
            return this;
        }

        public Builder namespace(String namespace) {
            this.wrapper.setNamespace(namespace);
            return this;
        }

        Builder verboseLogging(boolean verboseLogging) {
            this.wrapper.setVerboseLogging(verboseLogging);
            return this;
        }

        public KubectlWrapper build() {
            Preconditions.checkNotNull((Object)this.wrapper.getLauncher());
            Preconditions.checkNotNull((Object)this.wrapper.getKubeConfig());
            Preconditions.checkNotNull((Object)this.wrapper.getWorkspace());
            Preconditions.checkNotNull((Object)this.wrapper.getNamespace());
            return this.wrapper;
        }
    }
}

