/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.api.services.compute.model.AcceleratorConfig;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.AttachedDiskInitializeParams;
import com.google.api.services.compute.model.DiskType;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.ServiceAccount;
import com.google.api.services.compute.model.Tags;
import com.google.api.services.compute.model.Zone;
import com.google.cloud.graphite.platforms.plugin.client.ClientFactory;
import com.google.cloud.graphite.platforms.plugin.client.ComputeClient;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.computeengine.AcceleratorConfiguration;
import com.google.jenkins.plugins.computeengine.AutofilledNetworkConfiguration;
import com.google.jenkins.plugins.computeengine.ComputeEngineCloud;
import com.google.jenkins.plugins.computeengine.ComputeEngineComputerLauncher;
import com.google.jenkins.plugins.computeengine.ComputeEngineInstance;
import com.google.jenkins.plugins.computeengine.ComputeEngineLinuxLauncher;
import com.google.jenkins.plugins.computeengine.ComputeEngineRetentionStrategy;
import com.google.jenkins.plugins.computeengine.ComputeEngineWindowsLauncher;
import com.google.jenkins.plugins.computeengine.Messages;
import com.google.jenkins.plugins.computeengine.NetworkConfiguration;
import com.google.jenkins.plugins.computeengine.SshConfiguration;
import com.google.jenkins.plugins.computeengine.WindowsConfiguration;
import com.google.jenkins.plugins.computeengine.client.ClientUtil;
import com.google.jenkins.plugins.computeengine.ssh.GoogleKeyCredential;
import com.google.jenkins.plugins.computeengine.ssh.GoogleKeyPair;
import com.google.jenkins.plugins.computeengine.ssh.GooglePrivateKey;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.RelativePath;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.RandomStringGenerator;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class InstanceConfiguration
implements Describable<InstanceConfiguration> {
    private static final Logger log = Logger.getLogger(InstanceConfiguration.class.getName());
    public static final String GUEST_ATTRIBUTES_METADATA_KEY = "enable-guest-attributes";
    public static final String SSH_METADATA_KEY = "ssh-keys";
    public static final Long DEFAULT_BOOT_DISK_SIZE_GB = 10L;
    public static final Integer DEFAULT_NUM_EXECUTORS = 1;
    public static final Integer DEFAULT_LAUNCH_TIMEOUT_SECONDS = 300;
    public static final Integer DEFAULT_RETENTION_TIME_MINUTES = DEFAULT_LAUNCH_TIMEOUT_SECONDS / 60 + 1;
    public static final String DEFAULT_RUN_AS_USER = "jenkins";
    public static final String METADATA_LINUX_STARTUP_SCRIPT_KEY = "startup-script";
    public static final String METADATA_WINDOWS_STARTUP_SCRIPT_KEY = "windows-startup-script-ps1";
    public static final String NAT_TYPE = "ONE_TO_ONE_NAT";
    public static final String NAT_NAME = "External NAT";
    public static final List<String> KNOWN_IMAGE_PROJECTS = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("centos-cloud");
            this.add("coreos-cloud");
            this.add("cos-cloud");
            this.add("debian-cloud");
            this.add("rhel-cloud");
            this.add("suse-cloud");
            this.add("suse-sap-cloud");
            this.add("ubuntu-os-cloud");
            this.add("windows-cloud");
            this.add("windows-sql-cloud");
        }
    });
    private String description;
    private String namePrefix;
    private String region;
    private String zone;
    private String machineType;
    private String numExecutorsStr;
    private String startupScript;
    private boolean preemptible;
    private String minCpuPlatform;
    private String labels;
    private String runAsUser;
    private String bootDiskType;
    private boolean bootDiskAutoDelete;
    private String bootDiskSourceImageName;
    private String bootDiskSourceImageProject;
    private NetworkConfiguration networkConfiguration;
    private boolean externalAddress;
    private boolean useInternalAddress;
    private boolean ignoreProxy;
    private String networkTags;
    private String serviceAccountEmail;
    private Node.Mode mode;
    private AcceleratorConfiguration acceleratorConfiguration;
    private String retentionTimeMinutesStr;
    private String launchTimeoutSecondsStr;
    private String bootDiskSizeGbStr;
    private boolean oneShot;
    private String template;
    @Nullable
    private WindowsConfiguration windowsConfiguration;
    @Nullable
    private SshConfiguration sshConfiguration;
    private boolean createSnapshot;
    private String remoteFs;
    private String javaExecPath;
    private GoogleKeyCredential sshKeyCredential;
    private Map<String, String> googleLabels;
    private Integer numExecutors;
    private Integer retentionTimeMinutes;
    private Integer launchTimeoutSeconds;
    private Long bootDiskSizeGb;
    private transient Set<LabelAtom> labelSet;
    protected transient ComputeEngineCloud cloud;

    private static List<Metadata.Items> mergeMetadataItems(List<Metadata.Items> winner, List<Metadata.Items> loser) {
        if (loser == null) {
            loser = new ArrayList<Metadata.Items>();
        }
        for (Metadata.Items existing : loser) {
            String existingKey = existing.getKey();
            Metadata.Items duplicate = winner.stream().filter(m -> m.getKey().equals(existingKey)).findFirst().orElse(null);
            if (duplicate == null) {
                winner.add(existing);
                continue;
            }
            if (!existingKey.equals(SSH_METADATA_KEY)) continue;
            duplicate.setValue(duplicate.getValue() + "\n" + existing.getValue());
        }
        return winner;
    }

    @DataBoundConstructor
    public InstanceConfiguration() {
    }

    @DataBoundSetter
    public void setNumExecutorsStr(String numExecutorsStr) {
        this.numExecutors = InstanceConfiguration.intOrDefault(numExecutorsStr, DEFAULT_NUM_EXECUTORS);
        this.numExecutorsStr = this.numExecutors.toString();
    }

    @DataBoundSetter
    public void setLabelString(String labelString) {
        this.labels = Util.fixNull((String)labelString);
        this.readResolve();
    }

    @DataBoundSetter
    public void setNetworkTags(String networkTags) {
        this.networkTags = Util.fixNull((String)networkTags).trim();
    }

    @DataBoundSetter
    public void setRetentionTimeMinutesStr(String retentionTimeMinutesStr) {
        this.retentionTimeMinutes = InstanceConfiguration.intOrDefault(retentionTimeMinutesStr, DEFAULT_RETENTION_TIME_MINUTES);
        this.retentionTimeMinutesStr = this.retentionTimeMinutes.toString();
    }

    @DataBoundSetter
    public void setLaunchTimeoutSecondsStr(String launchTimeoutSecondsStr) {
        this.launchTimeoutSeconds = InstanceConfiguration.intOrDefault(launchTimeoutSecondsStr, DEFAULT_LAUNCH_TIMEOUT_SECONDS);
        this.launchTimeoutSecondsStr = this.launchTimeoutSeconds.toString();
    }

    @DataBoundSetter
    public void setBootDiskSizeGbStr(String bootDiskSizeGbStr) {
        this.bootDiskSizeGb = InstanceConfiguration.longOrDefault(bootDiskSizeGbStr, DEFAULT_BOOT_DISK_SIZE_GB);
        this.bootDiskSizeGbStr = this.bootDiskSizeGb.toString();
    }

    @DataBoundSetter
    public void setOneShot(boolean oneShot) {
        this.oneShot = oneShot;
        this.createSnapshot &= oneShot;
    }

    @DataBoundSetter
    public void setCreateSnapshot(boolean createSnapshot) {
        this.createSnapshot = createSnapshot && this.oneShot;
    }

    public static Integer intOrDefault(String toParse, Integer defaultTo) {
        Integer toReturn;
        try {
            toReturn = Integer.parseInt(toParse);
        }
        catch (NumberFormatException nfe) {
            toReturn = defaultTo;
        }
        return toReturn;
    }

    public static Long longOrDefault(String toParse, Long defaultTo) {
        Long toReturn;
        try {
            toReturn = Long.parseLong(toParse);
        }
        catch (NumberFormatException nfe) {
            toReturn = defaultTo;
        }
        return toReturn;
    }

    private static boolean notNullOrEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    private static String stripSelfLinkPrefix(String s) {
        if (s.contains("https://www.googleapis.com")) {
            return s.substring(s.indexOf("/projects/") + 1);
        }
        return s;
    }

    public Descriptor<InstanceConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    public String getLabelString() {
        return this.labels;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public String getDisplayName() {
        return this.description;
    }

    public int getLaunchTimeoutMillis() {
        return this.launchTimeoutSeconds * 1000;
    }

    public void appendLabels(Map<String, String> labels) {
        if (this.googleLabels == null) {
            this.googleLabels = new HashMap<String, String>();
        }
        this.googleLabels.putAll(labels);
    }

    public void appendLabel(String key, String value) {
        if (this.googleLabels == null) {
            this.googleLabels = new HashMap<String, String>();
        }
        this.googleLabels.put(key, value);
    }

    public ComputeEngineInstance provision() throws IOException {
        try {
            ComputeEngineComputerLauncher launcher;
            Instance instance = this.instance();
            Operation operation = this.cloud.getClient().insertInstance(this.cloud.getProjectId(), Optional.ofNullable(this.template), instance);
            log.info("Sent insert request for instance configuration [" + this.description + "]");
            String targetRemoteFs = this.remoteFs;
            if (this.windowsConfiguration != null) {
                launcher = new ComputeEngineWindowsLauncher(this.cloud.getCloudName(), operation, this.useInternalAddress);
                if (Strings.isNullOrEmpty((String)targetRemoteFs)) {
                    targetRemoteFs = "C:\\";
                }
            } else {
                launcher = new ComputeEngineLinuxLauncher(this.cloud.getCloudName(), operation, this.useInternalAddress);
                if (Strings.isNullOrEmpty((String)targetRemoteFs)) {
                    targetRemoteFs = "/tmp";
                }
            }
            return ComputeEngineInstance.builder().cloud(this.cloud).cloudName(this.cloud.name).name(instance.getName()).zone(instance.getZone()).nodeDescription(instance.getDescription()).sshUser(this.runAsUser).remoteFS(targetRemoteFs).windowsConfig(this.windowsConfiguration).sshConfig(this.sshConfiguration).createSnapshot(this.createSnapshot).oneShot(this.oneShot).ignoreProxy(this.ignoreProxy).numExecutors(this.numExecutors).mode(this.mode).labelString(this.labels).launcher(launcher).retentionStrategy(new ComputeEngineRetentionStrategy(this.retentionTimeMinutes, this.oneShot)).launchTimeout(this.getLaunchTimeoutMillis()).javaExecPath(this.javaExecPath).sshKeyCredential(this.sshKeyCredential).build();
        }
        catch (Descriptor.FormException fe) {
            log.log(Level.WARNING, "Error provisioning instance: " + fe.getMessage(), fe);
            return null;
        }
    }

    protected Object readResolve() {
        this.labelSet = Label.parse((String)this.labels);
        return this;
    }

    public Instance instance() throws IOException {
        Instance instance = new Instance();
        instance.setName(this.uniqueName());
        instance.setDescription(this.description);
        instance.setZone(com.google.cloud.graphite.platforms.plugin.client.util.ClientUtil.nameFromSelfLink((String)this.zone));
        instance.setMetadata(this.newMetadata());
        if (this.windowsConfiguration == null) {
            if (this.sshConfiguration != null) {
                log.info("User selected to use a custom ssh private key");
                this.sshKeyCredential = this.configureSSHPrivateKey(this.sshConfiguration.getCustomPrivateKeyCredentialsId(), this.runAsUser);
            } else {
                log.info("User selected to use an autogenerated ssh key pair");
                this.sshKeyCredential = this.configureSSHKeyPair(instance, this.runAsUser);
            }
        }
        if (StringUtils.isNotEmpty((String)this.template)) {
            InstanceTemplate instanceTemplate = this.cloud.getClient().getTemplate(com.google.cloud.graphite.platforms.plugin.client.util.ClientUtil.nameFromSelfLink((String)this.cloud.getProjectId()), com.google.cloud.graphite.platforms.plugin.client.util.ClientUtil.nameFromSelfLink((String)this.template));
            if (instanceTemplate.getProperties() != null && instanceTemplate.getProperties().getMetadata() != null && instanceTemplate.getProperties().getMetadata().getItems() != null) {
                List instanceTemplateItems = instanceTemplate.getProperties().getMetadata().getItems();
                List instanceItems = instance.getMetadata().getItems();
                instance.getMetadata().setItems(InstanceConfiguration.mergeMetadataItems(instanceItems, instanceTemplateItems));
            }
            HashMap<String, String> mergedLabels = new HashMap<String, String>(this.googleLabels);
            if (instanceTemplate.getProperties().getLabels() != null) {
                Map templateLabels = instanceTemplate.getProperties().getLabels();
                mergedLabels.putAll(templateLabels);
            }
            instance.setLabels(mergedLabels);
        } else {
            this.configureStartupScript(instance);
            instance.setLabels(this.googleLabels);
            instance.setMachineType(InstanceConfiguration.stripSelfLinkPrefix(this.machineType));
            instance.setTags(this.tags());
            instance.setScheduling(this.scheduling());
            instance.setDisks(this.disks());
            instance.setGuestAccelerators(this.accelerators());
            instance.setNetworkInterfaces(this.networkInterfaces());
            instance.setServiceAccounts(this.serviceAccounts());
            if (InstanceConfiguration.notNullOrEmpty(this.minCpuPlatform)) {
                instance.setMinCpuPlatform(this.minCpuPlatform);
            }
        }
        return instance;
    }

    private String uniqueName() {
        char[][] pairs = new char[][]{{'a', 'z'}, {'0', '9'}};
        RandomStringGenerator generator = new RandomStringGenerator.Builder().withinRange((char[][])pairs).build();
        String suffix = generator.generate(6);
        Object prefix = this.namePrefix;
        if (!((String)prefix).endsWith("-")) {
            prefix = (String)prefix + "-";
        }
        return (String)prefix + suffix;
    }

    private Metadata newMetadata() {
        Metadata metadata = new Metadata();
        metadata.setItems(new ArrayList());
        metadata.getItems().add(new Metadata.Items().setKey(GUEST_ATTRIBUTES_METADATA_KEY).setValue("TRUE"));
        return metadata;
    }

    private GoogleKeyPair configureSSHKeyPair(Instance instance, String sshUser) {
        GoogleKeyPair sshKeyPair = GoogleKeyPair.generate(sshUser);
        instance.getMetadata().getItems().add(new Metadata.Items().setKey(SSH_METADATA_KEY).setValue(sshKeyPair.getPublicKey()));
        return sshKeyPair;
    }

    private GooglePrivateKey configureSSHPrivateKey(String credentialId, String sshUser) {
        GooglePrivateKey sshPrivateKey = GooglePrivateKey.generate(credentialId, sshUser);
        return sshPrivateKey;
    }

    private void configureStartupScript(Instance instance) {
        if (InstanceConfiguration.notNullOrEmpty(this.startupScript)) {
            List items = instance.getMetadata().getItems();
            if (this.windowsConfiguration != null) {
                items.add(new Metadata.Items().setKey(METADATA_WINDOWS_STARTUP_SCRIPT_KEY).setValue(this.startupScript));
            } else {
                items.add(new Metadata.Items().setKey(METADATA_LINUX_STARTUP_SCRIPT_KEY).setValue(this.startupScript));
            }
        }
    }

    private Tags tags() {
        if (InstanceConfiguration.notNullOrEmpty(this.networkTags)) {
            Tags tags = new Tags();
            tags.setItems(Arrays.asList(this.networkTags.split(" ")));
            return tags;
        }
        return null;
    }

    private Scheduling scheduling() {
        Scheduling scheduling = new Scheduling();
        scheduling.setPreemptible(Boolean.valueOf(this.preemptible));
        return scheduling;
    }

    private List<AttachedDisk> disks() {
        AttachedDisk boot = new AttachedDisk();
        boot.setBoot(Boolean.valueOf(true));
        boot.setAutoDelete(Boolean.valueOf(this.bootDiskAutoDelete));
        boot.setInitializeParams(new AttachedDiskInitializeParams().setDiskSizeGb(this.bootDiskSizeGb).setDiskType(this.bootDiskType).setSourceImage(this.bootDiskSourceImageName));
        ArrayList<AttachedDisk> disks = new ArrayList<AttachedDisk>();
        disks.add(boot);
        return disks;
    }

    private List<AcceleratorConfig> accelerators() {
        if (this.acceleratorConfiguration != null && InstanceConfiguration.notNullOrEmpty(this.acceleratorConfiguration.getGpuCount()) && InstanceConfiguration.notNullOrEmpty(this.acceleratorConfiguration.getGpuType())) {
            ArrayList<AcceleratorConfig> accelerators = new ArrayList<AcceleratorConfig>();
            accelerators.add(new AcceleratorConfig().setAcceleratorType(this.acceleratorConfiguration.getGpuType()).setAcceleratorCount(this.acceleratorConfiguration.gpuCount()));
            return accelerators;
        }
        return null;
    }

    private List<NetworkInterface> networkInterfaces() {
        ArrayList<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
        ArrayList<AccessConfig> accessConfigs = new ArrayList<AccessConfig>();
        if (this.externalAddress) {
            accessConfigs.add(new AccessConfig().setType(NAT_TYPE).setName(NAT_NAME));
        }
        NetworkInterface nic = new NetworkInterface().setAccessConfigs(accessConfigs);
        if (!this.networkConfiguration.getSubnetwork().equals("default")) {
            nic.setSubnetwork(InstanceConfiguration.stripSelfLinkPrefix(this.networkConfiguration.getSubnetwork()));
        }
        networkInterfaces.add(nic);
        return networkInterfaces;
    }

    private List<ServiceAccount> serviceAccounts() {
        if (InstanceConfiguration.notNullOrEmpty(this.serviceAccountEmail)) {
            ArrayList<ServiceAccount> serviceAccounts = new ArrayList<ServiceAccount>();
            serviceAccounts.add(new ServiceAccount().setEmail(this.serviceAccountEmail).setScopes(Arrays.asList("https://www.googleapis.com/auth/cloud-platform")));
            return serviceAccounts;
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDescription() {
        return this.description;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getRegion() {
        return this.region;
    }

    public String getZone() {
        return this.zone;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getNumExecutorsStr() {
        return this.numExecutorsStr;
    }

    public String getStartupScript() {
        return this.startupScript;
    }

    public boolean isPreemptible() {
        return this.preemptible;
    }

    public String getMinCpuPlatform() {
        return this.minCpuPlatform;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getRunAsUser() {
        return this.runAsUser;
    }

    public String getBootDiskType() {
        return this.bootDiskType;
    }

    public boolean isBootDiskAutoDelete() {
        return this.bootDiskAutoDelete;
    }

    public String getBootDiskSourceImageName() {
        return this.bootDiskSourceImageName;
    }

    public String getBootDiskSourceImageProject() {
        return this.bootDiskSourceImageProject;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public boolean isExternalAddress() {
        return this.externalAddress;
    }

    public boolean isUseInternalAddress() {
        return this.useInternalAddress;
    }

    public boolean isIgnoreProxy() {
        return this.ignoreProxy;
    }

    public String getNetworkTags() {
        return this.networkTags;
    }

    public String getServiceAccountEmail() {
        return this.serviceAccountEmail;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public AcceleratorConfiguration getAcceleratorConfiguration() {
        return this.acceleratorConfiguration;
    }

    public String getRetentionTimeMinutesStr() {
        return this.retentionTimeMinutesStr;
    }

    public String getLaunchTimeoutSecondsStr() {
        return this.launchTimeoutSecondsStr;
    }

    public String getBootDiskSizeGbStr() {
        return this.bootDiskSizeGbStr;
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    public String getTemplate() {
        return this.template;
    }

    @Nullable
    public WindowsConfiguration getWindowsConfiguration() {
        return this.windowsConfiguration;
    }

    @Nullable
    public SshConfiguration getSshConfiguration() {
        return this.sshConfiguration;
    }

    public boolean isCreateSnapshot() {
        return this.createSnapshot;
    }

    public String getRemoteFs() {
        return this.remoteFs;
    }

    public String getJavaExecPath() {
        return this.javaExecPath;
    }

    public GoogleKeyCredential getSshKeyCredential() {
        return this.sshKeyCredential;
    }

    public Map<String, String> getGoogleLabels() {
        return this.googleLabels;
    }

    public Integer getNumExecutors() {
        return this.numExecutors;
    }

    public Integer getRetentionTimeMinutes() {
        return this.retentionTimeMinutes;
    }

    public Integer getLaunchTimeoutSeconds() {
        return this.launchTimeoutSeconds;
    }

    public Long getBootDiskSizeGb() {
        return this.bootDiskSizeGb;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = description;
    }

    @DataBoundSetter
    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    @DataBoundSetter
    public void setRegion(String region) {
        this.region = region;
    }

    @DataBoundSetter
    public void setZone(String zone) {
        this.zone = zone;
    }

    @DataBoundSetter
    public void setMachineType(String machineType) {
        this.machineType = machineType;
    }

    @DataBoundSetter
    public void setStartupScript(String startupScript) {
        this.startupScript = startupScript;
    }

    @DataBoundSetter
    public void setPreemptible(boolean preemptible) {
        this.preemptible = preemptible;
    }

    @DataBoundSetter
    public void setMinCpuPlatform(String minCpuPlatform) {
        this.minCpuPlatform = minCpuPlatform;
    }

    @DataBoundSetter
    public void setLabels(String labels) {
        this.labels = labels;
    }

    @DataBoundSetter
    public void setRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
    }

    @DataBoundSetter
    public void setBootDiskType(String bootDiskType) {
        this.bootDiskType = bootDiskType;
    }

    @DataBoundSetter
    public void setBootDiskAutoDelete(boolean bootDiskAutoDelete) {
        this.bootDiskAutoDelete = bootDiskAutoDelete;
    }

    @DataBoundSetter
    public void setBootDiskSourceImageName(String bootDiskSourceImageName) {
        this.bootDiskSourceImageName = bootDiskSourceImageName;
    }

    @DataBoundSetter
    public void setBootDiskSourceImageProject(String bootDiskSourceImageProject) {
        this.bootDiskSourceImageProject = bootDiskSourceImageProject;
    }

    @DataBoundSetter
    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    @DataBoundSetter
    public void setExternalAddress(boolean externalAddress) {
        this.externalAddress = externalAddress;
    }

    @DataBoundSetter
    public void setUseInternalAddress(boolean useInternalAddress) {
        this.useInternalAddress = useInternalAddress;
    }

    @DataBoundSetter
    public void setIgnoreProxy(boolean ignoreProxy) {
        this.ignoreProxy = ignoreProxy;
    }

    @DataBoundSetter
    public void setServiceAccountEmail(String serviceAccountEmail) {
        this.serviceAccountEmail = serviceAccountEmail;
    }

    @DataBoundSetter
    public void setMode(Node.Mode mode) {
        this.mode = mode;
    }

    @DataBoundSetter
    public void setAcceleratorConfiguration(AcceleratorConfiguration acceleratorConfiguration) {
        this.acceleratorConfiguration = acceleratorConfiguration;
    }

    @DataBoundSetter
    public void setTemplate(String template) {
        this.template = template;
    }

    @DataBoundSetter
    public void setWindowsConfiguration(@Nullable WindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
    }

    @DataBoundSetter
    public void setSshConfiguration(@Nullable SshConfiguration sshConfiguration) {
        this.sshConfiguration = sshConfiguration;
    }

    @DataBoundSetter
    public void setRemoteFs(String remoteFs) {
        this.remoteFs = remoteFs;
    }

    @DataBoundSetter
    public void setJavaExecPath(String javaExecPath) {
        this.javaExecPath = javaExecPath;
    }

    @DataBoundSetter
    public void setSshKeyCredential(GoogleKeyCredential sshKeyCredential) {
        this.sshKeyCredential = sshKeyCredential;
    }

    @DataBoundSetter
    public void setGoogleLabels(Map<String, String> googleLabels) {
        this.googleLabels = googleLabels;
    }

    @DataBoundSetter
    public void setNumExecutors(Integer numExecutors) {
        this.numExecutors = numExecutors;
    }

    @DataBoundSetter
    public void setRetentionTimeMinutes(Integer retentionTimeMinutes) {
        this.retentionTimeMinutes = retentionTimeMinutes;
    }

    @DataBoundSetter
    public void setLaunchTimeoutSeconds(Integer launchTimeoutSeconds) {
        this.launchTimeoutSeconds = launchTimeoutSeconds;
    }

    @DataBoundSetter
    public void setBootDiskSizeGb(Long bootDiskSizeGb) {
        this.bootDiskSizeGb = bootDiskSizeGb;
    }

    @DataBoundSetter
    public void setLabelSet(Set<LabelAtom> labelSet) {
        this.labelSet = labelSet;
    }

    public InstanceConfiguration(String description, String namePrefix, String region, String zone, String machineType, String numExecutorsStr, String startupScript, boolean preemptible, String minCpuPlatform, String labels, String runAsUser, String bootDiskType, boolean bootDiskAutoDelete, String bootDiskSourceImageName, String bootDiskSourceImageProject, NetworkConfiguration networkConfiguration, boolean externalAddress, boolean useInternalAddress, boolean ignoreProxy, String networkTags, String serviceAccountEmail, Node.Mode mode, AcceleratorConfiguration acceleratorConfiguration, String retentionTimeMinutesStr, String launchTimeoutSecondsStr, String bootDiskSizeGbStr, boolean oneShot, String template, @Nullable WindowsConfiguration windowsConfiguration, @Nullable SshConfiguration sshConfiguration, boolean createSnapshot, String remoteFs, String javaExecPath, GoogleKeyCredential sshKeyCredential, Map<String, String> googleLabels, Integer numExecutors, Integer retentionTimeMinutes, Integer launchTimeoutSeconds, Long bootDiskSizeGb, Set<LabelAtom> labelSet, ComputeEngineCloud cloud) {
        this.description = description;
        this.namePrefix = namePrefix;
        this.region = region;
        this.zone = zone;
        this.machineType = machineType;
        this.numExecutorsStr = numExecutorsStr;
        this.startupScript = startupScript;
        this.preemptible = preemptible;
        this.minCpuPlatform = minCpuPlatform;
        this.labels = labels;
        this.runAsUser = runAsUser;
        this.bootDiskType = bootDiskType;
        this.bootDiskAutoDelete = bootDiskAutoDelete;
        this.bootDiskSourceImageName = bootDiskSourceImageName;
        this.bootDiskSourceImageProject = bootDiskSourceImageProject;
        this.networkConfiguration = networkConfiguration;
        this.externalAddress = externalAddress;
        this.useInternalAddress = useInternalAddress;
        this.ignoreProxy = ignoreProxy;
        this.networkTags = networkTags;
        this.serviceAccountEmail = serviceAccountEmail;
        this.mode = mode;
        this.acceleratorConfiguration = acceleratorConfiguration;
        this.retentionTimeMinutesStr = retentionTimeMinutesStr;
        this.launchTimeoutSecondsStr = launchTimeoutSecondsStr;
        this.bootDiskSizeGbStr = bootDiskSizeGbStr;
        this.oneShot = oneShot;
        this.template = template;
        this.windowsConfiguration = windowsConfiguration;
        this.sshConfiguration = sshConfiguration;
        this.createSnapshot = createSnapshot;
        this.remoteFs = remoteFs;
        this.javaExecPath = javaExecPath;
        this.sshKeyCredential = sshKeyCredential;
        this.googleLabels = googleLabels;
        this.numExecutors = numExecutors;
        this.retentionTimeMinutes = retentionTimeMinutes;
        this.launchTimeoutSeconds = launchTimeoutSeconds;
        this.bootDiskSizeGb = bootDiskSizeGb;
        this.labelSet = labelSet;
        this.cloud = cloud;
    }

    protected ComputeEngineCloud getCloud() {
        return this.cloud;
    }

    protected void setCloud(ComputeEngineCloud cloud) {
        this.cloud = cloud;
    }

    public static class Builder {
        private String description;
        private String namePrefix;
        private String region;
        private String zone;
        private String machineType;
        private String numExecutorsStr;
        private String startupScript;
        private boolean preemptible;
        private String minCpuPlatform;
        private String labels;
        private String runAsUser;
        private String bootDiskType;
        private boolean bootDiskAutoDelete;
        private String bootDiskSourceImageName;
        private String bootDiskSourceImageProject;
        private NetworkConfiguration networkConfiguration;
        private boolean externalAddress;
        private boolean useInternalAddress;
        private boolean ignoreProxy;
        private String networkTags;
        private String serviceAccountEmail;
        private Node.Mode mode;
        private AcceleratorConfiguration acceleratorConfiguration;
        private String retentionTimeMinutesStr;
        private String launchTimeoutSecondsStr;
        private String bootDiskSizeGbStr;
        private boolean oneShot;
        private String template;
        private WindowsConfiguration windowsConfiguration;
        private SshConfiguration sshConfiguration;
        private boolean createSnapshot;
        private String remoteFs;
        private String javaExecPath;
        private GoogleKeyCredential sshKeyCredential;
        private Map<String, String> googleLabels;
        private Integer numExecutors;
        private Integer retentionTimeMinutes;
        private Integer launchTimeoutSeconds;
        private Long bootDiskSizeGb;
        private Set<LabelAtom> labelSet;
        private ComputeEngineCloud cloud;

        public InstanceConfiguration build() {
            InstanceConfiguration instanceConfiguration = new InstanceConfiguration();
            instanceConfiguration.setDescription(this.description);
            instanceConfiguration.setNamePrefix(this.namePrefix);
            instanceConfiguration.setRegion(this.region);
            instanceConfiguration.setZone(this.zone);
            instanceConfiguration.setMachineType(this.machineType);
            instanceConfiguration.setNumExecutorsStr(this.numExecutorsStr);
            instanceConfiguration.setStartupScript(this.startupScript);
            instanceConfiguration.setPreemptible(this.preemptible);
            instanceConfiguration.setMinCpuPlatform(this.minCpuPlatform);
            instanceConfiguration.setLabelString(this.labels);
            instanceConfiguration.setRunAsUser(this.runAsUser);
            instanceConfiguration.setWindowsConfiguration(this.windowsConfiguration);
            instanceConfiguration.setSshConfiguration(this.sshConfiguration);
            instanceConfiguration.setBootDiskType(this.bootDiskType);
            instanceConfiguration.setBootDiskAutoDelete(this.bootDiskAutoDelete);
            instanceConfiguration.setBootDiskSourceImageName(this.bootDiskSourceImageName);
            instanceConfiguration.setBootDiskSourceImageProject(this.bootDiskSourceImageProject);
            instanceConfiguration.setNetworkConfiguration(this.networkConfiguration);
            instanceConfiguration.setExternalAddress(this.externalAddress);
            instanceConfiguration.setUseInternalAddress(this.useInternalAddress);
            instanceConfiguration.setIgnoreProxy(this.ignoreProxy);
            instanceConfiguration.setNetworkTags(this.networkTags);
            instanceConfiguration.setServiceAccountEmail(this.serviceAccountEmail);
            instanceConfiguration.setMode(this.mode);
            instanceConfiguration.setAcceleratorConfiguration(this.acceleratorConfiguration);
            instanceConfiguration.setRetentionTimeMinutesStr(this.retentionTimeMinutesStr);
            instanceConfiguration.setLaunchTimeoutSecondsStr(this.launchTimeoutSecondsStr);
            instanceConfiguration.setBootDiskSizeGbStr(this.bootDiskSizeGbStr);
            instanceConfiguration.setOneShot(this.oneShot);
            instanceConfiguration.setTemplate(this.template);
            instanceConfiguration.setCreateSnapshot(this.createSnapshot);
            instanceConfiguration.setRemoteFs(this.remoteFs);
            instanceConfiguration.setJavaExecPath(this.javaExecPath);
            instanceConfiguration.setCloud(this.cloud);
            if (this.googleLabels != null) {
                instanceConfiguration.appendLabels(this.googleLabels);
            }
            return instanceConfiguration;
        }

        @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="for Lombok")
        private Builder numExecutors(Integer numExecutors) {
            throw new NotImplementedException();
        }

        private Builder retentionTimeMinutes(Integer retentionTimeMinutes) {
            throw new NotImplementedException();
        }

        private Builder launchTimeoutSeconds(Integer launchTimeoutSeconds) {
            throw new NotImplementedException();
        }

        private Builder bootDiskSizeGb(Long bootDiskSizeGb) {
            throw new NotImplementedException();
        }

        private Builder labelSet(Set<LabelAtom> labelSet) {
            throw new NotImplementedException();
        }

        Builder() {
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder zone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder machineType(String machineType) {
            this.machineType = machineType;
            return this;
        }

        public Builder numExecutorsStr(String numExecutorsStr) {
            this.numExecutorsStr = numExecutorsStr;
            return this;
        }

        public Builder startupScript(String startupScript) {
            this.startupScript = startupScript;
            return this;
        }

        public Builder preemptible(boolean preemptible) {
            this.preemptible = preemptible;
            return this;
        }

        public Builder minCpuPlatform(String minCpuPlatform) {
            this.minCpuPlatform = minCpuPlatform;
            return this;
        }

        public Builder labels(String labels) {
            this.labels = labels;
            return this;
        }

        public Builder runAsUser(String runAsUser) {
            this.runAsUser = runAsUser;
            return this;
        }

        public Builder bootDiskType(String bootDiskType) {
            this.bootDiskType = bootDiskType;
            return this;
        }

        public Builder bootDiskAutoDelete(boolean bootDiskAutoDelete) {
            this.bootDiskAutoDelete = bootDiskAutoDelete;
            return this;
        }

        public Builder bootDiskSourceImageName(String bootDiskSourceImageName) {
            this.bootDiskSourceImageName = bootDiskSourceImageName;
            return this;
        }

        public Builder bootDiskSourceImageProject(String bootDiskSourceImageProject) {
            this.bootDiskSourceImageProject = bootDiskSourceImageProject;
            return this;
        }

        public Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public Builder externalAddress(boolean externalAddress) {
            this.externalAddress = externalAddress;
            return this;
        }

        public Builder useInternalAddress(boolean useInternalAddress) {
            this.useInternalAddress = useInternalAddress;
            return this;
        }

        public Builder ignoreProxy(boolean ignoreProxy) {
            this.ignoreProxy = ignoreProxy;
            return this;
        }

        public Builder networkTags(String networkTags) {
            this.networkTags = networkTags;
            return this;
        }

        public Builder serviceAccountEmail(String serviceAccountEmail) {
            this.serviceAccountEmail = serviceAccountEmail;
            return this;
        }

        public Builder mode(Node.Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder acceleratorConfiguration(AcceleratorConfiguration acceleratorConfiguration) {
            this.acceleratorConfiguration = acceleratorConfiguration;
            return this;
        }

        public Builder retentionTimeMinutesStr(String retentionTimeMinutesStr) {
            this.retentionTimeMinutesStr = retentionTimeMinutesStr;
            return this;
        }

        public Builder launchTimeoutSecondsStr(String launchTimeoutSecondsStr) {
            this.launchTimeoutSecondsStr = launchTimeoutSecondsStr;
            return this;
        }

        public Builder bootDiskSizeGbStr(String bootDiskSizeGbStr) {
            this.bootDiskSizeGbStr = bootDiskSizeGbStr;
            return this;
        }

        public Builder oneShot(boolean oneShot) {
            this.oneShot = oneShot;
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public Builder windowsConfiguration(@Nullable WindowsConfiguration windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        public Builder sshConfiguration(@Nullable SshConfiguration sshConfiguration) {
            this.sshConfiguration = sshConfiguration;
            return this;
        }

        public Builder createSnapshot(boolean createSnapshot) {
            this.createSnapshot = createSnapshot;
            return this;
        }

        public Builder remoteFs(String remoteFs) {
            this.remoteFs = remoteFs;
            return this;
        }

        public Builder javaExecPath(String javaExecPath) {
            this.javaExecPath = javaExecPath;
            return this;
        }

        public Builder sshKeyCredential(GoogleKeyCredential sshKeyCredential) {
            this.sshKeyCredential = sshKeyCredential;
            return this;
        }

        public Builder googleLabels(Map<String, String> googleLabels) {
            this.googleLabels = googleLabels;
            return this;
        }

        public Builder cloud(ComputeEngineCloud cloud) {
            this.cloud = cloud;
            return this;
        }

        public InstanceConfiguration notbuild() {
            return new InstanceConfiguration(this.description, this.namePrefix, this.region, this.zone, this.machineType, this.numExecutorsStr, this.startupScript, this.preemptible, this.minCpuPlatform, this.labels, this.runAsUser, this.bootDiskType, this.bootDiskAutoDelete, this.bootDiskSourceImageName, this.bootDiskSourceImageProject, this.networkConfiguration, this.externalAddress, this.useInternalAddress, this.ignoreProxy, this.networkTags, this.serviceAccountEmail, this.mode, this.acceleratorConfiguration, this.retentionTimeMinutesStr, this.launchTimeoutSecondsStr, this.bootDiskSizeGbStr, this.oneShot, this.template, this.windowsConfiguration, this.sshConfiguration, this.createSnapshot, this.remoteFs, this.javaExecPath, this.sshKeyCredential, this.googleLabels, this.numExecutors, this.retentionTimeMinutes, this.launchTimeoutSeconds, this.bootDiskSizeGb, this.labelSet, this.cloud);
        }

        public String toString() {
            return "InstanceConfiguration.Builder(description=" + this.description + ", namePrefix=" + this.namePrefix + ", region=" + this.region + ", zone=" + this.zone + ", machineType=" + this.machineType + ", numExecutorsStr=" + this.numExecutorsStr + ", startupScript=" + this.startupScript + ", preemptible=" + this.preemptible + ", minCpuPlatform=" + this.minCpuPlatform + ", labels=" + this.labels + ", runAsUser=" + this.runAsUser + ", bootDiskType=" + this.bootDiskType + ", bootDiskAutoDelete=" + this.bootDiskAutoDelete + ", bootDiskSourceImageName=" + this.bootDiskSourceImageName + ", bootDiskSourceImageProject=" + this.bootDiskSourceImageProject + ", networkConfiguration=" + this.networkConfiguration + ", externalAddress=" + this.externalAddress + ", useInternalAddress=" + this.useInternalAddress + ", ignoreProxy=" + this.ignoreProxy + ", networkTags=" + this.networkTags + ", serviceAccountEmail=" + this.serviceAccountEmail + ", mode=" + this.mode + ", acceleratorConfiguration=" + this.acceleratorConfiguration + ", retentionTimeMinutesStr=" + this.retentionTimeMinutesStr + ", launchTimeoutSecondsStr=" + this.launchTimeoutSecondsStr + ", bootDiskSizeGbStr=" + this.bootDiskSizeGbStr + ", oneShot=" + this.oneShot + ", template=" + this.template + ", windowsConfiguration=" + this.windowsConfiguration + ", sshConfiguration=" + this.sshConfiguration + ", createSnapshot=" + this.createSnapshot + ", remoteFs=" + this.remoteFs + ", javaExecPath=" + this.javaExecPath + ", sshKeyCredential=" + this.sshKeyCredential + ", googleLabels=" + this.googleLabels + ", numExecutors=" + this.numExecutors + ", retentionTimeMinutes=" + this.retentionTimeMinutes + ", launchTimeoutSeconds=" + this.launchTimeoutSeconds + ", bootDiskSizeGb=" + this.bootDiskSizeGb + ", labelSet=" + this.labelSet + ", cloud=" + this.cloud + ")";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<InstanceConfiguration> {
        private static ComputeClient computeClient;

        public static void setComputeClient(ComputeClient client) {
            computeClient = client;
        }

        public static String defaultRetentionTimeMinutes() {
            return DEFAULT_RETENTION_TIME_MINUTES.toString();
        }

        public static String defaultLaunchTimeoutSeconds() {
            return DEFAULT_LAUNCH_TIMEOUT_SECONDS.toString();
        }

        public static String defaultBootDiskSizeGb() {
            return DEFAULT_BOOT_DISK_SIZE_GB.toString();
        }

        public static String defaultBootDiskAutoDelete() {
            return "true";
        }

        public static String defaultRunAsUser() {
            return InstanceConfiguration.DEFAULT_RUN_AS_USER;
        }

        public static WindowsConfiguration defaultWindowsConfiguration() {
            return WindowsConfiguration.builder().passwordCredentialsId("").privateKeyCredentialsId("").build();
        }

        public static SshConfiguration defaultSshConfiguration() {
            return SshConfiguration.builder().customPrivateKeyCredentialsId("").build();
        }

        public static NetworkConfiguration defaultNetworkConfiguration() {
            return new AutofilledNetworkConfiguration();
        }

        private static ComputeClient computeClient(Jenkins context, String credentialsId) throws IOException {
            if (computeClient != null) {
                return computeClient;
            }
            ClientFactory clientFactory = ClientUtil.getClientFactory((ItemGroup)context, credentialsId);
            return clientFactory.computeClient();
        }

        public String getHelpFile(String fieldName) {
            Descriptor d;
            String p = super.getHelpFile(fieldName);
            if (p == null && (d = Jenkins.get().getDescriptor(ComputeEngineInstance.class)) != null) {
                p = d.getHelpFile(fieldName);
            }
            return p;
        }

        public List<NetworkConfiguration.NetworkConfigurationDescriptor> getNetworkConfigurationDescriptors() {
            DescriptorExtensionList d = Jenkins.get().getDescriptorList(NetworkConfiguration.class);
            Iterator it = d.iterator();
            while (it.hasNext()) {
                NetworkConfiguration.NetworkConfigurationDescriptor o = (NetworkConfiguration.NetworkConfigurationDescriptor)((Object)it.next());
                if (!o.clazz.getName().equals("NetworkConfiguration")) continue;
                it.remove();
            }
            return d;
        }

        public FormValidation doCheckNetworkTags(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.ok();
            }
            String re = "[a-z]([-a-z0-9]*[a-z0-9])?";
            for (String tag : value.split(" ")) {
                if (tag.matches(re)) continue;
                return FormValidation.error((String)("Tags must be space-delimited and each tag must match regex" + re));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNamePrefix(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"A prefix is required");
            }
            String re = "[a-z]([-a-z0-9]*[a-z0-9])?";
            if (!value.matches(re)) {
                return FormValidation.error((String)("Prefix must match regex " + re));
            }
            Integer maxLen = 50;
            if (value.length() > maxLen) {
                return FormValidation.error((String)("Maximum length is " + maxLen));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDescription(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"A description is required");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillRegionItems(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") @RelativePath(value="..") String projectId, @QueryParameter(value="credentialsId") @RelativePath(value="..") String credentialsId) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            ListBoxModel items = new ListBoxModel();
            items.add("");
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                ImmutableList regions = compute.listRegions(projectId);
                for (Region r : regions) {
                    items.add(r.getName(), r.getSelfLink());
                }
                return items;
            }
            catch (IOException ioe) {
                items.clear();
                items.add("Error retrieving regions");
                return items;
            }
        }

        public ListBoxModel doFillTemplateItems(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") @RelativePath(value="..") String projectId, @QueryParameter(value="credentialsId") @RelativePath(value="..") String credentialsId) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            ListBoxModel items = new ListBoxModel();
            items.add("");
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                ImmutableList instanceTemplates = compute.listTemplates(projectId);
                for (InstanceTemplate instanceTemplate : instanceTemplates) {
                    items.add(instanceTemplate.getName(), instanceTemplate.getSelfLink());
                }
                return items;
            }
            catch (IOException ioe) {
                items.clear();
                items.add("Error retrieving instanceTemplates");
                return items;
            }
        }

        public FormValidation doCheckRegion(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Please select a region...");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillZoneItems(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") @RelativePath(value="..") String projectId, @QueryParameter(value="region") String region, @QueryParameter(value="credentialsId") @RelativePath(value="..") String credentialsId) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            ListBoxModel items = new ListBoxModel();
            items.add("");
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                ImmutableList zones = compute.listZones(projectId, region);
                for (Zone z : zones) {
                    items.add(z.getName(), z.getSelfLink());
                }
                return items;
            }
            catch (IOException ioe) {
                items.clear();
                items.add("Error retrieving zones");
                return items;
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        public FormValidation doCheckZone(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Please select a zone...");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillMachineTypeItems(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") @RelativePath(value="..") String projectId, @QueryParameter(value="zone") String zone, @QueryParameter(value="credentialsId") @RelativePath(value="..") String credentialsId) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            ListBoxModel items = new ListBoxModel();
            items.add("");
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                ImmutableList machineTypes = compute.listMachineTypes(projectId, zone);
                for (MachineType m : machineTypes) {
                    items.add(m.getName(), m.getSelfLink());
                }
                return items;
            }
            catch (IOException ioe) {
                items.clear();
                items.add("Error retrieving machine types");
                return items;
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        public FormValidation doCheckMachineType(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Please select a machine type...");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillMinCpuPlatformItems(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") @RelativePath(value="..") String projectId, @QueryParameter(value="zone") String zone, @QueryParameter(value="credentialsId") @RelativePath(value="..") String credentialsId) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            ListBoxModel items = new ListBoxModel();
            items.add("");
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                ImmutableList cpuPlatforms = compute.listCpuPlatforms(projectId, zone);
                for (String cpuPlatform : cpuPlatforms) {
                    items.add(cpuPlatform);
                }
                return items;
            }
            catch (IOException ioe) {
                items.clear();
                items.add("Error retrieving cpu Platforms");
                return items;
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        public ListBoxModel doFillBootDiskTypeItems(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") @RelativePath(value="..") String projectId, @QueryParameter(value="zone") String zone, @QueryParameter(value="credentialsId") @RelativePath(value="..") String credentialsId) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            ListBoxModel items = new ListBoxModel();
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                ImmutableList diskTypes = compute.listBootDiskTypes(projectId, zone);
                for (DiskType dt : diskTypes) {
                    items.add(dt.getName(), dt.getSelfLink());
                }
                return items;
            }
            catch (IOException ioe) {
                items.clear();
                items.add("Error retrieving disk types");
                return items;
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        public ListBoxModel doFillBootDiskSourceImageProjectItems(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") @RelativePath(value="..") String projectId) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            ListBoxModel items = new ListBoxModel();
            items.add("");
            items.add(projectId);
            for (String v : KNOWN_IMAGE_PROJECTS) {
                items.add(v);
            }
            return items;
        }

        public FormValidation doCheckBootDiskSourceImageProject(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.warning((String)"Please select source image project...");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillBootDiskSourceImageNameItems(@AncestorInPath Jenkins context, @QueryParameter(value="bootDiskSourceImageProject") String projectId, @QueryParameter(value="credentialsId") @RelativePath(value="..") String credentialsId) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            ListBoxModel items = new ListBoxModel();
            items.add("");
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                ImmutableList images = compute.listImages(projectId);
                for (Image i : images) {
                    items.add(i.getName(), i.getSelfLink());
                }
            }
            catch (IOException ioe) {
                items.clear();
                items.add("Error retrieving images for project");
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
            return items;
        }

        public FormValidation doCheckBootDiskSourceImageName(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.warning((String)"Please select source image...");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBootDiskSizeGbStr(@AncestorInPath Jenkins context, @QueryParameter String value, @QueryParameter(value="bootDiskSourceImageProject") String projectId, @QueryParameter(value="bootDiskSourceImageName") String imageName, @QueryParameter(value="credentialsId") @RelativePath(value="..") String credentialsId) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            if (Strings.isNullOrEmpty((String)credentialsId) || Strings.isNullOrEmpty((String)projectId) || Strings.isNullOrEmpty((String)imageName)) {
                return FormValidation.ok();
            }
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                Image i = compute.getImage(com.google.cloud.graphite.platforms.plugin.client.util.ClientUtil.nameFromSelfLink((String)projectId), com.google.cloud.graphite.platforms.plugin.client.util.ClientUtil.nameFromSelfLink((String)imageName));
                if (i == null) {
                    return FormValidation.error((String)("Could not find image " + imageName));
                }
                Long bootDiskSizeGb = Long.parseLong(value);
                if (bootDiskSizeGb < i.getDiskSizeGb()) {
                    return FormValidation.error((String)String.format("The disk image you have chosen requires a minimum of %dGB. Please increase boot disk size to accommodate.", i.getDiskSizeGb()));
                }
            }
            catch (IOException ioe) {
                return FormValidation.error((Throwable)ioe, (String)"Error validating boot disk size");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckLabelString(@QueryParameter String value, @QueryParameter Node.Mode mode) {
            if (mode == Node.Mode.EXCLUSIVE && (value == null || value.trim().isEmpty())) {
                return FormValidation.warning((String)"You may want to assign labels to this node; it's marked to only run jobs that are exclusively tied to itself or a label.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCreateSnapshot(@AncestorInPath Jenkins context, @QueryParameter boolean value, @QueryParameter(value="oneShot") boolean oneShot) {
            if (!oneShot && value) {
                return FormValidation.error((String)Messages.InstanceConfiguration_SnapshotConfigError());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNumExecutorsStr(@AncestorInPath Jenkins context, @QueryParameter String value, @QueryParameter(value="oneShot") boolean oneShot) {
            int numExecutors = InstanceConfiguration.intOrDefault(value, DEFAULT_NUM_EXECUTORS);
            if (numExecutors < 1) {
                return FormValidation.error((String)Messages.InstanceConfiguration_NumExecutorsLessThanOneConfigError());
            }
            if (numExecutors > 1 && oneShot) {
                return FormValidation.error((String)Messages.InstanceConfiguration_NumExecutorsOneShotError());
            }
            return FormValidation.ok();
        }
    }
}

