/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.google.api.services.compute.model.Operation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.jenkins.plugins.computeengine.ComputeEngineComputer;
import com.google.jenkins.plugins.computeengine.ComputeEngineComputerLauncher;
import com.google.jenkins.plugins.computeengine.ComputeEngineInstance;
import com.google.jenkins.plugins.computeengine.WindowsConfiguration;
import com.trilead.ssh2.Connection;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Logger;

public class ComputeEngineWindowsLauncher
extends ComputeEngineComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(ComputeEngineWindowsLauncher.class.getName());
    private static int bootstrapAuthTries = 30;
    private static int bootstrapAuthSleepMs = 15000;

    public ComputeEngineWindowsLauncher(String cloudName, Operation insertOperation, boolean useInternalAddress) {
        super(cloudName, insertOperation.getName(), insertOperation.getZone(), useInternalAddress);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected Optional<Connection> setupConnection(ComputeEngineInstance node, ComputeEngineComputer computer, TaskListener listener) throws Exception {
        if (node.getWindowsConfig() == null) {
            this.logWarning(computer, listener, "Non-windows node provided");
            return Optional.empty();
        }
        Optional<Connection> bootstrapConn = this.bootstrap(computer, listener);
        if (!bootstrapConn.isPresent()) {
            this.logWarning(computer, listener, "bootstrapresult failed");
            return Optional.empty();
        }
        return bootstrapConn;
    }

    @VisibleForTesting
    public static boolean authenticateSSH(String windowsUsername, WindowsConfiguration windowsConfig, Connection sshConnection, TaskListener listener) throws Exception {
        boolean isAuthenticated = !windowsConfig.getPrivateKeyCredentialsId().isEmpty() ? SSHAuthenticator.newInstance((Object)sshConnection, (StandardUsernameCredentials)windowsConfig.getPrivateKeyCredentials(), (String)windowsUsername).authenticate(listener) : sshConnection.authenticateWithPassword(windowsUsername, windowsConfig.getPassword());
        return isAuthenticated;
    }

    private Optional<Connection> bootstrap(ComputeEngineComputer computer, TaskListener listener) {
        Preconditions.checkNotNull((Object)((Object)computer), (Object)"A null ComputeEngineComputer was provided");
        this.logInfo(computer, listener, "bootstrap");
        ComputeEngineInstance node = (ComputeEngineInstance)computer.getNode();
        if (node == null) {
            throw new IllegalArgumentException("A ComputeEngineComputer with no node was provided");
        }
        if (node.getWindowsConfig() == null) {
            throw new IllegalArgumentException("A non-windows ComputeEngineComputer was provided.");
        }
        WindowsConfiguration windowsConfig = node.getWindowsConfig();
        Connection bootstrapConn = null;
        try {
            int tries = bootstrapAuthTries;
            boolean isAuthenticated = false;
            while (tries-- > 0) {
                block9: {
                    this.logInfo(computer, listener, "Authenticating as " + node.getSshUser());
                    try {
                        bootstrapConn = this.connectToSsh(computer, listener);
                        isAuthenticated = ComputeEngineWindowsLauncher.authenticateSSH(node.getSshUser(), windowsConfig, bootstrapConn, listener);
                    }
                    catch (IOException e) {
                        this.logException(computer, listener, "Exception trying to authenticate", e);
                        if (bootstrapConn == null) break block9;
                        bootstrapConn.close();
                    }
                }
                if (isAuthenticated) break;
                this.logWarning(computer, listener, "Authentication failed. Trying again...");
                Thread.sleep(bootstrapAuthSleepMs);
            }
            if (!isAuthenticated) {
                this.logWarning(computer, listener, "Authentication failed");
                return Optional.empty();
            }
        }
        catch (Exception e) {
            this.logException(computer, listener, "Failed to authenticate with exception: ", e);
            if (bootstrapConn != null) {
                bootstrapConn.close();
            }
            return Optional.empty();
        }
        return Optional.ofNullable(bootstrapConn);
    }

    @Override
    protected String getPathSeparator() {
        return "\\";
    }
}

