/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.api.services.compute.model.Operation;
import com.google.jenkins.plugins.computeengine.ComputeEngineComputer;
import com.google.jenkins.plugins.computeengine.ComputeEngineComputerLauncher;
import com.google.jenkins.plugins.computeengine.ComputeEngineInstance;
import com.google.jenkins.plugins.computeengine.ssh.GoogleKeyCredential;
import com.google.jenkins.plugins.computeengine.ssh.GoogleKeyPair;
import com.google.jenkins.plugins.computeengine.ssh.GooglePrivateKey;
import com.trilead.ssh2.Connection;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Logger;

public class ComputeEngineLinuxLauncher
extends ComputeEngineComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(ComputeEngineLinuxLauncher.class.getName());
    private static int bootstrapAuthTries = 30;
    private static int bootstrapAuthSleepMs = 15000;

    public ComputeEngineLinuxLauncher(String cloudName, Operation insertOperation, boolean useInternalAddress) {
        super(cloudName, insertOperation.getName(), insertOperation.getZone(), useInternalAddress);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected Optional<Connection> setupConnection(ComputeEngineInstance node, ComputeEngineComputer computer, TaskListener listener) throws Exception {
        if (!node.getSSHKeyCredential().isPresent()) {
            this.logSevere(computer, listener, String.format("Failed to retrieve SSH keypair for instance: %s", node.getNodeName()));
            return Optional.empty();
        }
        GoogleKeyCredential kp = node.getSSHKeyCredential().get();
        Optional<Connection> bootstrapConn = this.bootstrap(kp, computer, listener);
        if (!bootstrapConn.isPresent()) {
            this.logWarning(computer, listener, "bootstrapresult failed");
            return Optional.empty();
        }
        return bootstrapConn;
    }

    private Optional<Connection> bootstrap(GoogleKeyCredential keyCred, ComputeEngineComputer computer, TaskListener listener) throws IOException, Exception {
        this.logInfo(computer, listener, "bootstrap");
        ComputeEngineInstance node = (ComputeEngineInstance)computer.getNode();
        if (node == null) {
            throw new IllegalArgumentException("A ComputeEngineComputer with no node was provided");
        }
        Connection bootstrapConn = null;
        try {
            int tries = bootstrapAuthTries;
            boolean isAuthenticated = false;
            if (keyCred instanceof GoogleKeyPair) {
                this.logInfo(computer, listener, "Getting keypair...");
                this.logInfo(computer, listener, "Using autogenerated ssh keypair");
            } else if (keyCred instanceof GooglePrivateKey) {
                this.logInfo(computer, listener, "Getting private key...");
                this.logInfo(computer, listener, "Using custom ssh private key");
            }
            while (tries-- > 0) {
                block11: {
                    this.logInfo(computer, listener, "Authenticating as " + node.getSshUser());
                    try {
                        bootstrapConn = this.connectToSsh(computer, listener);
                        isAuthenticated = bootstrapConn.authenticateWithPublicKey(node.getSshUser(), Secret.toString((Secret)keyCred.getPrivateKey()).toCharArray(), "");
                    }
                    catch (IOException e) {
                        this.logException(computer, listener, "Exception trying to authenticate", e);
                        if (bootstrapConn == null) break block11;
                        bootstrapConn.close();
                    }
                }
                if (isAuthenticated) break;
                this.logWarning(computer, listener, "Authentication failed. Trying again...");
                Thread.sleep(bootstrapAuthSleepMs);
            }
            if (!isAuthenticated) {
                this.logWarning(computer, listener, "Authentication failed");
                return Optional.empty();
            }
        }
        catch (Exception e) {
            this.logException(computer, listener, "Failed to authenticate with exception: ", e);
            if (bootstrapConn != null) {
                bootstrapConn.close();
            }
            return Optional.empty();
        }
        return Optional.of(bootstrapConn);
    }

    @Override
    protected String getPathSeparator() {
        return "/";
    }
}

