/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine.client;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.cloud.graphite.platforms.plugin.client.ClientFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.computeengine.ComputeEngineScopeRequirement;
import com.google.jenkins.plugins.computeengine.client.Messages;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2Credentials;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import hudson.AbortException;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Optional;
import org.acegisecurity.Authentication;

public class ClientUtil {
    private static final String APPLICATION_NAME = "jenkins-google-compute-plugin";

    public static ClientFactory getClientFactory(ItemGroup itemGroup, ImmutableList<DomainRequirement> domainRequirements, String credentialsId, Optional<HttpTransport> transport) throws AbortException {
        ClientFactory clientFactory;
        Preconditions.checkNotNull((Object)itemGroup);
        Preconditions.checkNotNull(domainRequirements);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)credentialsId) ? 1 : 0) != 0);
        Preconditions.checkNotNull(transport);
        try {
            GoogleRobotCredentials robotCreds = ClientUtil.getRobotCredentials(itemGroup, domainRequirements, credentialsId);
            Credential googleCredential = ClientUtil.getGoogleCredential(robotCreds);
            clientFactory = new ClientFactory(transport, (HttpRequestInitializer)googleCredential, APPLICATION_NAME);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new AbortException(Messages.ClientFactory_FailedToInitializeHTTPTransport(ex));
        }
        return clientFactory;
    }

    public static ClientFactory getClientFactory(ItemGroup itemGroup, String credentialsId) throws AbortException {
        return ClientUtil.getClientFactory(itemGroup, (ImmutableList<DomainRequirement>)ImmutableList.of(), credentialsId, Optional.empty());
    }

    private static GoogleRobotCredentials getRobotCredentials(ItemGroup itemGroup, List<DomainRequirement> domainRequirements, String credentialsId) throws AbortException {
        GoogleOAuth2Credentials credentials = (GoogleOAuth2Credentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(GoogleOAuth2Credentials.class, (ItemGroup)itemGroup, (Authentication)ACL.SYSTEM, domainRequirements), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (!(credentials instanceof GoogleRobotCredentials)) {
            throw new AbortException(Messages.ClientFactory_FailedToRetrieveCredentials(credentialsId));
        }
        return (GoogleRobotCredentials)credentials;
    }

    private static Credential getGoogleCredential(GoogleRobotCredentials credentials) throws GeneralSecurityException {
        return credentials.getGoogleCredential((GoogleOAuth2ScopeRequirement)new ComputeEngineScopeRequirement());
    }
}

