/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.api.services.compute.model.Instance;
import com.google.cloud.graphite.platforms.plugin.client.ClientFactory;
import com.google.cloud.graphite.platforms.plugin.client.ComputeClient;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.jenkins.plugins.computeengine.ComputeEngineInstance;
import com.google.jenkins.plugins.computeengine.InstanceConfiguration;
import com.google.jenkins.plugins.computeengine.Messages;
import com.google.jenkins.plugins.computeengine.NoConfigurationException;
import com.google.jenkins.plugins.computeengine.client.ClientUtil;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2Credentials;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.slaves.AbstractCloudImpl;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ComputeEngineCloud
extends AbstractCloudImpl {
    private static final Logger log = Logger.getLogger(ComputeEngineCloud.class.getName());
    public static final String CLOUD_PREFIX = "gce-";
    public static final String CONFIG_LABEL_KEY = "jenkins_config_name";
    public static final String CLOUD_ID_LABEL_KEY = "jenkins_cloud_id";
    private static final SimpleFormatter sf = new SimpleFormatter();
    private static int configsNext;
    private final String projectId;
    private final String credentialsId;
    private String instanceId;
    private List<InstanceConfiguration> configurations;
    private volatile transient ComputeClient client;
    private boolean noDelayProvisioning;

    @DataBoundConstructor
    public ComputeEngineCloud(String cloudName, String projectId, String credentialsId, String instanceCapStr) {
        super(ComputeEngineCloud.createCloudId(cloudName), instanceCapStr);
        this.credentialsId = credentialsId;
        this.projectId = projectId;
        this.setInstanceId(null);
        this.setConfigurations(null);
    }

    @Deprecated
    public ComputeEngineCloud(String cloudName, String projectId, String credentialsId, String instanceCapStr, List<InstanceConfiguration> configurations) {
        this(cloudName, projectId, credentialsId, instanceCapStr);
        this.setConfigurations(configurations);
    }

    private static String createCloudId(String name) {
        return CLOUD_PREFIX + name.trim();
    }

    public static void log(Logger logger, Level level, TaskListener listener, String message) {
        ComputeEngineCloud.log(logger, level, listener, message, null);
    }

    public static void log(Logger logger, Level level, TaskListener listener, String message, Throwable exception) {
        logger.log(level, message, exception);
        if (listener != null) {
            if (exception != null) {
                message = message + " Exception: " + exception;
            }
            LogRecord lr = new LogRecord(level, message);
            PrintStream printStream = listener.getLogger();
            printStream.print(sf.format(lr));
        }
    }

    public String getCloudName() {
        return this.name.substring(CLOUD_PREFIX.length());
    }

    public String getDisplayName() {
        return this.getCloudName();
    }

    public boolean isNoDelayProvisioning() {
        return this.noDelayProvisioning;
    }

    @DataBoundSetter
    public void setNoDelayProvisioning(boolean noDelayProvisioning) {
        this.noDelayProvisioning = noDelayProvisioning;
    }

    protected Object readResolve() {
        if (this.configurations != null) {
            for (InstanceConfiguration configuration : this.configurations) {
                configuration.setCloud(this);
                configuration.readResolve();
                configuration.appendLabel(CLOUD_ID_LABEL_KEY, this.getInstanceId());
                configuration.appendLabel(CONFIG_LABEL_KEY, configuration.getNamePrefix());
            }
        }
        this.setInstanceId(this.instanceId);
        return this;
    }

    @DataBoundSetter
    public void setInstanceId(String instanceId) {
        this.instanceId = Strings.isNullOrEmpty((String)instanceId) ? UUID.randomUUID().toString() : instanceId;
    }

    private ComputeClient createClient() {
        try {
            ClientFactory clientFactory = ClientUtil.getClientFactory((ItemGroup)Jenkins.get(), this.credentialsId);
            return clientFactory.computeClient();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Exception when creating GCE client", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComputeClient getClient() {
        if (this.client == null) {
            ComputeEngineCloud computeEngineCloud = this;
            synchronized (computeEngineCloud) {
                if (this.client == null) {
                    this.client = this.createClient();
                }
            }
        }
        return this.client;
    }

    @DataBoundSetter
    public void setConfigurations(List<InstanceConfiguration> configurations) {
        this.configurations = configurations;
        this.readResolve();
    }

    @Deprecated
    public void addConfiguration(InstanceConfiguration configuration) {
        if (this.configurations == null) {
            this.configurations = new ArrayList<InstanceConfiguration>();
        }
        this.configurations.add(configuration);
        this.readResolve();
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        ArrayList<NodeProvisioner.PlannedNode> result = new ArrayList<NodeProvisioner.PlannedNode>();
        try {
            List<InstanceConfiguration> configs = this.getInstanceConfigurations(label);
            log.log(Level.INFO, "Provisioning node from configs " + configs + " for excess workload of " + excessWorkload + " units of label '" + label + "'");
            int availableCapacity = this.availableNodeCapacity();
            while (excessWorkload > 0) {
                if (availableCapacity <= 0) {
                    log.warning(String.format("Could not provision new nodes to meet excess workload demand (%d). Cloud provider %s has reached its configured capacity of %d", excessWorkload, this.getCloudName(), this.getInstanceCap()));
                    break;
                }
                InstanceConfiguration config = this.chooseConfigFromList(configs);
                ComputeEngineInstance node = config.provision();
                Jenkins.get().addNode((Node)node);
                result.add(this.createPlannedNode(config, node));
                excessWorkload -= node.getNumExecutors();
                availableCapacity -= node.getNumExecutors();
            }
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "Error provisioning node", ioe);
        }
        catch (NoConfigurationException nce) {
            log.log(Level.WARNING, String.format("An instance configuration could not be found to provision a node for label %s", label.getName()), nce.getMessage());
        }
        return result;
    }

    private InstanceConfiguration chooseConfigFromList(List<InstanceConfiguration> configs) {
        return configs.get(Math.abs(configsNext++) % configs.size());
    }

    private NodeProvisioner.PlannedNode createPlannedNode(InstanceConfiguration config, ComputeEngineInstance node) {
        return new NodeProvisioner.PlannedNode(node.getNodeName(), this.getPlannedNodeFuture(config, node), node.getNumExecutors());
    }

    private Future<Node> getPlannedNodeFuture(InstanceConfiguration config, ComputeEngineInstance node) {
        return Computer.threadPoolForRemoting.submit(() -> {
            long startTime = System.currentTimeMillis();
            log.log(Level.INFO, String.format("Waiting %dms for node %s to connect", config.getLaunchTimeoutMillis(), node.getNodeName()));
            try {
                Computer c = node.toComputer();
                if (c != null) {
                    c.connect(false).get(config.getLaunchTimeoutMillis(), TimeUnit.MILLISECONDS);
                    log.log(Level.INFO, String.format("%dms elapsed waiting for node %s to connect", System.currentTimeMillis() - startTime, node.getNodeName()));
                } else {
                    log.log(Level.WARNING, String.format("No computer for node %s found", node.getNodeName()));
                }
            }
            catch (TimeoutException e) {
                log.log(Level.WARNING, String.format("Timeout waiting for node %s to connect", node.getNodeName()), e);
            }
            return null;
        });
    }

    private synchronized Integer availableNodeCapacity() throws IOException {
        try {
            ImmutableMap filterLabel = ImmutableMap.of((Object)CLOUD_ID_LABEL_KEY, (Object)this.getInstanceId());
            ArrayList instances = new ArrayList(this.getClient().listInstancesWithLabel(this.projectId, (Map)filterLabel));
            Iterator it = instances.iterator();
            while (it.hasNext()) {
                Instance o = (Instance)it.next();
                if (o.getStatus().equals("PROVISIONING") || o.getStatus().equals("STAGING") || o.getStatus().equals("RUNNING")) continue;
                it.remove();
            }
            Integer capacity = this.getInstanceCap() - instances.size();
            log.info(String.format("Found capacity for %d nodes in cloud %s", capacity, this.getCloudName()));
            return this.getInstanceCap() - instances.size();
        }
        catch (IOException ioe) {
            log.warning(String.format("An error occurred counting the number of existing instances in cloud %s: %s", this.getCloudName(), ioe.getMessage()));
            throw ioe;
        }
    }

    public boolean canProvision(Label label) {
        try {
            this.getInstanceConfigurations(label);
            return true;
        }
        catch (NoConfigurationException nce) {
            return false;
        }
    }

    public List<InstanceConfiguration> getInstanceConfigurations(Label label) throws NoConfigurationException {
        if (this.configurations == null) {
            throw new NoConfigurationException(String.format("Cloud %s does not have any defined instance configurations.", this.getCloudName()));
        }
        List<InstanceConfiguration> configurations = this.configurations.stream().filter(configuration -> this.matchesLabel((InstanceConfiguration)configuration, label)).collect(Collectors.toList());
        if (configurations.isEmpty()) {
            throw new NoConfigurationException(String.format("Cloud %s does not have any matching instance configurations.", this.getCloudName()));
        }
        return configurations;
    }

    private boolean matchesLabel(InstanceConfiguration configuration, Label label) {
        if (configuration.getMode() == Node.Mode.NORMAL) {
            return label == null || label.matches(configuration.getLabelSet());
        }
        if (configuration.getMode() == Node.Mode.EXCLUSIVE) {
            return label != null && label.matches(configuration.getLabelSet());
        }
        return false;
    }

    public InstanceConfiguration getInstanceConfigurationByDescription(String description) {
        for (InstanceConfiguration c : this.configurations) {
            if (!c.getDescription().equals(description)) continue;
            return c;
        }
        return null;
    }

    @RequirePOST
    public HttpResponse doProvision(@QueryParameter String configuration) throws ServletException, IOException {
        ComputeEngineCloud.checkPermissions(PROVISION);
        if (configuration == null) {
            throw HttpResponses.error((int)400, (String)"The 'configuration' query parameter is missing");
        }
        InstanceConfiguration c = this.getInstanceConfigurationByDescription(configuration);
        if (c == null) {
            throw HttpResponses.error((int)400, (String)("No such Instance Configuration: " + configuration));
        }
        ComputeEngineInstance node = c.provision();
        if (node == null) {
            throw HttpResponses.error((int)400, (String)"Could not provision new node.");
        }
        Jenkins.get().addNode((Node)node);
        return HttpResponses.redirectViaContextPath((String)("/computer/" + node.getNodeName()));
    }

    static void checkPermissions(Permission ... permissions) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            if (permissions.length > 0) {
                for (Permission permission : permissions) {
                    jenkins.checkPermission(permission);
                }
            } else {
                jenkins.checkPermission(Job.CONFIGURE);
            }
        }
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<InstanceConfiguration> getConfigurations() {
        return this.configurations;
    }

    @Extension
    public static class GoogleCloudDescriptor
    extends Descriptor<Cloud> {
        @Nonnull
        public String getDisplayName() {
            return Messages.ComputeEngineCloud_DisplayName();
        }

        public FormValidation doCheckProjectId(@QueryParameter String value) {
            ComputeEngineCloud.checkPermissions(new Permission[0]);
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"Project ID is required");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String value) {
            ComputeEngineCloud.checkPermissions(new Permission[0]);
            if (context == null || !context.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel();
            }
            ArrayList domainRequirements = new ArrayList();
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.instanceOf(GoogleOAuth2Credentials.class), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, domainRequirements));
        }

        @RequirePOST
        public FormValidation doCheckCredentialsId(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") String projectId, @QueryParameter String value) {
            ComputeEngineCloud.checkPermissions(new Permission[0]);
            if (value.isEmpty()) {
                return FormValidation.error((String)"No credential selected");
            }
            if (projectId.isEmpty()) {
                return FormValidation.error((String)"Project ID required to validate credential");
            }
            try {
                ClientFactory clientFactory = ClientUtil.getClientFactory((ItemGroup)context, value);
                ComputeClient compute = clientFactory.computeClient();
                compute.listRegions(projectId);
                return FormValidation.ok((String)"The credential successfully made an API request to Google Compute Engine.");
            }
            catch (IOException ioe) {
                return FormValidation.error((String)("Could not list regions in project " + projectId));
            }
        }
    }
}

