/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine.ssh;

import com.google.api.client.util.Throwables;
import com.google.common.collect.ImmutableMap;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

class SshKeysHelper {
    private static final int KEY_SIZE = 2048;

    SshKeysHelper() {
    }

    static Map<String, String> generate() {
        KeyPair pair;
        JSch jsch = new JSch();
        try {
            pair = KeyPair.genKeyPair((JSch)jsch, (int)2, (int)2048);
        }
        catch (JSchException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"public", (Object)SshKeysHelper.getPublicKey(pair));
        builder.put((Object)"private", (Object)SshKeysHelper.getPrivateKey(pair));
        return builder.build();
    }

    private static String getPublicKey(KeyPair pair) {
        return "ssh-rsa " + Base64.getEncoder().encodeToString(pair.getPublicKeyBlob());
    }

    private static String getPrivateKey(KeyPair pair) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        pair.writePrivateKey((OutputStream)out);
        try {
            return out.toString(StandardCharsets.US_ASCII.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

