/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine.ssh;

import com.google.jenkins.plugins.computeengine.ssh.SshKeysHelper;
import java.io.Serializable;
import java.util.Map;

public class GoogleKeyPair
implements Serializable {
    private final String privateKey;
    private final String publicKey;
    private final String user;

    private GoogleKeyPair(String publicKey, String privateKey, String user) {
        this.publicKey = user + ":" + publicKey + " " + user;
        this.privateKey = privateKey;
        this.user = user;
    }

    public static GoogleKeyPair generate(String user) {
        Map<String, String> keys = SshKeysHelper.generate();
        return new GoogleKeyPair(keys.get("public"), keys.get("private"), user);
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String toString() {
        return "Public key:\n" + this.publicKey + "\n\nPrivate key:\n" + this.privateKey;
    }
}

