/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

final class PreemptedCheckCallable
extends MasterToSlaveCallable<Boolean, IOException> {
    private static final String METADATA_SERVER_URL = "http://metadata.google.internal/computeMetadata/v1/instance/preempted?wait_for_change=%s";
    private final TaskListener listener;

    PreemptedCheckCallable(TaskListener listener) {
        this.listener = listener;
    }

    public Boolean call() throws IOException {
        HttpRequest initialRequest = this.createMetadataRequest(false);
        HttpResponse initialResponse = initialRequest.execute();
        String initialResult = IOUtils.toString((InputStream)initialResponse.getContent(), (Charset)Charsets.UTF_8);
        initialResponse.disconnect();
        if ("TRUE".equals(initialResult)) {
            this.listener.getLogger().println("Instance was already preempted before monitoring metadata changes.");
            return true;
        }
        HttpRequest request = this.createMetadataRequest(true);
        this.listener.getLogger().println("Preemptive instance, listening to metadata for preemption event");
        HttpResponse response = request.execute();
        String result = IOUtils.toString((InputStream)response.getContent(), (Charset)Charsets.UTF_8);
        this.listener.getLogger().println("Got preemption event " + result);
        response.disconnect();
        return "TRUE".equals(result);
    }

    private HttpRequest createMetadataRequest(boolean waitForChange) throws IOException {
        NetHttpTransport transport = new NetHttpTransport();
        GenericUrl metadata = new GenericUrl(PreemptedCheckCallable.getMetadataServerUrl(waitForChange));
        HttpRequest request = transport.createRequestFactory().buildGetRequest(metadata);
        request.setHeaders(new HttpHeaders().set("Metadata-Flavor", (Object)"Google"));
        request.setReadTimeout(Integer.MAX_VALUE);
        return request;
    }

    private static String getMetadataServerUrl(boolean waitForChange) {
        return String.format(METADATA_SERVER_URL, waitForChange);
    }
}

