/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.Operation;
import com.google.cloud.graphite.platforms.plugin.client.ComputeClient;
import com.google.jenkins.plugins.computeengine.CloudNotFoundException;
import com.google.jenkins.plugins.computeengine.ComputeEngineCloud;
import com.google.jenkins.plugins.computeengine.ComputeEngineComputer;
import com.google.jenkins.plugins.computeengine.ComputeEngineInstance;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import jenkins.model.Jenkins;

public abstract class ComputeEngineComputerLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(ComputeEngineComputerLauncher.class.getName());
    private static final SimpleFormatter sf = new SimpleFormatter();
    private static final String AGENT_JAR = "agent.jar";
    private static final int SSH_PORT = 22;
    private static final int SSH_TIMEOUT_MILLIS = 10000;
    private static final int SSH_SLEEP_MILLIS = 5000;
    private final String insertOperationId;
    private final String zone;
    private final String cloudName;
    protected final boolean useInternalAddress;

    public ComputeEngineComputerLauncher(String cloudName, String insertOperationId, String zone, boolean useInternalAddress) {
        this.cloudName = cloudName;
        this.insertOperationId = insertOperationId;
        this.zone = zone;
        this.useInternalAddress = useInternalAddress;
    }

    public static void log(Logger logger, Level level, TaskListener listener, String message) {
        ComputeEngineComputerLauncher.log(logger, level, listener, message, null);
    }

    public static void log(Logger logger, Level level, TaskListener listener, String message, Throwable exception) {
        logger.log(level, message, exception);
        if (listener != null) {
            if (exception != null) {
                message = message + " Exception: " + exception;
            }
            LogRecord lr = new LogRecord(level, message);
            PrintStream printStream = listener.getLogger();
            printStream.print(sf.format(lr));
        }
    }

    private void log(Level level, ComputeEngineComputer computer, TaskListener listener, String message, Throwable exception) {
        try {
            ComputeEngineCloud cloud = computer.getCloud();
            ComputeEngineCloud.log(this.getLogger(), level, listener, message, exception);
        }
        catch (CloudNotFoundException cnfe) {
            ComputeEngineComputerLauncher.log(this.getLogger(), Level.SEVERE, listener, "FATAL: Could not get cloud", cnfe);
        }
    }

    protected void logException(ComputeEngineComputer computer, TaskListener listener, String message, Throwable exception) {
        this.log(Level.WARNING, computer, listener, message, exception);
    }

    protected void logInfo(ComputeEngineComputer computer, TaskListener listener, String message) {
        this.log(Level.INFO, computer, listener, message, null);
    }

    protected void logWarning(ComputeEngineComputer computer, TaskListener listener, String message) {
        this.log(Level.WARNING, computer, listener, message, null);
    }

    protected void logSevere(ComputeEngineComputer computer, TaskListener listener, String message) {
        this.log(Level.SEVERE, computer, listener, message, null);
    }

    protected abstract Logger getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(SlaveComputer slaveComputer, TaskListener listener) {
        ComputeEngineCloud cloud;
        ComputeEngineComputer computer = (ComputeEngineComputer)slaveComputer;
        try {
            cloud = computer.getCloud();
        }
        catch (CloudNotFoundException cnfe) {
            ComputeEngineComputerLauncher.log(LOGGER, Level.SEVERE, listener, String.format("Could not get cloud %s", this.cloudName));
            return;
        }
        ComputeEngineInstance node = (ComputeEngineInstance)computer.getNode();
        if (node == null) {
            ComputeEngineComputerLauncher.log(LOGGER, Level.SEVERE, listener, String.format("Could not get node from computer", new Object[0]));
            return;
        }
        Operation.Error opError = new Operation.Error();
        try {
            LOGGER.info(String.format("Launch will wait %d for operation %s to complete...", node.getLaunchTimeout(), this.insertOperationId));
            try {
                Operation operation = cloud.getClient().waitForOperationCompletion(cloud.getProjectId(), this.insertOperationId, this.zone, node.getLaunchTimeoutMillis());
                opError = operation.getError();
            }
            catch (ComputeClient.OperationException e) {
                opError = e.getError();
            }
            if (opError != null) {
                LOGGER.info(String.format("Launch failed while waiting for operation %s to complete. Operation error was %s", this.insertOperationId, ((Operation.Error.Errors)opError.getErrors().get(0)).getMessage()));
                return;
            }
        }
        catch (InterruptedException e) {
            LOGGER.info(String.format("Launch failed while waiting for operation %s to complete. Operation error was %s", this.insertOperationId, ((Operation.Error.Errors)opError.getErrors().get(0)).getMessage()));
            return;
        }
        try {
            block27: while (true) {
                switch (computer.getInstanceStatus()) {
                    case "PROVISIONING": 
                    case "STAGING": {
                        ComputeEngineCloud.log(LOGGER, Level.FINEST, listener, String.format("Instance %s is being prepared...", computer.getName()));
                        break;
                    }
                    case "RUNNING": {
                        ComputeEngineCloud.log(LOGGER, Level.FINEST, listener, String.format("Instance %s is running and ready...", computer.getName()));
                        break block27;
                    }
                    case "STOPPING": 
                    case "SUSPENDING": 
                    case "TERMINATED": {
                        ComputeEngineCloud.log(LOGGER, Level.FINEST, listener, String.format("Instance %s is being shut down...", computer.getName()));
                        break;
                    }
                    case "STOPPED": 
                    case "SUSPENDED": {
                        ComputeEngineCloud.log(LOGGER, Level.FINEST, listener, String.format("Instance %s was unexpectedly stopped or suspended...", computer.getName()));
                        return;
                    }
                }
                Thread.sleep(5000L);
            }
            computer.refreshInstance();
            this.launch(computer, listener);
            return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace(listener.error(ioe.getMessage()));
            node = (ComputeEngineInstance)slaveComputer.getNode();
            if (node == null) return;
            try {
                node.terminate();
                return;
            }
            catch (Exception e) {
                listener.error(String.format("Failed to terminate node %s", node.getDisplayName()));
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean testCommand(ComputeEngineComputer computer, Connection conn, String checkCommand, PrintStream logger, TaskListener listener) throws IOException, InterruptedException {
        this.logInfo(computer, listener, "Verifying: " + checkCommand);
        return conn.exec(checkCommand, (OutputStream)logger) == 0;
    }

    protected abstract Optional<Connection> setupConnection(ComputeEngineInstance var1, ComputeEngineComputer var2, TaskListener var3) throws Exception;

    protected abstract String getPathSeparator();

    private boolean checkJavaInstalled(ComputeEngineComputer computer, Connection conn, PrintStream logger, TaskListener listener, String javaExecPath) {
        try {
            if (this.testCommand(computer, conn, String.format("%s -fullversion", javaExecPath), logger, listener)) {
                return true;
            }
        }
        catch (IOException | InterruptedException ex) {
            this.logException(computer, listener, "Failed to check java: ", ex);
            return false;
        }
        this.logWarning(computer, listener, String.format("Java is not installed at %s", javaExecPath));
        return false;
    }

    private void copyAgentJar(ComputeEngineComputer computer, Connection conn, TaskListener listener, String jenkinsDir) throws IOException {
        SCPClient scp = conn.createSCPClient();
        this.logInfo(computer, listener, "Copying agent.jar to: " + jenkinsDir);
        scp.put(Jenkins.get().getJnlpJars(AGENT_JAR).readFully(), AGENT_JAR, jenkinsDir);
    }

    private String getJavaLaunchString(String javaExecPath, String jenkinsDir) {
        return String.format("%s -jar %s%s%s", javaExecPath, jenkinsDir, this.getPathSeparator(), AGENT_JAR);
    }

    private void launch(ComputeEngineComputer computer, TaskListener listener) {
        ComputeEngineInstance node = (ComputeEngineInstance)computer.getNode();
        if (node == null) {
            this.logWarning(computer, listener, "Could not get node from computer");
            return;
        }
        PrintStream logger = listener.getLogger();
        this.logInfo(computer, listener, "Launching instance: " + node.getNodeName());
        try {
            String javaExecPath;
            Optional<Connection> cleanupConn = this.setupConnection(node, computer, listener);
            if (!cleanupConn.isPresent()) {
                return;
            }
            final Connection conn = cleanupConn.get();
            if (!this.checkJavaInstalled(computer, conn, logger, listener, javaExecPath = node.getJavaExecPathOrDefault())) {
                return;
            }
            String jenkinsDir = node.getRemoteFS();
            this.copyAgentJar(computer, conn, listener, jenkinsDir);
            String launchString = this.getJavaLaunchString(javaExecPath, jenkinsDir);
            this.logInfo(computer, listener, "Launching Jenkins agent via plugin SSH: " + launchString);
            final Session sess = conn.openSession();
            sess.execCommand(launchString);
            computer.setChannel(sess.getStdout(), sess.getStdin(), logger, new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    sess.close();
                    conn.close();
                }
            });
        }
        catch (Exception e) {
            this.logException(computer, listener, "Error: ", e);
        }
    }

    protected Connection connectToSsh(ComputeEngineComputer computer, TaskListener listener) throws Exception {
        ComputeEngineInstance node = (ComputeEngineInstance)computer.getNode();
        if (node == null) {
            throw new IllegalArgumentException("A ComputeEngineComputer with no node was provided");
        }
        long timeout = node.getLaunchTimeoutMillis();
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                Proxy proxy;
                long waitTime = System.currentTimeMillis() - startTime;
                if (timeout > 0L && waitTime > timeout) {
                    throw new Exception("Timed out after " + waitTime / 1000L + " seconds of waiting for ssh to become available. (maximum timeout configured is " + timeout / 1000L + ")");
                }
                Instance instance = computer.refreshInstance();
                String host = "";
                NetworkInterface nic = (NetworkInterface)instance.getNetworkInterfaces().get(0);
                if (this.useInternalAddress) {
                    host = nic.getNetworkIP();
                } else {
                    if (nic.getAccessConfigs() != null) {
                        for (AccessConfig ac : nic.getAccessConfigs()) {
                            if (!ac.getType().equals("ONE_TO_ONE_NAT")) continue;
                            host = ac.getNatIP();
                        }
                    }
                    if (host.isEmpty()) {
                        host = nic.getNetworkIP();
                    }
                }
                int port = 22;
                this.logInfo(computer, listener, "Connecting to " + host + " on port " + port + ", with timeout " + 10000 + ".");
                Connection conn = new Connection(host, port);
                ProxyConfiguration proxyConfig = Jenkins.get().proxy;
                Proxy proxy2 = proxy = proxyConfig == null ? Proxy.NO_PROXY : proxyConfig.createProxy(host);
                if (!node.isIgnoreProxy() && !proxy.equals(Proxy.NO_PROXY) && proxy.address() instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)proxy.address();
                    HTTPProxyData proxyData = null;
                    proxyData = proxyConfig.getUserName() != null && proxyConfig.getPassword() != null ? new HTTPProxyData(address.getHostName(), address.getPort(), proxyConfig.getUserName(), proxyConfig.getPassword()) : new HTTPProxyData(address.getHostName(), address.getPort());
                    conn.setProxyData((ProxyData)proxyData);
                    this.logInfo(computer, listener, "Using HTTP Proxy Configuration");
                }
                conn.connect((hostname, portNum, serverHostKeyAlgorithm, serverHostKey) -> true, 10000, 10000);
                this.logInfo(computer, listener, "Connected via SSH.");
                return conn;
            }
            catch (IOException e) {
                this.logInfo(computer, listener, "Failed to connect via ssh: " + e.getMessage());
                this.logInfo(computer, listener, "Waiting for SSH to come up. Sleeping 5.");
                Thread.sleep(5000L);
                continue;
            }
            break;
        }
    }

    public boolean isUseInternalAddress() {
        return this.useInternalAddress;
    }
}

