/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.api.services.compute.model.Instance;
import com.google.common.collect.ImmutableMap;
import com.google.jenkins.plugins.computeengine.ComputeEngineCloud;
import com.google.jenkins.plugins.computeengine.ComputeEngineInstance;
import hudson.Extension;
import hudson.model.PeriodicWork;
import hudson.model.Slave;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"cleanLostNodesWork"})
public class CleanLostNodesWork
extends PeriodicWork {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public long getRecurrencePeriod() {
        return 3600000L;
    }

    protected void doRun() {
        this.logger.log(Level.FINEST, "Starting clean lost nodes worker");
        this.getClouds().forEach(this::cleanCloud);
    }

    private void cleanCloud(ComputeEngineCloud cloud) {
        this.logger.log(Level.FINEST, "Cleaning cloud " + cloud.getCloudName());
        List<Instance> remoteInstances = this.findRemoteInstances(cloud);
        Set<String> localInstances = this.findLocalInstances(cloud);
        remoteInstances.stream().filter(remote -> this.isOrphaned((Instance)remote, localInstances)).forEach(remote -> this.terminateInstance((Instance)remote, cloud));
    }

    private boolean isOrphaned(Instance remote, Set<String> localInstances) {
        String instanceName = remote.getName();
        this.logger.log(Level.FINEST, "Checking instance " + instanceName);
        return !localInstances.contains(instanceName);
    }

    private void terminateInstance(Instance remote, ComputeEngineCloud cloud) {
        String instanceName = remote.getName();
        this.logger.log(Level.INFO, "Remote instance " + instanceName + " not found locally, removing it");
        try {
            cloud.getClient().terminateInstanceAsync(cloud.getProjectId(), remote.getZone(), instanceName);
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Error terminating remote instance " + instanceName, ex);
        }
    }

    private List<ComputeEngineCloud> getClouds() {
        return Jenkins.get().clouds.stream().filter(cloud -> cloud instanceof ComputeEngineCloud).map(cloud -> (ComputeEngineCloud)((Object)cloud)).collect(Collectors.toList());
    }

    private Set<String> findLocalInstances(ComputeEngineCloud cloud) {
        return Jenkins.get().getNodes().stream().filter(node -> node instanceof ComputeEngineInstance).map(node -> (ComputeEngineInstance)((Object)node)).filter(node -> ((Object)((Object)node.getCloud())).equals((Object)cloud)).map(Slave::getNodeName).collect(Collectors.toSet());
    }

    private List<Instance> findRemoteInstances(ComputeEngineCloud cloud) {
        ImmutableMap filterLabel = ImmutableMap.of((Object)"jenkins_cloud_id", (Object)cloud.getInstanceId());
        try {
            return cloud.getClient().listInstancesWithLabel(cloud.getProjectId(), (Map)filterLabel).stream().filter(instance -> this.shouldTerminateStatus(instance.getStatus())).collect(Collectors.toList());
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Error finding remote instances", ex);
            return Collections.emptyList();
        }
    }

    private boolean shouldTerminateStatus(String status) {
        return !status.equals("STOPPING");
    }
}

