/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.api.services.compute.model.AcceleratorType;
import com.google.cloud.graphite.platforms.plugin.client.ClientFactory;
import com.google.cloud.graphite.platforms.plugin.client.ComputeClient;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.computeengine.client.ClientUtil;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.util.ListBoxModel;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AcceleratorConfiguration
implements Describable<AcceleratorConfiguration> {
    private final String gpuType;
    private final String gpuCount;

    @DataBoundConstructor
    public AcceleratorConfiguration(String gpuType, String gpuCount) {
        this.gpuType = gpuType;
        this.gpuCount = gpuCount;
    }

    public Integer gpuCount() {
        return Integer.parseInt(this.gpuCount);
    }

    public Descriptor<AcceleratorConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    public String toString() {
        return String.format("%s (%s)", this.gpuType, this.gpuCount);
    }

    public String getGpuType() {
        return this.gpuType;
    }

    public String getGpuCount() {
        return this.gpuCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcceleratorConfiguration)) {
            return false;
        }
        AcceleratorConfiguration other = (AcceleratorConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$gpuType = this.getGpuType();
        String other$gpuType = other.getGpuType();
        if (this$gpuType == null ? other$gpuType != null : !this$gpuType.equals(other$gpuType)) {
            return false;
        }
        String this$gpuCount = this.getGpuCount();
        String other$gpuCount = other.getGpuCount();
        return !(this$gpuCount == null ? other$gpuCount != null : !this$gpuCount.equals(other$gpuCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AcceleratorConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $gpuType = this.getGpuType();
        result = result * 59 + ($gpuType == null ? 43 : $gpuType.hashCode());
        String $gpuCount = this.getGpuCount();
        result = result * 59 + ($gpuCount == null ? 43 : $gpuCount.hashCode());
        return result;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AcceleratorConfiguration> {
        private static ComputeClient computeClient;

        public static void setComputeClient(ComputeClient client) {
            computeClient = client;
        }

        private static ComputeClient computeClient(Jenkins context, String credentialsId) throws IOException {
            if (computeClient != null) {
                return computeClient;
            }
            ClientFactory clientFactory = ClientUtil.getClientFactory((ItemGroup)context, credentialsId);
            return clientFactory.computeClient();
        }

        public ListBoxModel doFillGpuTypeItems(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") @RelativePath(value="../..") String projectId, @QueryParameter(value="zone") @RelativePath(value="..") String zone, @QueryParameter(value="credentialsId") @RelativePath(value="../..") String credentialsId) {
            ListBoxModel items = new ListBoxModel();
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                ImmutableList acceleratorTypes = compute.listAcceleratorTypes(projectId, zone);
                for (AcceleratorType a : acceleratorTypes) {
                    items.add(a.getName(), a.getSelfLink());
                }
                return items;
            }
            catch (IOException ioe) {
                items.clear();
                items.add("Error retrieving GPU types");
                return items;
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
    }
}

