/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.jenkins.plugins.persistentmaster.storage.AbstractStorageProvider;
import com.google.jenkins.plugins.persistentmaster.storage.LocalFileStorage;
import com.google.jenkins.plugins.persistentmaster.storage.Messages;
import com.google.jenkins.plugins.persistentmaster.storage.Storage;
import hudson.Extension;
import hudson.util.FormValidation;
import java.io.File;
import javax.annotation.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class LocalFileStorageProvider
extends AbstractStorageProvider {
    @VisibleForTesting
    public static final String DISPLAY_NAME = Messages.LocalFileStorageProvider_DisplayName();
    @VisibleForTesting
    public static final String DEFAULT_DIRECTORY = System.getProperty("java.io.tmpdir");
    private final String directory;

    public LocalFileStorageProvider() {
        this(null);
    }

    @DataBoundConstructor
    public LocalFileStorageProvider(String directory) {
        this.directory = directory == null ? DEFAULT_DIRECTORY : directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    @Override
    public Storage getStorage() {
        return new LocalFileStorage(new File(this.directory).toPath());
    }

    @Override
    public boolean isValid() {
        return LocalFileStorageProvider.validateDirectory(this.directory) == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFileStorageProvider that = (LocalFileStorageProvider)o;
        return !(this.directory != null ? !this.directory.equals(that.directory) : that.directory != null);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.directory});
    }

    public String toString() {
        String string = String.valueOf("LocalFileStorageProvider{directory='");
        String string2 = this.directory;
        return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append("'").append("}").toString();
    }

    @Nullable
    @VisibleForTesting
    protected static String validateDirectory(String value) {
        if (value == null) {
            return Messages.LocalFileStorageProvider_DirectoryRequiredError();
        }
        if (Strings.isNullOrEmpty((String)(value = value.trim()))) {
            return Messages.LocalFileStorageProvider_DirectoryRequiredError();
        }
        File check = new File(value);
        if (!check.exists()) {
            return Messages.LocalFileStorageProvider_DirectoryDoesntExistError(value);
        }
        if (!check.isDirectory()) {
            return Messages.LocalFileStorageProvider_NotDirectoryError(value);
        }
        if (!check.canWrite()) {
            return Messages.LocalFileStorageProvider_DirectoryNotWritableError(value);
        }
        return null;
    }

    @Extension
    public static class LocalFileStorageProviderDescriptor
    extends AbstractStorageProvider.StorageProviderDescriptor {
        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public FormValidation doCheckDirectory(@QueryParameter String value) {
            String errorMsg = LocalFileStorageProvider.validateDirectory(value);
            if (errorMsg != null) {
                return FormValidation.error((String)errorMsg);
            }
            return FormValidation.ok();
        }
    }
}

