/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.storage;

import com.google.api.client.util.Lists;
import com.google.common.base.Objects;
import com.google.jenkins.plugins.persistentmaster.VersionUtility;
import com.google.jenkins.plugins.persistentmaster.storage.Storage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class LocalFileStorage
implements Storage {
    private static final String LAST_BACKUP_FILE = "last-backup";
    private static final String EXISTING_FILE_METADATA = "existing-files-metadata";
    private static final String COMMENT_PREFIX = "#";
    private static final String COMMENT_LINE = "# This file contains the filename of the last backup.";
    private static final String EXISTING_FILES_COMMENT_LINE = "# This file contains the existing files meta data.";
    private final Path storageDir;

    public LocalFileStorage(Path storageDir) {
        this.storageDir = storageDir;
    }

    @Override
    public void storeFile(Path localFile, String filename) throws IOException {
        Files.copy(localFile, this.storageDir.resolve(filename), new CopyOption[0]);
    }

    @Override
    public void loadFile(String filename, Path target) throws IOException {
        Files.copy(this.storageDir.resolve(filename), target, new CopyOption[0]);
    }

    @Override
    public void deleteFile(String filename) throws IOException {
        Files.delete(this.storageDir.resolve(filename));
    }

    @Override
    public List<String> listFiles() throws IOException {
        LinkedList<String> files = new LinkedList<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.storageDir);){
            for (Path next : directoryStream) {
                Path fileName = next.getFileName();
                if (fileName == null || fileName.toString().equals(LAST_BACKUP_FILE)) continue;
                files.add(fileName.toString());
            }
        }
        return files;
    }

    @Override
    public List<String> listMetadataForExistingFiles() throws IOException {
        LinkedList fileMetadata = this.listDataFromStorage(EXISTING_FILE_METADATA);
        return fileMetadata == null ? new LinkedList() : fileMetadata;
    }

    @Override
    public List<String> findLatestBackup() throws IOException {
        return this.listDataFromStorage(LAST_BACKUP_FILE);
    }

    @Override
    public String getVersionInfo() {
        return VersionUtility.getFileSystemVersion(this.storageDir);
    }

    private List<String> listDataFromStorage(String name) throws IOException {
        Path path = this.storageDir.resolve(name);
        if (Files.exists(path, new LinkOption[0])) {
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            LinkedList<String> filenames = new LinkedList<String>();
            for (String line : lines) {
                if (line == null || line.trim().isEmpty() || line.startsWith(COMMENT_PREFIX)) continue;
                filenames.add(line.trim());
            }
            return filenames;
        }
        return null;
    }

    @Override
    public void updateLastBackup(List<String> filenames) throws IOException {
        this.updateObject(filenames, LAST_BACKUP_FILE, COMMENT_LINE);
    }

    @Override
    public void updateExistingFilesMetaData(Set<String> filenames) throws IOException {
        this.updateObject(Lists.newArrayList(filenames), EXISTING_FILE_METADATA, EXISTING_FILES_COMMENT_LINE);
    }

    @Override
    public void updateVersionInfo(String version) throws IOException {
        VersionUtility.updateFileSystemVersion(this.storageDir, version);
    }

    public void updateObject(List<String> filenames, String name, String comment) throws IOException {
        Path path = this.storageDir.resolve(name);
        LinkedList<String> content = new LinkedList<String>(filenames);
        content.addFirst(comment);
        Files.write(path, content, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFileStorage that = (LocalFileStorage)o;
        return !(this.storageDir != null ? !this.storageDir.equals(that.storageDir) : that.storageDir != null);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.storageDir});
    }

    public String toString() {
        String string = String.valueOf("LocalFileStorage{storageDir=");
        String string2 = String.valueOf(this.storageDir);
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append("}").toString();
    }
}

