/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.jenkins.plugins.persistentmaster.storage.AbstractStorageProvider;
import com.google.jenkins.plugins.persistentmaster.storage.GcloudGcsStorage;
import com.google.jenkins.plugins.persistentmaster.storage.Messages;
import com.google.jenkins.plugins.persistentmaster.storage.Storage;
import hudson.Extension;
import hudson.util.FormValidation;
import javax.annotation.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GcloudGcsStorageProvider
extends AbstractStorageProvider {
    @VisibleForTesting
    public static final String DISPLAY_NAME = Messages.GcloudGcsStorageProvider_DisplayName();
    private final String bucket;

    @DataBoundConstructor
    public GcloudGcsStorageProvider(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    @Override
    public Storage getStorage() {
        return new GcloudGcsStorage(this.bucket);
    }

    @Override
    public boolean isValid() {
        return GcloudGcsStorageProvider.validateBucket(this.bucket) == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcloudGcsStorageProvider that = (GcloudGcsStorageProvider)o;
        return !(this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bucket});
    }

    public String toString() {
        String string = String.valueOf("GcloudGcsStorageProvider{bucket='");
        String string2 = this.bucket;
        return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append("'").append("}").toString();
    }

    @Nullable
    @VisibleForTesting
    public static String validateBucket(String value) {
        if (value == null) {
            return Messages.GcloudGcsStorageProvider_BucketRequiredError();
        }
        if (Strings.isNullOrEmpty((String)(value = value.trim()))) {
            return Messages.GcloudGcsStorageProvider_BucketRequiredError();
        }
        return null;
    }

    @Extension
    public static class GcloudGcsStorageProviderDescriptor
    extends AbstractStorageProvider.StorageProviderDescriptor {
        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public FormValidation doCheckBucket(@QueryParameter String value) {
            String errorMsg = GcloudGcsStorageProvider.validateBucket(value);
            if (errorMsg != null) {
                return FormValidation.error((String)errorMsg);
            }
            return FormValidation.ok();
        }
    }
}

