/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.scope;

import com.google.jenkins.plugins.persistentmaster.scope.ForwardingScope;
import com.google.jenkins.plugins.persistentmaster.scope.Scope;
import com.google.jenkins.plugins.persistentmaster.volume.ForwardingVolumeCreator;
import com.google.jenkins.plugins.persistentmaster.volume.Volume;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;

public class FilteringScope
extends ForwardingScope {
    private final Set<String> exclusions = new HashSet<String>();

    public FilteringScope(Scope scope) {
        super(scope);
    }

    public void addExclusion(String exclusion) {
        this.exclusions.add(exclusion);
    }

    @Override
    public void addFiles(Path jenkinsHome, Volume.Creator creator, Set<String> existingFileMetadata) throws IOException {
        super.addFiles(jenkinsHome, new ForwardingVolumeCreator(creator){

            @Override
            public void addFile(Path file, String pathInVolume, BasicFileAttributes attrs) throws IOException {
                if (!FilteringScope.this.exclusions.contains(pathInVolume)) {
                    super.addFile(file, pathInVolume, attrs);
                }
            }
        }, existingFileMetadata);
    }
}

