/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.scope;

import com.google.common.annotations.VisibleForTesting;
import com.google.jenkins.plugins.persistentmaster.scope.ConfigurableScope;
import com.google.jenkins.plugins.persistentmaster.scope.Messages;
import com.google.jenkins.plugins.persistentmaster.scope.Scopes;
import com.google.jenkins.plugins.persistentmaster.volume.Volume;
import hudson.Extension;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultBackupScope
extends ConfigurableScope {
    @VisibleForTesting
    public static final String DISPLAY_NAME = Messages.DefaultBackupScope_DisplayName();

    @DataBoundConstructor
    public DefaultBackupScope() {
    }

    @Override
    public String getScopeName() {
        return "Default";
    }

    @Override
    public void addFiles(Path jenkinsHome, Volume.Creator creator, Set<String> existingFileMetadata) throws IOException {
        HashSet<Path> excludedDirs = new HashSet<Path>();
        excludedDirs.add(jenkinsHome.resolve("container-tmp"));
        excludedDirs.add(jenkinsHome.resolve("garbage"));
        excludedDirs.add(jenkinsHome.resolve("backup-tmp"));
        excludedDirs.add(jenkinsHome.resolve(".restore.log"));
        excludedDirs.add(jenkinsHome.resolve("lost+found"));
        excludedDirs.add(jenkinsHome.resolve(".m2"));
        excludedDirs.add(jenkinsHome.resolve("workspace"));
        excludedDirs.add(jenkinsHome.resolve("war"));
        excludedDirs.add(jenkinsHome.resolve("jobs/*/branches/*/workspace"));
        Scopes.addAllFilesIn(jenkinsHome, creator, excludedDirs, existingFileMetadata);
    }

    @Override
    public void extractFiles(Path jenkinsHome, Volume.Extractor extractor, boolean overwrite, Map<String, Boolean> existingFileMetadataMap) throws IOException {
        Scopes.extractAllFilesTo(jenkinsHome, extractor, overwrite, existingFileMetadataMap);
    }

    @Extension
    public static class DefaultBackupScopeDescriptor
    extends ConfigurableScope.ConfigurableScopeDescriptor {
        public String getDisplayName() {
            return DISPLAY_NAME;
        }
    }
}

