/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.backup;

import com.google.jenkins.plugins.persistentmaster.VersionUtility;
import com.google.jenkins.plugins.persistentmaster.history.BackupHistory;
import com.google.jenkins.plugins.persistentmaster.scope.Scope;
import com.google.jenkins.plugins.persistentmaster.storage.Storage;
import com.google.jenkins.plugins.persistentmaster.volume.Volume;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class BackupProcedure {
    private static final Logger logger = Logger.getLogger(BackupProcedure.class.getName());
    private static final String TMP_DIR_PREFIX = "google-cloud-backup-plugin";
    private final Volume volume;
    private final Scope scope;
    private final Storage storage;
    private final BackupHistory backupHistory;
    private final Path jenkinsHome;
    private final Path tempDir;
    private final String backupNameSuffix;

    public BackupProcedure(Volume volume, Scope scope, Storage storage, BackupHistory backupHistory, Path jenkinsHome, @Nullable Path tempDir, @Nullable String backupNameSuffix) {
        this.volume = volume;
        this.scope = scope;
        this.storage = storage;
        this.backupHistory = backupHistory;
        this.jenkinsHome = jenkinsHome;
        this.tempDir = tempDir;
        this.backupNameSuffix = backupNameSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateTime performBackup() throws IOException {
        logger.fine("Start creating backup");
        DateTime backupTime = new DateTime(DateTimeZone.UTC);
        if (this.tempDir != null) {
            Files.createDirectories(this.tempDir, new FileAttribute[0]);
        }
        Path tempDirectory = this.tempDir == null ? Files.createTempDirectory(TMP_DIR_PREFIX, new FileAttribute[0]) : Files.createTempDirectory(this.tempDir, TMP_DIR_PREFIX, new FileAttribute[0]);
        String string = BackupProcedure.calculateBackupName(backupTime);
        String string2 = this.backupNameSuffix != null ? this.backupNameSuffix : "";
        String string3 = this.volume.getFileExtension();
        String backupVolumeName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(".").append(string3).toString();
        string = String.valueOf(tempDirectory);
        logger.fine(new StringBuilder(27 + String.valueOf(string).length()).append("Using temporary directory: ").append(string).toString());
        Path volumePath = tempDirectory.resolve(Paths.get(backupVolumeName, new String[0]));
        try {
            int fileCount;
            logger.fine("Creating backup volume");
            HashSet<String> existingFileNames = new HashSet<String>();
            try (Volume.Creator creator2 = this.volume.createNew(volumePath);){
                this.scope.addFiles(this.jenkinsHome, creator2, existingFileNames);
                fileCount = creator2.getFileCount();
            }
            if (fileCount > 0) {
                logger.fine("Storing backup volume");
                this.storage.storeFile(volumePath, backupVolumeName);
                logger.fine("Updating last backup reference");
                this.storage.updateLastBackup(Arrays.asList(backupVolumeName));
                logger.fine("Applying backup history policy");
                this.backupHistory.processHistoricBackups(this.storage, backupVolumeName);
            } else {
                logger.fine("Volume is empty, will skip storing backup");
            }
            int creator2 = existingFileNames.size();
            logger.fine(new StringBuilder(50).append("Updating list of existing files : Size ").append(creator2).toString());
            this.storage.updateExistingFilesMetaData(existingFileNames);
            String version = VersionUtility.getFileSystemVersion(this.jenkinsHome);
            String string4 = String.valueOf(version);
            logger.fine(string4.length() != 0 ? "Updating version : ".concat(string4) : new String("Updating version : "));
            this.storage.updateVersionInfo(version);
        }
        finally {
            try {
                logger.fine("Deleting local backup volume");
                Files.deleteIfExists(volumePath);
                logger.fine("Deleting temp directory");
                Files.deleteIfExists(tempDirectory);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "IOException while performing cleanup", e);
            }
        }
        logger.fine("Finished creating backup");
        return backupTime;
    }

    private static String calculateBackupName(DateTime backupTime) {
        return String.format("backup-%d%02d%02d%02d%02d%02d", backupTime.getYear(), backupTime.getMonthOfYear(), backupTime.getDayOfMonth(), backupTime.getHourOfDay(), backupTime.getMinuteOfHour(), backupTime.getSecondOfMinute());
    }
}

