/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.autorestore;

import com.google.common.base.Preconditions;
import com.google.jenkins.plugins.persistentmaster.PersistentMasterPlugin;
import com.google.jenkins.plugins.persistentmaster.autorestore.RestoreLog;
import com.google.jenkins.plugins.persistentmaster.initiation.InitiationStrategy;
import hudson.lifecycle.RestartNotSupportedException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class RestartAfterRestoreStrategy
implements InitiationStrategy {
    private static final String SUCCESS_MESSAGE = " successfully restored at time: ";
    private static final String RESTORE_LOG_FILENAME = ".restore.log";
    private static final Logger logger = Logger.getLogger(RestartAfterRestoreStrategy.class.getName());
    private final RestoreLog restoreLog;

    public RestartAfterRestoreStrategy(RestoreLog restoreLog) {
        this.restoreLog = restoreLog;
    }

    @Override
    public void initializeNewEnvironment(Path jenkinsHome) throws IOException {
        logger.info("Initialized new environment.");
    }

    @Override
    public void initializeRestoredEnvironment(Path jenkinsHome, String lastBackupId) throws IOException {
        Preconditions.checkNotNull((Object)lastBackupId);
        String string = String.valueOf(lastBackupId);
        logger.fine(string.length() != 0 ? "Checking if restart is needed after restoring backup: ".concat(string) : new String("Checking if restart is needed after restoring backup: "));
        String loggedBackupId = this.restoreLog.getLastBackupId();
        if (lastBackupId.equals(loggedBackupId)) {
            logger.info("Jenkins successfully restored from backup.");
            return;
        }
        if (loggedBackupId != null) {
            logger.fine(new StringBuilder(72 + String.valueOf(lastBackupId).length() + String.valueOf(loggedBackupId).length()).append("Last restored backup id: ").append(lastBackupId).append(" does not match last backup id in restore log: ").append(loggedBackupId).toString());
            logger.fine("Writing new backup id and restarting Jenkins.");
        } else {
            logger.fine(new StringBuilder(47 + String.valueOf(lastBackupId).length()).append("Writing new backup id: ").append(lastBackupId).append(" and restarting Jenkins.").toString());
        }
        this.restoreLog.writeLastBackupId(lastBackupId);
        logger.info(new StringBuilder(48 + String.valueOf(lastBackupId).length()).append("Restored data from backup: ").append(lastBackupId).append("; restarting Jenkins.").toString());
        PersistentMasterPlugin plugin = PersistentMasterPlugin.getInstance();
        try {
            if (plugin != null) {
                plugin.setSkipBackupOnNextRestart(true);
            }
            Jenkins.getActiveInstance().restart();
        }
        catch (RestartNotSupportedException e) {
            if (plugin != null) {
                plugin.setSkipBackupOnNextRestart(false);
            }
            String string2 = String.valueOf(lastBackupId);
            logger.warning(string2.length() != 0 ? "Could not restart Jenkins after restoring backup: ".concat(string2) : new String("Could not restart Jenkins after restoring backup: "));
        }
    }
}

