/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.autorestore;

import com.google.jenkins.plugins.persistentmaster.PersistentMasterMainModule;
import com.google.jenkins.plugins.persistentmaster.PersistentMasterPlugin;
import com.google.jenkins.plugins.persistentmaster.autorestore.RestartAfterRestoreStrategy;
import com.google.jenkins.plugins.persistentmaster.autorestore.RestoreLog;
import com.google.jenkins.plugins.persistentmaster.restore.RestoreProcedure;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Logger;

public class AutoRestoreInitializer {
    private static final Logger logger = Logger.getLogger(AutoRestoreInitializer.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void init() throws IOException {
        logger.info("Checking if backups need to be restored.");
        PersistentMasterPlugin plugin = PersistentMasterPlugin.getInstance();
        if (plugin == null) {
            AutoRestoreInitializer.logRestoreFailure("No persistent master plugin found.");
            return;
        }
        try {
            PersistentMasterMainModule module = plugin.getPersistentMasterMainModule();
            if (module == null) {
                AutoRestoreInitializer.logRestoreFailure("No persistent master plugin configuration found.");
                return;
            }
            if (!plugin.getEnableAutoRestore()) {
                logger.info("Automatic restores are disabled.");
                return;
            }
            if (module.getVolume() == null || module.getScope() == null || module.getStorage() == null) {
                AutoRestoreInitializer.logRestoreFailure("Persistent master plugin configuration did not specify a usable backup storage provider to restore from.");
                return;
            }
            Path jenkinsHomePath = plugin.calculateJenkinsHome();
            Path scratchDirectory = plugin.getScratchDirectory();
            if (jenkinsHomePath == null) {
                AutoRestoreInitializer.logRestoreFailure("Persistent master plugin could not locate Jenkins home directory.");
                return;
            }
            Object object = RestoreLog.getLock();
            synchronized (object) {
                RestoreProcedure restoreProcedure = new RestoreProcedure(module.getVolume(), module.getScope(), module.getStorage(), new RestartAfterRestoreStrategy(new RestoreLog(jenkinsHomePath)), jenkinsHomePath, scratchDirectory, plugin.getRestoreOverwritesData());
                try {
                    restoreProcedure.performRestore();
                }
                catch (IOException | RuntimeException e) {
                    throw new IllegalStateException("Could not restore and initialize jenkins", e);
                }
            }
        }
        finally {
            plugin.endBackupOrRestore();
        }
    }

    private static void logRestoreFailure(String message) {
        String string = String.valueOf(message);
        logger.warning(string.length() != 0 ? "Cannot restore from backup: ".concat(string) : new String("Cannot restore from backup: "));
    }
}

